/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateTestBase;
import org.apache.flink.runtime.state.metrics.LatencyTrackingValueState;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class LatencyTrackingValueStateTest
extends LatencyTrackingStateTestBase<Integer> {
    LatencyTrackingValueStateTest() {
    }

    ValueStateDescriptor<Long> getStateDescriptor() {
        return new ValueStateDescriptor("value", Long.class);
    }

    IntSerializer getKeySerializer() {
        return IntSerializer.INSTANCE;
    }

    @Override
    void setCurrentKey(AbstractKeyedStateBackend<Integer> keyedBackend) {
        keyedBackend.setCurrentKey((Object)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testLatencyTrackingValueState() throws Exception {
        AbstractKeyedStateBackend keyedBackend = this.createKeyedBackend(this.getKeySerializer());
        try {
            LatencyTrackingValueState latencyTrackingState = (LatencyTrackingValueState)this.createLatencyTrackingState(keyedBackend, this.getStateDescriptor());
            latencyTrackingState.setCurrentNamespace((Object)VoidNamespace.INSTANCE);
            LatencyTrackingValueState.ValueStateLatencyMetrics latencyTrackingStateMetric = (LatencyTrackingValueState.ValueStateLatencyMetrics)latencyTrackingState.getLatencyTrackingStateMetric();
            Assertions.assertThat((int)latencyTrackingStateMetric.getUpdateCount()).isZero();
            Assertions.assertThat((int)latencyTrackingStateMetric.getGetCount()).isZero();
            this.setCurrentKey((AbstractKeyedStateBackend<Integer>)keyedBackend);
            for (int index = 1; index <= 10; ++index) {
                int expectedResult = index == 10 ? 0 : index;
                latencyTrackingState.update((Object)ThreadLocalRandom.current().nextLong());
                Assertions.assertThat((int)latencyTrackingStateMetric.getUpdateCount()).isEqualTo(expectedResult);
                latencyTrackingState.value();
                Assertions.assertThat((int)latencyTrackingStateMetric.getGetCount()).isEqualTo(expectedResult);
            }
        }
        finally {
            if (keyedBackend != null) {
                keyedBackend.close();
                keyedBackend.dispose();
            }
        }
    }
}

