/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.RunnableFuture;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.KeyGroupedInternalPriorityQueue;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.PriorityComparable;
import org.apache.flink.runtime.state.SavepointResources;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.StateSnapshotTransformer;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueElement;
import org.apache.flink.util.function.FunctionWithException;

public class StateBackendTestUtils {
    public static AbstractStateBackend wrapStateBackendWithSnapshotFunction(AbstractStateBackend delegatedStataBackend, SerializableFunctionWithException<RunnableFuture<SnapshotResult<KeyedStateHandle>>> snapshotResultFunction) {
        return new ApplyingSnapshotStateBackend(delegatedStataBackend, snapshotResultFunction);
    }

    private StateBackendTestUtils() {
    }

    @FunctionalInterface
    public static interface SerializableFunctionWithException<T>
    extends FunctionWithException<T, T, Exception>,
    Serializable {
    }

    private static class ApplyingSnapshotStateBackend
    extends AbstractStateBackend {
        private static final long serialVersionUID = 1L;
        private final AbstractStateBackend delegatedStataBackend;
        private final SerializableFunctionWithException<RunnableFuture<SnapshotResult<KeyedStateHandle>>> snapshotResultFunction;

        public ApplyingSnapshotStateBackend(AbstractStateBackend delegatedStataBackend, SerializableFunctionWithException<RunnableFuture<SnapshotResult<KeyedStateHandle>>> snapshotResultFunction) {
            this.delegatedStataBackend = delegatedStataBackend;
            this.snapshotResultFunction = snapshotResultFunction;
        }

        public boolean useManagedMemory() {
            return this.delegatedStataBackend.useManagedMemory();
        }

        public <K> AbstractKeyedStateBackend<K> createKeyedStateBackend(StateBackend.KeyedStateBackendParameters<K> parameters) throws IOException {
            final AbstractKeyedStateBackend delegatedKeyedStateBackend = this.delegatedStataBackend.createKeyedStateBackend(parameters);
            return new AbstractKeyedStateBackend<K>(parameters.getKvStateRegistry(), parameters.getKeySerializer(), parameters.getEnv().getUserCodeClassLoader().asClassLoader(), parameters.getEnv().getExecutionConfig(), parameters.getTtlTimeProvider(), delegatedKeyedStateBackend.getLatencyTrackingStateConfig(), parameters.getCancelStreamRegistry(), delegatedKeyedStateBackend.getKeyContext()){

                public void setCurrentKey(K newKey) {
                    delegatedKeyedStateBackend.setCurrentKey(newKey);
                }

                public void notifyCheckpointComplete(long checkpointId) throws Exception {
                    delegatedKeyedStateBackend.notifyCheckpointComplete(checkpointId);
                }

                @Nonnull
                public SavepointResources<K> savepoint() throws Exception {
                    return delegatedKeyedStateBackend.savepoint();
                }

                public int numKeyValueStateEntries() {
                    return delegatedKeyedStateBackend.numKeyValueStateEntries();
                }

                public <N> Stream<K> getKeys(String state, N namespace) {
                    return delegatedKeyedStateBackend.getKeys(state, namespace);
                }

                public <N> Stream<Tuple2<K, N>> getKeysAndNamespaces(String state) {
                    return delegatedKeyedStateBackend.getKeysAndNamespaces(state);
                }

                @Nonnull
                public <N, SV, SEV, S extends State, IS extends S> IS createOrUpdateInternalState(@Nonnull TypeSerializer<N> namespaceSerializer, @Nonnull StateDescriptor<S, SV> stateDesc, @Nonnull StateSnapshotTransformer.StateSnapshotTransformFactory<SEV> snapshotTransformFactory) throws Exception {
                    return (IS)delegatedKeyedStateBackend.createOrUpdateInternalState(namespaceSerializer, stateDesc, snapshotTransformFactory);
                }

                @Nonnull
                public <T extends HeapPriorityQueueElement & PriorityComparable<? super T>> KeyGroupedInternalPriorityQueue<T> create(@Nonnull String stateName, @Nonnull TypeSerializer<T> byteOrderedElementSerializer) {
                    return delegatedKeyedStateBackend.create(stateName, byteOrderedElementSerializer);
                }

                @Nonnull
                public RunnableFuture<SnapshotResult<KeyedStateHandle>> snapshot(long checkpointId, long timestamp, @Nonnull CheckpointStreamFactory streamFactory, @Nonnull CheckpointOptions checkpointOptions) throws Exception {
                    RunnableFuture snapshotResultRunnableFuture = delegatedKeyedStateBackend.snapshot(checkpointId, timestamp, streamFactory, checkpointOptions);
                    return (RunnableFuture)snapshotResultFunction.apply(snapshotResultRunnableFuture);
                }

                public void dispose() {
                    super.dispose();
                    delegatedKeyedStateBackend.dispose();
                }

                public void close() throws IOException {
                    super.close();
                    delegatedKeyedStateBackend.close();
                }
            };
        }

        public OperatorStateBackend createOperatorStateBackend(StateBackend.OperatorStateBackendParameters parameters) throws Exception {
            return this.delegatedStataBackend.createOperatorStateBackend(parameters);
        }
    }
}

