/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.runtime.state.ConfigurableStateBackend;
import org.apache.flink.runtime.state.StateBackendTestBase;
import org.apache.flink.runtime.state.filesystem.FsStateBackend;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={ParameterizedTestExtension.class})
public class FileStateBackendTest
extends StateBackendTestBase<FsStateBackend> {
    @Parameter
    public boolean useAsyncMode;
    @TempDir
    private Path tempFolder;

    @Parameters
    public static List<Boolean> modes() {
        return Arrays.asList(true, false);
    }

    @Override
    protected ConfigurableStateBackend getStateBackend() throws Exception {
        File checkpointPath = TempDirUtils.newFolder((Path)this.tempFolder);
        return new FsStateBackend(checkpointPath.toURI(), this.useAsyncMode);
    }

    @Override
    protected boolean isSerializerPresenceRequiredOnRestore() {
        return true;
    }

    @Override
    protected boolean supportsAsynchronousSnapshots() {
        return this.useAsyncMode;
    }

    @Override
    @TestTemplate
    void testValueStateRestoreWithWrongSerializers() {
    }

    @Override
    @TestTemplate
    void testListStateRestoreWithWrongSerializers() {
    }

    @Override
    @TestTemplate
    void testReducingStateRestoreWithWrongSerializers() {
    }

    @Override
    @TestTemplate
    void testMapStateRestoreWithWrongSerializers() {
    }

    @Override
    @Disabled
    @TestTemplate
    void testConcurrentMapIfQueryable() throws Exception {
        super.testConcurrentMapIfQueryable();
    }
}

