/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.runtime.scheduler.adaptive.Created;
import org.apache.flink.runtime.scheduler.adaptive.CreatedTest;
import org.apache.flink.runtime.scheduler.adaptive.WaitingForResources;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StateTest {
    private static final Logger LOG = LoggerFactory.getLogger(StateTest.class);
    @RegisterExtension
    CreatedTest.MockCreatedContext ctx = new CreatedTest.MockCreatedContext();

    StateTest() {
    }

    @Test
    void testEmptyAs() {
        Created state = new Created((Created.Context)this.ctx, LOG);
        Assertions.assertThat((Optional)state.as(WaitingForResources.class)).isEmpty();
    }

    @Test
    void testCast() {
        Created state = new Created((Created.Context)this.ctx, LOG);
        Assertions.assertThat((Optional)state.as(Created.class)).hasValue((Object)state);
    }

    @Test
    void testTryRunStateMismatch() {
        Created state = new Created((Created.Context)this.ctx, LOG);
        state.tryRun(WaitingForResources.class, waiting -> Assertions.fail((String)"Unexpected execution"), "test");
    }

    @Test
    void testTryRun() {
        Created state = new Created((Created.Context)this.ctx, LOG);
        AtomicBoolean called = new AtomicBoolean(false);
        state.tryRun(Created.class, created -> called.set(true), "test");
        Assertions.assertThat((AtomicBoolean)called).isTrue();
    }

    @Test
    void testTryCallStateMismatch() {
        Created state = new Created((Created.Context)this.ctx, LOG);
        Optional result = state.tryCall(WaitingForResources.class, Waiting -> {
            Assertions.fail((String)"Unexpected execution");
            return "nope";
        }, "test");
        Assertions.assertThat((Optional)result).isEmpty();
    }

    @Test
    void testTryCall() {
        Created state = new Created((Created.Context)this.ctx, LOG);
        Optional result = state.tryCall(Created.class, created -> "yes", "test");
        Assertions.assertThat((Optional)result).hasValue((Object)"yes");
    }
}

