/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.messages.AggregatedTaskDetailsInfo;
import org.apache.flink.runtime.rest.messages.JobVertexTaskManagersInfo;
import org.apache.flink.runtime.rest.messages.RestResponseMarshallingTestBase;
import org.apache.flink.runtime.rest.messages.job.metrics.IOMetricsInfo;
import org.apache.flink.testutils.junit.extensions.parameterized.NoOpTestExtension;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={NoOpTestExtension.class})
class JobVertexTaskManagersInfoTest
extends RestResponseMarshallingTestBase<JobVertexTaskManagersInfo> {
    JobVertexTaskManagersInfoTest() {
    }

    @Override
    protected Class<JobVertexTaskManagersInfo> getTestResponseClass() {
        return JobVertexTaskManagersInfo.class;
    }

    @Override
    protected JobVertexTaskManagersInfo getTestResponseInstance() throws Exception {
        Random random = new Random();
        ArrayList<JobVertexTaskManagersInfo.TaskManagersInfo> taskManagersInfoList = new ArrayList<JobVertexTaskManagersInfo.TaskManagersInfo>();
        HashMap<ExecutionState, Integer> statusCounts = new HashMap<ExecutionState, Integer>(ExecutionState.values().length);
        IOMetricsInfo jobVertexMetrics = new IOMetricsInfo(random.nextLong(), random.nextBoolean(), random.nextLong(), random.nextBoolean(), random.nextLong(), random.nextBoolean(), random.nextLong(), random.nextBoolean(), Math.abs(random.nextLong()), Math.abs(random.nextLong()), Math.abs(random.nextDouble()));
        int count = 100;
        for (ExecutionState executionState : ExecutionState.values()) {
            statusCounts.put(executionState, count++);
        }
        taskManagersInfoList.add(new JobVertexTaskManagersInfo.TaskManagersInfo("host1", "host1:123", ExecutionState.CANCELING, 1L, 2L, 3L, jobVertexMetrics, statusCounts, "taskmanagerId", AggregatedTaskDetailsInfo.create(Collections.emptyList())));
        return new JobVertexTaskManagersInfo(new JobVertexID(), "test", System.currentTimeMillis(), taskManagersInfoList);
    }
}

