/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.flink.runtime.metrics.TimerGauge;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.ManualClock;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TimerGaugeTest {
    private static final long SLEEP = 10L;

    TimerGaugeTest() {
    }

    @Test
    void testBasicUsage() {
        ManualClock clock = new ManualClock(42000000L);
        TimerGauge gauge = new TimerGauge((Clock)clock, 5);
        gauge.update();
        Assertions.assertThat((Long)gauge.getValue()).isZero();
        Assertions.assertThat((long)gauge.getMaxSingleMeasurement()).isZero();
        Assertions.assertThat((long)gauge.getAccumulatedCount()).isZero();
        gauge.markStart();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        gauge.markEnd();
        gauge.update();
        Assertions.assertThat((Long)gauge.getValue()).isGreaterThanOrEqualTo(2L);
        Assertions.assertThat((long)gauge.getMaxSingleMeasurement()).isEqualTo(10L);
        Assertions.assertThat((long)gauge.getAccumulatedCount()).isEqualTo(10L);
        gauge.markStart();
        clock.advanceTime(5L, TimeUnit.MILLISECONDS);
        gauge.markEnd();
        gauge.update();
        Assertions.assertThat((long)gauge.getMaxSingleMeasurement()).isEqualTo(5L);
        Assertions.assertThat((long)gauge.getAccumulatedCount()).isEqualTo(15L);
    }

    @Test
    void testUpdateWithoutMarkingEnd() {
        ManualClock clock = new ManualClock(42000000L);
        TimerGauge gauge = new TimerGauge((Clock)clock, 5);
        gauge.markStart();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        gauge.update();
        Assertions.assertThat((Long)gauge.getValue()).isGreaterThanOrEqualTo(2L);
        Assertions.assertThat((long)gauge.getMaxSingleMeasurement()).isEqualTo(10L);
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        gauge.update();
        Assertions.assertThat((Long)gauge.getValue()).isGreaterThanOrEqualTo(2L);
        Assertions.assertThat((long)gauge.getMaxSingleMeasurement()).isEqualTo(20L);
    }

    @Test
    void testGetWithoutUpdate() {
        ManualClock clock = new ManualClock(42000000L);
        TimerGauge gauge = new TimerGauge((Clock)clock);
        gauge.markStart();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        Assertions.assertThat((Long)gauge.getValue()).isZero();
        gauge.markEnd();
        Assertions.assertThat((Long)gauge.getValue()).isZero();
        Assertions.assertThat((long)gauge.getMaxSingleMeasurement()).isZero();
    }

    @Test
    void testLargerTimespan() {
        ManualClock clock = new ManualClock(42000000L);
        TimerGauge gauge = new TimerGauge((Clock)clock, 10);
        gauge.markStart();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        gauge.markEnd();
        gauge.update();
        Assertions.assertThat((Long)gauge.getValue()).isEqualTo(2L);
        Assertions.assertThat((long)gauge.getMaxSingleMeasurement()).isEqualTo(10L);
        Assertions.assertThat((long)gauge.getAccumulatedCount()).isEqualTo(10L);
        gauge.update();
        Assertions.assertThat((Long)gauge.getValue()).isEqualTo(1L);
        Assertions.assertThat((long)gauge.getMaxSingleMeasurement()).isZero();
        Assertions.assertThat((long)gauge.getAccumulatedCount()).isEqualTo(10L);
        gauge.markStart();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        gauge.markEnd();
        gauge.update();
        gauge.markStart();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        gauge.markEnd();
        gauge.update();
        Assertions.assertThat((Long)gauge.getValue()).isEqualTo(2L);
        gauge.markStart();
        clock.advanceTime(5L, TimeUnit.MILLISECONDS);
        gauge.markEnd();
        gauge.update();
        Assertions.assertThat((long)gauge.getMaxSingleMeasurement()).isEqualTo(5L);
        Assertions.assertThat((long)gauge.getAccumulatedCount()).isEqualTo(35L);
    }
}

