/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.reader;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.EndOfSuperstepEvent;
import org.apache.flink.runtime.io.network.api.reader.AbstractReader;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.util.event.EventListener;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class AbstractReaderTest {
    AbstractReaderTest() {
    }

    @Test
    void testTaskEvent() throws Exception {
        MockReader reader = new MockReader(AbstractReaderTest.createInputGate(1));
        EventListener listener1 = (EventListener)Mockito.mock(EventListener.class);
        EventListener listener2 = (EventListener)Mockito.mock(EventListener.class);
        EventListener listener3 = (EventListener)Mockito.mock(EventListener.class);
        reader.registerTaskEventListener(listener1, TestTaskEvent1.class);
        reader.registerTaskEventListener(listener2, TestTaskEvent2.class);
        reader.registerTaskEventListener(listener3, TaskEvent.class);
        reader.handleEvent((AbstractEvent)new TestTaskEvent1());
        reader.handleEvent((AbstractEvent)new TestTaskEvent2());
        ((EventListener)Mockito.verify((Object)listener1, (VerificationMode)Mockito.times((int)1))).onEvent(Matchers.any(TaskEvent.class));
        ((EventListener)Mockito.verify((Object)listener2, (VerificationMode)Mockito.times((int)1))).onEvent(Matchers.any(TaskEvent.class));
        ((EventListener)Mockito.verify((Object)listener3, (VerificationMode)Mockito.times((int)0))).onEvent(Matchers.any(TaskEvent.class));
    }

    @Test
    void testEndOfPartitionEvent() throws Exception {
        MockReader reader = new MockReader(AbstractReaderTest.createInputGate(1));
        Assertions.assertThat((boolean)reader.handleEvent((AbstractEvent)EndOfPartitionEvent.INSTANCE)).isTrue();
    }

    @Test
    void testExceptionsNonIterativeReader() {
        MockReader reader = new MockReader(AbstractReaderTest.createInputGate(4));
        Assertions.assertThat((boolean)reader.hasReachedEndOfSuperstep()).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((AbstractReader)reader).startNextSuperstep()).withFailMessage("Did not throw expected exception when starting next superstep with non-iterative reader.", new Object[0])).isInstanceOf(IllegalStateException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> reader.handleEvent((AbstractEvent)EndOfSuperstepEvent.INSTANCE)).withFailMessage("Did not throw expected exception when handling end of superstep event with non-iterative reader.", new Object[0])).hasCauseInstanceOf(IllegalStateException.class).isInstanceOf(IOException.class);
    }

    @Test
    void testEndOfSuperstepEventLogic() throws IOException {
        int numberOfInputChannels = 4;
        MockReader reader = new MockReader(AbstractReaderTest.createInputGate(4));
        reader.setIterativeReader();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((AbstractReader)reader).startNextSuperstep()).withFailMessage("Did not throw expected exception when starting next superstep before receiving all end of superstep events.", new Object[0])).isInstanceOf(IllegalStateException.class);
        EndOfSuperstepEvent eos = EndOfSuperstepEvent.INSTANCE;
        for (int i = 0; i < 3; ++i) {
            Assertions.assertThat((boolean)reader.handleEvent((AbstractEvent)eos)).isFalse();
            Assertions.assertThat((boolean)reader.hasReachedEndOfSuperstep()).isFalse();
        }
        Assertions.assertThat((boolean)reader.handleEvent((AbstractEvent)eos)).isTrue();
        Assertions.assertThat((boolean)reader.hasReachedEndOfSuperstep()).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> reader.handleEvent((AbstractEvent)eos)).withFailMessage("Did not throw expected exception when receiving too many end of superstep events.", new Object[0])).isInstanceOf(IOException.class);
        reader.startNextSuperstep();
        Assertions.assertThat((boolean)reader.hasReachedEndOfSuperstep()).isFalse();
    }

    private static InputGate createInputGate(int numberOfInputChannels) {
        InputGate inputGate = (InputGate)Mockito.mock(InputGate.class);
        Mockito.when((Object)inputGate.getNumberOfInputChannels()).thenReturn((Object)numberOfInputChannels);
        return inputGate;
    }

    private static class MockReader
    extends AbstractReader {
        protected MockReader(InputGate inputGate) {
            super(inputGate);
        }
    }

    private static class TestTaskEvent2
    extends TaskEvent {
        private TestTaskEvent2() {
        }

        public void write(DataOutputView out) throws IOException {
        }

        public void read(DataInputView in) throws IOException {
        }
    }

    private static class TestTaskEvent1
    extends TaskEvent {
        private TestTaskEvent1() {
        }

        public void write(DataOutputView out) throws IOException {
        }

        public void read(DataInputView in) throws IOException {
        }
    }
}

