/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.checkpoint.DefaultLastStateConnectionStateListener;
import org.apache.flink.runtime.checkpoint.LastStateConnectionStateListener;
import org.apache.flink.runtime.checkpoint.ZooKeeperCheckpointIDCounter;
import org.apache.flink.runtime.highavailability.zookeeper.CuratorFrameworkWithUnhandledErrorListener;
import org.apache.flink.runtime.rest.util.NoOpFatalErrorHandler;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.runtime.zookeeper.ZooKeeperExtension;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.state.ConnectionState;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class ZKCheckpointIDCounterMultiServersTest {
    @RegisterExtension
    private final EachCallbackWrapper<ZooKeeperExtension> zookeeperExtensionWrapper = new EachCallbackWrapper((CustomExtension)new ZooKeeperExtension());

    ZKCheckpointIDCounterMultiServersTest() {
    }

    @Test
    void testRecoveredAfterConnectionLoss() throws Exception {
        Configuration configuration = new Configuration();
        configuration.set(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, (Object)((ZooKeeperExtension)this.zookeeperExtensionWrapper.getCustomExtension()).getConnectString());
        try (CuratorFrameworkWithUnhandledErrorListener curatorFrameworkWrapper = ZooKeeperUtils.startCuratorFramework((Configuration)configuration, (FatalErrorHandler)NoOpFatalErrorHandler.INSTANCE);){
            OneShotLatch connectionLossLatch = new OneShotLatch();
            OneShotLatch reconnectedLatch = new OneShotLatch();
            TestingLastStateConnectionStateListener listener = new TestingLastStateConnectionStateListener(connectionLossLatch, reconnectedLatch);
            ZooKeeperCheckpointIDCounter idCounter = new ZooKeeperCheckpointIDCounter(curatorFrameworkWrapper.asCuratorFramework(), (LastStateConnectionStateListener)listener);
            idCounter.start();
            long initialID = idCounter.getAndIncrement();
            ((ZooKeeperExtension)this.zookeeperExtensionWrapper.getCustomExtension()).restart();
            connectionLossLatch.await();
            reconnectedLatch.await();
            Assertions.assertThat((long)idCounter.getAndIncrement()).isGreaterThan(initialID);
        }
    }

    private static final class TestingLastStateConnectionStateListener
    extends DefaultLastStateConnectionStateListener {
        private final OneShotLatch connectionLossLatch;
        private final OneShotLatch reconnectedLatch;

        private TestingLastStateConnectionStateListener(OneShotLatch connectionLossLatch, OneShotLatch reconnectedLatch) {
            this.connectionLossLatch = connectionLossLatch;
            this.reconnectedLatch = reconnectedLatch;
        }

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            super.stateChanged(client, newState);
            if (newState == ConnectionState.LOST || newState == ConnectionState.SUSPENDED) {
                this.connectionLossLatch.trigger();
            }
            if (newState == ConnectionState.RECONNECTED) {
                this.reconnectedLatch.trigger();
            }
        }
    }
}

