/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.bash;

import java.io.File;
import java.io.FileWriter;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.util.bash.FlinkConfigLoader;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FlinkConfigLoaderTest
extends TestLogger {
    private static final String TEST_CONFIG_KEY = "test.key";
    private static final String TEST_CONFIG_VALUE = "test_value";
    @Rule
    public TemporaryFolder confDir = new TemporaryFolder(){

        protected void before() throws Throwable {
            super.create();
            File flinkConfFile = this.newFile("flink-conf.yaml");
            FileWriter fw = new FileWriter(flinkConfFile);
            fw.write("test.key: test_value\n");
            fw.close();
        }
    };

    @Test
    public void testLoadConfigurationConfigDirLongOpt() throws Exception {
        String[] args = new String[]{"--configDir", this.confDir.getRoot().getAbsolutePath()};
        Configuration configuration = FlinkConfigLoader.loadConfiguration((String[])args);
        this.verifyConfiguration(configuration, TEST_CONFIG_KEY, TEST_CONFIG_VALUE);
    }

    @Test
    public void testLoadConfigurationConfigDirShortOpt() throws Exception {
        String[] args = new String[]{"-c", this.confDir.getRoot().getAbsolutePath()};
        Configuration configuration = FlinkConfigLoader.loadConfiguration((String[])args);
        this.verifyConfiguration(configuration, TEST_CONFIG_KEY, TEST_CONFIG_VALUE);
    }

    @Test
    public void testLoadConfigurationDynamicPropertyWithSpace() throws Exception {
        String[] args = new String[]{"--configDir", this.confDir.getRoot().getAbsolutePath(), "-D", "key=value"};
        Configuration configuration = FlinkConfigLoader.loadConfiguration((String[])args);
        this.verifyConfiguration(configuration, "key", "value");
    }

    @Test
    public void testLoadConfigurationDynamicPropertyWithoutSpace() throws Exception {
        String[] args = new String[]{"--configDir", this.confDir.getRoot().getAbsolutePath(), "-Dkey=value"};
        Configuration configuration = FlinkConfigLoader.loadConfiguration((String[])args);
        this.verifyConfiguration(configuration, "key", "value");
    }

    @Test
    public void testLoadConfigurationIgnoreUnknownToken() throws Exception {
        String[] args = new String[]{"unknown", "-u", "--configDir", this.confDir.getRoot().getAbsolutePath(), "--unknown", "-Dkey=value"};
        Configuration configuration = FlinkConfigLoader.loadConfiguration((String[])args);
        this.verifyConfiguration(configuration, TEST_CONFIG_KEY, TEST_CONFIG_VALUE);
        this.verifyConfiguration(configuration, "key", "value");
    }

    private void verifyConfiguration(Configuration config, String key, String expectedValue) {
        ConfigOption option = ConfigOptions.key((String)key).stringType().noDefaultValue();
        MatcherAssert.assertThat((Object)config.get(option), (Matcher)CoreMatchers.is((Object)expectedValue));
    }
}

