/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.File;
import java.util.UUID;
import org.apache.flink.runtime.testutils.TestJvmProcess;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.util.OperatingSystem;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingShutdownTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcessShutdownBlocking() throws Exception {
        Assume.assumeTrue((boolean)OperatingSystem.isLinux());
        File markerFile = new File(EnvironmentInformation.getTemporaryFileDirectory(), UUID.randomUUID() + ".marker");
        BlockingShutdownProcess blockingProcess = new BlockingShutdownProcess(markerFile.getAbsolutePath(), 0L, false);
        try {
            blockingProcess.startProcess();
            long pid = blockingProcess.getProcessId();
            Assert.assertTrue((String)"Cannot determine process ID", (pid != -1L ? 1 : 0) != 0);
            TestJvmProcess.waitForMarkerFile(markerFile, 30000L);
            TestJvmProcess.killProcessWithSigTerm(pid);
            Thread.sleep(50L);
            Assert.assertTrue((String)"Test broken, process shutdown blocking does not work", (boolean)blockingProcess.isAlive());
        }
        finally {
            blockingProcess.destroy();
            markerFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcessExitsDespiteBlockingShutdownHook() throws Exception {
        Assume.assumeTrue((boolean)OperatingSystem.isLinux());
        File markerFile = new File(EnvironmentInformation.getTemporaryFileDirectory(), UUID.randomUUID() + ".marker");
        BlockingShutdownProcess blockingProcess = new BlockingShutdownProcess(markerFile.getAbsolutePath(), 100L, true);
        try {
            blockingProcess.startProcess();
            long pid = blockingProcess.getProcessId();
            Assert.assertTrue((String)"Cannot determine process ID", (pid != -1L ? 1 : 0) != 0);
            TestJvmProcess.waitForMarkerFile(markerFile, 30000L);
            TestJvmProcess.killProcessWithSigTerm(pid);
            long deadline = System.nanoTime() + 30000000000L;
            while (blockingProcess.isAlive() && System.nanoTime() < deadline) {
                Thread.sleep(50L);
            }
            Assert.assertFalse((String)"shutdown blocking process does not properly terminate itself", (boolean)blockingProcess.isAlive());
        }
        finally {
            blockingProcess.destroy();
            markerFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void parkForever() {
        Object lock = new Object();
        while (true) {
            try {
                while (true) {
                    Object object = lock;
                    synchronized (object) {
                        lock.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    static final class BlockingRunnable
    implements Runnable {
        BlockingRunnable() {
        }

        @Override
        public void run() {
            System.err.println("starting shutdown hook");
            BlockingShutdownTest.parkForever();
        }
    }

    public static final class BlockingShutdownProcessEntryPoint {
        private static final Logger LOG = LoggerFactory.getLogger(BlockingShutdownProcessEntryPoint.class);

        public static void main(String[] args) throws Exception {
            File touchFile = new File(args[0]);
            boolean installHandler = Boolean.parseBoolean(args[1]);
            long killDelay = Long.parseLong(args[2]);
            Thread shutdownHook = new Thread((Runnable)new BlockingRunnable(), "Blocking ShutdownHook");
            try {
                Runtime.getRuntime().addShutdownHook(shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (Throwable t) {
                System.err.println("Cannot register process cleanup shutdown hook.");
                t.printStackTrace();
            }
            if (installHandler) {
                JvmShutdownSafeguard.installAsShutdownHook((Logger)LOG, (long)killDelay);
            }
            System.err.println("signaling process started");
            TestJvmProcess.touchFile(touchFile);
            System.err.println("parking the main thread");
            BlockingShutdownTest.parkForever();
        }
    }

    private static final class BlockingShutdownProcess
    extends TestJvmProcess {
        private final String tempFilePath;
        private final long selfKillDelay;
        private final boolean installSignalHandler;

        public BlockingShutdownProcess(String tempFilePath, long selfKillDelay, boolean installSignalHandler) throws Exception {
            this.tempFilePath = tempFilePath;
            this.selfKillDelay = selfKillDelay;
            this.installSignalHandler = installSignalHandler;
        }

        @Override
        public String getName() {
            return "BlockingShutdownProcess";
        }

        @Override
        public String[] getJvmArgs() {
            return new String[]{this.tempFilePath, String.valueOf(this.installSignalHandler), String.valueOf(this.selfKillDelay)};
        }

        @Override
        public String getEntryPointClassName() {
            return BlockingShutdownProcessEntryPoint.class.getName();
        }
    }
}

