/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.job;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.rest.messages.RestResponseMarshallingTestBase;
import org.apache.flink.runtime.rest.messages.job.JobExecutionResultResponseBody;
import org.apache.flink.util.OptionalFailure;
import org.apache.flink.util.SerializedThrowable;
import org.apache.flink.util.SerializedValue;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JobExecutionResultResponseBodyTest
extends RestResponseMarshallingTestBase<JobExecutionResultResponseBody> {
    private static final JobID TEST_JOB_ID = new JobID();
    private static final long TEST_NET_RUNTIME = Long.MAX_VALUE;
    private static final byte[] TEST_ACCUMULATOR_VALUE = new byte[]{1, 2, 3, 4, 5};
    private static final String TEST_ACCUMULATOR_NAME = "test";
    private static final Map<String, SerializedValue<OptionalFailure<Object>>> TEST_ACCUMULATORS = Collections.singletonMap("test", SerializedValue.fromBytes((byte[])TEST_ACCUMULATOR_VALUE));
    private final JobExecutionResultResponseBody jobExecutionResultResponseBody;

    @Parameterized.Parameters
    public static Collection<Object[]> data() throws IOException {
        return Arrays.asList({JobExecutionResultResponseBody.created((JobResult)new JobResult.Builder().jobId(TEST_JOB_ID).applicationStatus(ApplicationStatus.SUCCEEDED).netRuntime(Long.MAX_VALUE).accumulatorResults(TEST_ACCUMULATORS).serializedThrowable(new SerializedThrowable((Throwable)new RuntimeException("expected"))).build())}, {JobExecutionResultResponseBody.created((JobResult)new JobResult.Builder().jobId(TEST_JOB_ID).applicationStatus(ApplicationStatus.FAILED).netRuntime(Long.MAX_VALUE).accumulatorResults(TEST_ACCUMULATORS).build())}, {JobExecutionResultResponseBody.inProgress()});
    }

    public JobExecutionResultResponseBodyTest(JobExecutionResultResponseBody jobExecutionResultResponseBody) {
        this.jobExecutionResultResponseBody = jobExecutionResultResponseBody;
    }

    @Override
    protected Class<JobExecutionResultResponseBody> getTestResponseClass() {
        return JobExecutionResultResponseBody.class;
    }

    @Override
    protected JobExecutionResultResponseBody getTestResponseInstance() throws Exception {
        return this.jobExecutionResultResponseBody;
    }

    @Override
    protected void assertOriginalEqualsToUnmarshalled(JobExecutionResultResponseBody expected, JobExecutionResultResponseBody actual) {
        Assert.assertThat((Object)actual.getStatus(), (Matcher)Matchers.equalTo((Object)actual.getStatus()));
        JobResult expectedJobExecutionResult = expected.getJobExecutionResult();
        JobResult actualJobExecutionResult = actual.getJobExecutionResult();
        if (expectedJobExecutionResult != null) {
            Assert.assertNotNull((Object)actualJobExecutionResult);
            Assert.assertThat((Object)actualJobExecutionResult.getJobId(), (Matcher)Matchers.equalTo((Object)expectedJobExecutionResult.getJobId()));
            Assert.assertThat((Object)actualJobExecutionResult.getApplicationStatus(), (Matcher)Matchers.equalTo((Object)expectedJobExecutionResult.getApplicationStatus()));
            Assert.assertThat((Object)actualJobExecutionResult.getNetRuntime(), (Matcher)Matchers.equalTo((Object)expectedJobExecutionResult.getNetRuntime()));
            Assert.assertThat((Object)actualJobExecutionResult.getAccumulatorResults(), (Matcher)Matchers.equalTo((Object)expectedJobExecutionResult.getAccumulatorResults()));
            Optional expectedFailureCauseOptional = expectedJobExecutionResult.getSerializedThrowable();
            expectedFailureCauseOptional.ifPresent(expectedFailureCause -> {
                SerializedThrowable actualFailureCause = (SerializedThrowable)actualJobExecutionResult.getSerializedThrowable().orElseThrow(() -> new AssertionError((Object)"actualFailureCause is not available"));
                Assert.assertThat((Object)actualFailureCause.getFullStringifiedStackTrace(), (Matcher)Matchers.equalTo((Object)expectedFailureCause.getFullStringifiedStackTrace()));
                Assert.assertThat((Object)actualFailureCause.getOriginalErrorClassName(), (Matcher)Matchers.equalTo((Object)expectedFailureCause.getOriginalErrorClassName()));
                Assert.assertArrayEquals((byte[])expectedFailureCause.getSerializedException(), (byte[])actualFailureCause.getSerializedException());
            });
            if (expectedJobExecutionResult.getAccumulatorResults() != null) {
                Assert.assertNotNull((Object)actualJobExecutionResult.getAccumulatorResults());
                Assert.assertArrayEquals((byte[])((SerializedValue)actualJobExecutionResult.getAccumulatorResults().get(TEST_ACCUMULATOR_NAME)).getByteArray(), (byte[])((SerializedValue)expectedJobExecutionResult.getAccumulatorResults().get(TEST_ACCUMULATOR_NAME)).getByteArray());
            }
        }
    }
}

