/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.cluster;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.HandlerRequestException;
import org.apache.flink.runtime.rest.handler.cluster.JobManagerLogListHandler;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.LogInfo;
import org.apache.flink.runtime.rest.messages.LogListInfo;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.cluster.JobManagerLogListHeaders;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.TestingDispatcherGateway;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.util.StringUtils;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class JobManagerLogListHandlerTest
extends TestLogger {
    private static HandlerRequest<EmptyRequestBody> testRequest;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private DispatcherGateway dispatcherGateway;

    @BeforeClass
    public static void setupClass() throws HandlerRequestException {
        testRequest = HandlerRequest.create((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)EmptyMessageParameters.getInstance(), Collections.emptyList());
    }

    @Before
    public void setUp() {
        this.dispatcherGateway = TestingDispatcherGateway.newBuilder().build();
    }

    @Test
    public void testGetJobManagerLogsList() throws Exception {
        File logRoot = this.temporaryFolder.getRoot();
        List<LogInfo> expectedLogInfo = Arrays.asList(new LogInfo("jobmanager.log", 5L, 1632844800000L), new LogInfo("jobmanager.out", 7L, 1632844800000L), new LogInfo("test.log", 13L, 1632844800000L));
        this.createLogFiles(logRoot, expectedLogInfo);
        JobManagerLogListHandler jobManagerLogListHandler = this.createHandler(logRoot);
        LogListInfo logListInfo = (LogListInfo)jobManagerLogListHandler.handleRequest(testRequest, (RestfulGateway)this.dispatcherGateway).get();
        Assert.assertThat((Object)logListInfo.getLogInfos(), (Matcher)Matchers.containsInAnyOrder((Object[])expectedLogInfo.toArray(new LogInfo[0])));
    }

    @Test
    public void testGetJobManagerLogsListWhenLogDirIsNull() throws Exception {
        JobManagerLogListHandler jobManagerLogListHandler = this.createHandler(null);
        LogListInfo logListInfo = (LogListInfo)jobManagerLogListHandler.handleRequest(testRequest, (RestfulGateway)this.dispatcherGateway).get();
        Assert.assertThat((Object)logListInfo.getLogInfos(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    private JobManagerLogListHandler createHandler(@Nullable File jobManagerLogRoot) {
        return new JobManagerLogListHandler(() -> CompletableFuture.completedFuture(this.dispatcherGateway), TestingUtils.TIMEOUT, Collections.emptyMap(), (MessageHeaders)JobManagerLogListHeaders.getInstance(), jobManagerLogRoot);
    }

    private void createLogFiles(File logRoot, List<LogInfo> expectedLogFiles) {
        for (LogInfo logInfo : expectedLogFiles) {
            this.createFile(new File(logRoot, logInfo.getName()), logInfo.getSize(), logInfo.getMtime());
        }
    }

    private void createFile(File file, long size, long mtime) {
        try {
            String randomFileContent = StringUtils.generateRandomAlphanumericString((Random)ThreadLocalRandom.current(), (int)Math.toIntExact(size));
            FileUtils.writeStringToFile((File)file, (String)randomFileContent, (Charset)StandardCharsets.UTF_8);
            file.setLastModified(mtime);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

