/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.resourcemanager.slotmanager.AbstractFineGrainedSlotManagerITCase;
import org.apache.flink.runtime.resourcemanager.slotmanager.DefaultResourceAllocationStrategy;
import org.apache.flink.runtime.resourcemanager.slotmanager.FineGrainedSlotManagerTestBase;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceAllocationStrategy;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceDeclaration;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerConfiguration;
import org.apache.flink.runtime.slots.ResourceRequirements;
import org.apache.flink.runtime.taskexecutor.SlotReport;
import org.apache.flink.runtime.taskexecutor.SlotStatus;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGatewayBuilder;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FineGrainedSlotManagerDefaultResourceAllocationStrategyITCase
extends AbstractFineGrainedSlotManagerITCase {
    private static final ResourceProfile OTHER_SLOT_RESOURCE_PROFILE = DEFAULT_TOTAL_RESOURCE_PROFILE.multiply(2);

    FineGrainedSlotManagerDefaultResourceAllocationStrategyITCase() {
    }

    @Override
    protected Optional<ResourceAllocationStrategy> getResourceAllocationStrategy(SlotManagerConfiguration slotManagerConfiguration) {
        return Optional.of(new DefaultResourceAllocationStrategy(DEFAULT_TOTAL_RESOURCE_PROFILE, 2, slotManagerConfiguration.isEvenlySpreadOutSlots(), slotManagerConfiguration.getTaskManagerTimeout(), slotManagerConfiguration.getRedundantTaskManagerNum()));
    }

    @Test
    void testWorkerOnlyAllocatedIfRequestedSlotCouldBeFulfilled() throws Exception {
        final AtomicInteger declareResourceCount = new AtomicInteger(0);
        new FineGrainedSlotManagerTestBase.Context(){
            {
                super(FineGrainedSlotManagerDefaultResourceAllocationStrategyITCase.this);
                this.resourceAllocatorBuilder.setDeclareResourceNeededConsumer(ignored -> declareResourceCount.incrementAndGet());
                this.runTest(() -> {
                    this.runInMainThread(() -> this.getSlotManager().processResourceRequirements(FineGrainedSlotManagerTestBase.createResourceRequirements(new JobID(), 1, OTHER_SLOT_RESOURCE_PROFILE)));
                    Assertions.assertThat((int)declareResourceCount.get()).isEqualTo(0);
                });
            }
        };
    }

    @Test
    void testTaskManagerUnregisterAfterResourceRequirements() throws Exception {
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setRequestSlotFunction(tuple6 -> new CompletableFuture()).createTestingTaskExecutorGateway();
        ResourceID resourceId = ResourceID.generate();
        final TaskExecutorConnection taskManagerConnection = new TaskExecutorConnection(resourceId, (TaskExecutorGateway)taskExecutorGateway);
        final SlotReport slotReport = new SlotReport(new SlotStatus(new SlotID(resourceId, 0), DEFAULT_SLOT_RESOURCE_PROFILE));
        new FineGrainedSlotManagerTestBase.Context(){
            {
                super(FineGrainedSlotManagerDefaultResourceAllocationStrategyITCase.this);
                this.slotManagerConfigurationBuilder.setRequirementCheckDelay(Duration.ZERO);
                this.runTest(() -> {
                    CompletableFuture registerTaskManagerFuture = new CompletableFuture();
                    CompletableFuture unRegisterTaskManagerFuture = new CompletableFuture();
                    this.runInMainThread(() -> registerTaskManagerFuture.complete(this.getSlotManager().registerTaskManager(taskManagerConnection, slotReport, FineGrainedSlotManagerTestBase.DEFAULT_TOTAL_RESOURCE_PROFILE, FineGrainedSlotManagerTestBase.DEFAULT_SLOT_RESOURCE_PROFILE)));
                    Assertions.assertThat((Comparable)((Comparable)FineGrainedSlotManagerTestBase.assertFutureCompleteAndReturn(registerTaskManagerFuture))).isEqualTo((Object)SlotManager.RegistrationResult.SUCCESS);
                    Assertions.assertThat((Collection)this.getTaskManagerTracker().getRegisteredTaskManagers()).hasSize(1);
                    Assertions.assertThat((int)this.getTaskManagerTracker().getNumberFreeSlots()).isEqualTo(2);
                    ResourceRequirements resourceRequirements = FineGrainedSlotManagerTestBase.createResourceRequirementsForSingleSlot();
                    this.runInMainThreadAndWait(() -> this.getSlotManager().processResourceRequirements(resourceRequirements));
                    Assertions.assertThat((Object)this.getTaskManagerTracker().getFreeResource()).isEqualTo((Object)FineGrainedSlotManagerTestBase.DEFAULT_SLOT_RESOURCE_PROFILE);
                    Assertions.assertThat((Map)this.getResourceTracker().getMissingResources()).isEmpty();
                    this.runInMainThread(() -> unRegisterTaskManagerFuture.complete(this.getSlotManager().unregisterTaskManager(taskManagerConnection.getInstanceID(), (Exception)FineGrainedSlotManagerTestBase.TEST_EXCEPTION)));
                    Assertions.assertThat((Boolean)((Boolean)FineGrainedSlotManagerTestBase.assertFutureCompleteAndReturn(unRegisterTaskManagerFuture))).isTrue();
                    Assertions.assertThat((Collection)this.getTaskManagerTracker().getRegisteredTaskManagers()).isEmpty();
                    Assertions.assertThat((Map)this.getResourceTracker().getMissingResources()).containsKey((Object)resourceRequirements.getJobId());
                });
            }
        };
    }

    @Test
    void testTimeoutForUnusedTaskManager() throws Exception {
        final Time taskManagerTimeout = Time.milliseconds((long)50L);
        final CompletableFuture releaseResourceFuture = new CompletableFuture();
        final AllocationID allocationId = new AllocationID();
        final TaskExecutorConnection taskExecutionConnection = FineGrainedSlotManagerDefaultResourceAllocationStrategyITCase.createTaskExecutorConnection();
        final InstanceID instanceId = taskExecutionConnection.getInstanceID();
        new FineGrainedSlotManagerTestBase.Context(){
            {
                super(FineGrainedSlotManagerDefaultResourceAllocationStrategyITCase.this);
                this.resourceAllocatorBuilder.setDeclareResourceNeededConsumer(resourceDeclarations -> {
                    Assertions.assertThat((Collection)resourceDeclarations).hasSize(1);
                    ResourceDeclaration resourceDeclaration = (ResourceDeclaration)resourceDeclarations.iterator().next();
                    Assertions.assertThat((int)resourceDeclaration.getNumNeeded()).isEqualTo(0);
                    Assertions.assertThat((Collection)resourceDeclaration.getUnwantedWorkers()).hasSize(1);
                    releaseResourceFuture.complete(resourceDeclaration.getUnwantedWorkers().iterator().next());
                });
                this.slotManagerConfigurationBuilder.setTaskManagerTimeout(taskManagerTimeout);
                this.runTest(() -> {
                    CompletableFuture registerTaskManagerFuture = new CompletableFuture();
                    this.runInMainThread(() -> registerTaskManagerFuture.complete(this.getSlotManager().registerTaskManager(taskExecutionConnection, new SlotReport(FineGrainedSlotManagerTestBase.createAllocatedSlotStatus(new JobID(), allocationId, FineGrainedSlotManagerTestBase.DEFAULT_SLOT_RESOURCE_PROFILE)), FineGrainedSlotManagerTestBase.DEFAULT_TOTAL_RESOURCE_PROFILE, FineGrainedSlotManagerTestBase.DEFAULT_SLOT_RESOURCE_PROFILE)));
                    Assertions.assertThat((Comparable)((Comparable)FineGrainedSlotManagerTestBase.assertFutureCompleteAndReturn(registerTaskManagerFuture))).isEqualTo((Object)SlotManager.RegistrationResult.SUCCESS);
                    Assertions.assertThat((long)this.getSlotManager().getTaskManagerIdleSince(instanceId)).isEqualTo(Long.MAX_VALUE);
                    CompletableFuture idleSinceFuture = new CompletableFuture();
                    this.runInMainThread(() -> {
                        this.getSlotManager().freeSlot(new SlotID(taskExecutionConnection.getResourceID(), 0), allocationId);
                        idleSinceFuture.complete(this.getSlotManager().getTaskManagerIdleSince(instanceId));
                    });
                    Assertions.assertThat((Long)((Long)FineGrainedSlotManagerTestBase.assertFutureCompleteAndReturn(idleSinceFuture))).isNotEqualTo(Long.MAX_VALUE);
                    Assertions.assertThat((Comparable)((Comparable)FineGrainedSlotManagerTestBase.assertFutureCompleteAndReturn(releaseResourceFuture))).isEqualTo((Object)instanceId);
                    Assertions.assertThat((int)this.getSlotManager().getNumberRegisteredSlots()).isEqualTo(2);
                    CompletableFuture unregisterTaskManagerFuture = new CompletableFuture();
                    this.runInMainThread(() -> unregisterTaskManagerFuture.complete(this.getSlotManager().unregisterTaskManager(taskExecutionConnection.getInstanceID(), (Exception)FineGrainedSlotManagerTestBase.TEST_EXCEPTION)));
                    Assertions.assertThat((Boolean)((Boolean)FineGrainedSlotManagerTestBase.assertFutureCompleteAndReturn(unregisterTaskManagerFuture))).isTrue();
                    Assertions.assertThat((int)this.getSlotManager().getNumberRegisteredSlots()).isEqualTo(0);
                });
            }
        };
    }
}

