/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.resourcemanager.slotmanager.DefaultSlotTracker;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotState;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerSlotInformation;
import org.apache.flink.runtime.taskexecutor.SlotStatus;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGatewayBuilder;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.Assert;
import org.junit.Test;

public class DefaultSlotTrackerTest
extends TestLogger {
    private static final TaskExecutorConnection TASK_EXECUTOR_CONNECTION = new TaskExecutorConnection(ResourceID.generate(), (TaskExecutorGateway)new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway());
    private static final JobID jobId = new JobID();

    @Test
    public void testFreeSlotsIsEmptyOnInitially() {
        DefaultSlotTracker tracker = new DefaultSlotTracker();
        Assert.assertThat((Object)tracker.getFreeSlots(), (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void testSlotAddition() {
        DefaultSlotTracker tracker = new DefaultSlotTracker();
        SlotID slotId1 = new SlotID(TASK_EXECUTOR_CONNECTION.getResourceID(), 0);
        SlotID slotId2 = new SlotID(TASK_EXECUTOR_CONNECTION.getResourceID(), 1);
        tracker.addSlot(slotId1, ResourceProfile.ANY, TASK_EXECUTOR_CONNECTION, null);
        tracker.addSlot(slotId2, ResourceProfile.ANY, TASK_EXECUTOR_CONNECTION, null);
        Assert.assertThat((Object)tracker.getFreeSlots(), (Matcher)Matchers.containsInAnyOrder(Arrays.asList(DefaultSlotTrackerTest.infoWithSlotId(slotId1), DefaultSlotTrackerTest.infoWithSlotId(slotId2))));
    }

    @Test
    public void testSlotRemoval() {
        ArrayDeque stateTransitions = new ArrayDeque();
        DefaultSlotTracker tracker = new DefaultSlotTracker();
        tracker.registerSlotStatusUpdateListener((slot, previous, current, jobId) -> stateTransitions.add(new SlotStateTransition(slot.getSlotId(), previous, current, jobId)));
        SlotID slotId1 = new SlotID(TASK_EXECUTOR_CONNECTION.getResourceID(), 0);
        SlotID slotId2 = new SlotID(TASK_EXECUTOR_CONNECTION.getResourceID(), 1);
        SlotID slotId3 = new SlotID(TASK_EXECUTOR_CONNECTION.getResourceID(), 2);
        tracker.addSlot(slotId1, ResourceProfile.ANY, TASK_EXECUTOR_CONNECTION, null);
        tracker.addSlot(slotId2, ResourceProfile.ANY, TASK_EXECUTOR_CONNECTION, null);
        tracker.addSlot(slotId3, ResourceProfile.ANY, TASK_EXECUTOR_CONNECTION, null);
        tracker.notifyAllocationStart(slotId2, DefaultSlotTrackerTest.jobId);
        tracker.notifyAllocationStart(slotId3, DefaultSlotTrackerTest.jobId);
        tracker.notifyAllocationComplete(slotId3, DefaultSlotTrackerTest.jobId);
        stateTransitions.clear();
        tracker.removeSlots(Arrays.asList(slotId1, slotId2, slotId3));
        Assert.assertThat((Object)tracker.getFreeSlots(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)tracker.areMapsEmpty(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat(stateTransitions, (Matcher)Matchers.containsInAnyOrder((Object[])new SlotStateTransition[]{new SlotStateTransition(slotId2, SlotState.PENDING, SlotState.FREE, DefaultSlotTrackerTest.jobId), new SlotStateTransition(slotId3, SlotState.ALLOCATED, SlotState.FREE, DefaultSlotTrackerTest.jobId)}));
    }

    @Test
    public void testAllocationCompletion() {
        ArrayDeque stateTransitions = new ArrayDeque();
        DefaultSlotTracker tracker = new DefaultSlotTracker();
        tracker.registerSlotStatusUpdateListener((slot, previous, current, jobId) -> stateTransitions.add(new SlotStateTransition(slot.getSlotId(), previous, current, jobId)));
        SlotID slotId = new SlotID(TASK_EXECUTOR_CONNECTION.getResourceID(), 0);
        tracker.addSlot(slotId, ResourceProfile.ANY, TASK_EXECUTOR_CONNECTION, null);
        tracker.notifyAllocationStart(slotId, DefaultSlotTrackerTest.jobId);
        Assert.assertThat((Object)tracker.getFreeSlots(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat(stateTransitions.remove(), (Matcher)CoreMatchers.is((Object)new SlotStateTransition(slotId, SlotState.FREE, SlotState.PENDING, DefaultSlotTrackerTest.jobId)));
        tracker.notifyAllocationComplete(slotId, DefaultSlotTrackerTest.jobId);
        Assert.assertThat((Object)tracker.getFreeSlots(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat(stateTransitions.remove(), (Matcher)CoreMatchers.is((Object)new SlotStateTransition(slotId, SlotState.PENDING, SlotState.ALLOCATED, DefaultSlotTrackerTest.jobId)));
        tracker.notifyFree(slotId);
        Assert.assertThat((Object)tracker.getFreeSlots(), (Matcher)Matchers.contains(DefaultSlotTrackerTest.infoWithSlotId(slotId)));
        Assert.assertThat(stateTransitions.remove(), (Matcher)CoreMatchers.is((Object)new SlotStateTransition(slotId, SlotState.ALLOCATED, SlotState.FREE, DefaultSlotTrackerTest.jobId)));
    }

    @Test
    public void testAllocationCompletionForDifferentJobThrowsIllegalStateException() {
        DefaultSlotTracker tracker = new DefaultSlotTracker();
        SlotID slotId = new SlotID(TASK_EXECUTOR_CONNECTION.getResourceID(), 0);
        tracker.addSlot(slotId, ResourceProfile.ANY, TASK_EXECUTOR_CONNECTION, null);
        tracker.notifyAllocationStart(slotId, new JobID());
        try {
            tracker.notifyAllocationComplete(slotId, new JobID());
            Assert.fail((String)"Allocations must not be completed for a different job ID.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testAllocationCancellation() {
        ArrayDeque stateTransitions = new ArrayDeque();
        DefaultSlotTracker tracker = new DefaultSlotTracker();
        tracker.registerSlotStatusUpdateListener((slot, previous, current, jobId) -> stateTransitions.add(new SlotStateTransition(slot.getSlotId(), previous, current, jobId)));
        SlotID slotId = new SlotID(TASK_EXECUTOR_CONNECTION.getResourceID(), 0);
        tracker.addSlot(slotId, ResourceProfile.ANY, TASK_EXECUTOR_CONNECTION, null);
        tracker.notifyAllocationStart(slotId, DefaultSlotTrackerTest.jobId);
        Assert.assertThat((Object)tracker.getFreeSlots(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat(stateTransitions.remove(), (Matcher)CoreMatchers.is((Object)new SlotStateTransition(slotId, SlotState.FREE, SlotState.PENDING, DefaultSlotTrackerTest.jobId)));
        tracker.notifyFree(slotId);
        Assert.assertThat((Object)tracker.getFreeSlots(), (Matcher)Matchers.contains(DefaultSlotTrackerTest.infoWithSlotId(slotId)));
        Assert.assertThat(stateTransitions.remove(), (Matcher)CoreMatchers.is((Object)new SlotStateTransition(slotId, SlotState.PENDING, SlotState.FREE, DefaultSlotTrackerTest.jobId)));
    }

    @Test
    public void testNotificationsFiredAfterStateTransition() {
        SlotID slotId = new SlotID(ResourceID.generate(), 0);
        DefaultSlotTracker tracker = new DefaultSlotTracker();
        tracker.addSlot(slotId, ResourceProfile.ANY, TASK_EXECUTOR_CONNECTION, null);
        tracker.registerSlotStatusUpdateListener((slot, previous, current, jobId) -> {
            if (current == SlotState.FREE) {
                Assert.assertThat((Object)tracker.getFreeSlots(), (Matcher)Matchers.contains(DefaultSlotTrackerTest.infoWithSlotId(slotId)));
            } else {
                Assert.assertThat((Object)tracker.getFreeSlots(), (Matcher)CoreMatchers.not((Matcher)Matchers.contains(DefaultSlotTrackerTest.infoWithSlotId(slotId))));
            }
        });
        tracker.notifyAllocationStart(slotId, DefaultSlotTrackerTest.jobId);
        tracker.notifyAllocationComplete(slotId, DefaultSlotTrackerTest.jobId);
        tracker.notifyFree(slotId);
    }

    @Test
    public void testSlotStatusProcessing() {
        DefaultSlotTracker tracker = new DefaultSlotTracker();
        SlotID slotId1 = new SlotID(TASK_EXECUTOR_CONNECTION.getResourceID(), 0);
        SlotID slotId2 = new SlotID(TASK_EXECUTOR_CONNECTION.getResourceID(), 1);
        SlotID slotId3 = new SlotID(TASK_EXECUTOR_CONNECTION.getResourceID(), 2);
        tracker.addSlot(slotId1, ResourceProfile.ANY, TASK_EXECUTOR_CONNECTION, null);
        tracker.addSlot(slotId2, ResourceProfile.ANY, TASK_EXECUTOR_CONNECTION, null);
        tracker.addSlot(slotId3, ResourceProfile.ANY, TASK_EXECUTOR_CONNECTION, jobId);
        Assert.assertThat((Object)tracker.getFreeSlots(), (Matcher)Matchers.containsInAnyOrder(Arrays.asList(DefaultSlotTrackerTest.infoWithSlotId(slotId1), DefaultSlotTrackerTest.infoWithSlotId(slotId2))));
        tracker.notifyAllocationStart(slotId2, jobId);
        List<SlotStatus> slotReport = Arrays.asList(new SlotStatus(slotId1, ResourceProfile.ANY, jobId, new AllocationID()), new SlotStatus(slotId2, ResourceProfile.ANY, null, new AllocationID()), new SlotStatus(slotId3, ResourceProfile.ANY, null, new AllocationID()));
        Assert.assertThat((Object)tracker.notifySlotStatus(slotReport), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)tracker.getFreeSlots(), (Matcher)Matchers.contains(DefaultSlotTrackerTest.infoWithSlotId(slotId3)));
        tracker.notifyAllocationComplete(slotId2, jobId);
        List<SlotStatus> idempotentSlotReport = Arrays.asList(new SlotStatus(slotId1, ResourceProfile.ANY, jobId, new AllocationID()), new SlotStatus(slotId2, ResourceProfile.ANY, jobId, new AllocationID()), new SlotStatus(slotId3, ResourceProfile.ANY, null, new AllocationID()));
        Assert.assertThat((Object)tracker.notifySlotStatus(idempotentSlotReport), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testGetTaskExecutorsWithAllocatedSlotsForJob() {
        DefaultSlotTracker tracker = new DefaultSlotTracker();
        JobID jobId = new JobID();
        SlotID slotId = new SlotID(TASK_EXECUTOR_CONNECTION.getResourceID(), 0);
        Assert.assertThat((Object)tracker.getTaskExecutorsWithAllocatedSlotsForJob(new JobID()), (Matcher)IsEmptyCollection.empty());
        tracker.addSlot(slotId, ResourceProfile.ANY, TASK_EXECUTOR_CONNECTION, null);
        Assert.assertThat((Object)tracker.getTaskExecutorsWithAllocatedSlotsForJob(new JobID()), (Matcher)IsEmptyCollection.empty());
        tracker.notifyAllocationStart(slotId, jobId);
        Assert.assertThat((Object)tracker.getTaskExecutorsWithAllocatedSlotsForJob(jobId), (Matcher)Matchers.contains((Object[])new TaskExecutorConnection[]{TASK_EXECUTOR_CONNECTION}));
        tracker.notifyAllocationComplete(slotId, jobId);
        Assert.assertThat((Object)tracker.getTaskExecutorsWithAllocatedSlotsForJob(jobId), (Matcher)Matchers.contains((Object[])new TaskExecutorConnection[]{TASK_EXECUTOR_CONNECTION}));
        tracker.notifyFree(slotId);
        Assert.assertThat((Object)tracker.getTaskExecutorsWithAllocatedSlotsForJob(new JobID()), (Matcher)IsEmptyCollection.empty());
    }

    private static Matcher<TaskManagerSlotInformation> infoWithSlotId(SlotID slotId) {
        return new TaskManagerSlotInformationMatcher(slotId);
    }

    private static class TaskManagerSlotInformationMatcher
    extends TypeSafeMatcher<TaskManagerSlotInformation> {
        private final SlotID slotId;

        private TaskManagerSlotInformationMatcher(SlotID slotId) {
            this.slotId = slotId;
        }

        protected boolean matchesSafely(TaskManagerSlotInformation item) {
            return item.getSlotId().equals((Object)this.slotId);
        }

        public void describeTo(Description description) {
            description.appendText("a slot information with slotId=").appendValue((Object)this.slotId);
        }
    }

    private static class SlotStateTransition {
        private final SlotID slotId;
        private final SlotState oldState;
        private final SlotState newState;
        @Nullable
        private final JobID jobId;

        private SlotStateTransition(SlotID slotId, SlotState oldState, SlotState newState, @Nullable JobID jobId) {
            this.slotId = slotId;
            this.jobId = jobId;
            this.oldState = oldState;
            this.newState = newState;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SlotStateTransition that = (SlotStateTransition)o;
            return Objects.equals(this.slotId, that.slotId) && this.oldState == that.oldState && this.newState == that.newState && Objects.equals(this.jobId, that.jobId);
        }

        public String toString() {
            return "SlotStateTransition{slotId=" + this.slotId + ", oldState=" + this.oldState + ", newState=" + this.newState + ", jobId=" + this.jobId + '}';
        }
    }
}

