/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderelection.TestingLeaderElection;
import org.apache.flink.runtime.resourcemanager.TestingResourceManagerService;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class ResourceManagerHATest
extends TestLogger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGrantAndRevokeLeadership() throws Exception {
        TestingLeaderElection leaderElection = new TestingLeaderElection();
        TestingResourceManagerService resourceManagerService = TestingResourceManagerService.newBuilder().setRmLeaderElection(leaderElection).build();
        try {
            resourceManagerService.start();
            UUID leaderId = UUID.randomUUID();
            LeaderInformation confirmedLeaderInformation = resourceManagerService.isLeader(leaderId).join();
            Assert.assertEquals((Object)leaderId, (Object)confirmedLeaderInformation.getLeaderSessionID());
            Assert.assertTrue((boolean)resourceManagerService.getResourceManagerFencingToken().isPresent());
            Assert.assertEquals((Object)leaderId, (Object)resourceManagerService.getResourceManagerFencingToken().get().toUUID());
            Optional<CompletableFuture<Void>> rmTerminationFutureOpt = resourceManagerService.getResourceManagerTerminationFuture();
            Assert.assertTrue((boolean)rmTerminationFutureOpt.isPresent());
            resourceManagerService.notLeader();
            rmTerminationFutureOpt.get().get();
            resourceManagerService.rethrowFatalErrorIfAny();
        }
        finally {
            resourceManagerService.cleanUp();
        }
    }
}

