/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypePairComparatorFactory;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.RuntimePairComparatorFactory;
import org.apache.flink.runtime.operators.AbstractOuterJoinDriver;
import org.apache.flink.runtime.operators.AbstractOuterJoinTaskTest;
import org.apache.flink.runtime.operators.Driver;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.RightOuterJoinDriver;
import org.apache.flink.runtime.operators.testutils.DelayingIterator;
import org.apache.flink.runtime.operators.testutils.DiscardingOutputCollector;
import org.apache.flink.runtime.operators.testutils.ExpectedTestException;
import org.apache.flink.runtime.operators.testutils.InfiniteIntTupleIterator;
import org.apache.flink.runtime.operators.testutils.UniformIntTupleGenerator;
import org.apache.flink.shaded.guava31.com.google.common.base.Throwables;
import org.junit.Assert;
import org.junit.Test;

public class RightOuterJoinTaskTest
extends AbstractOuterJoinTaskTest {
    private static final long HASH_MEM = 0x600000L;
    private final double hash_frac = 6291456.0 / (double)this.getMemoryManager().getMemorySize();

    public RightOuterJoinTaskTest(ExecutionConfig config) {
        super(config);
    }

    @Override
    protected DriverStrategy getSortDriverStrategy() {
        return DriverStrategy.RIGHT_OUTER_MERGE;
    }

    @Override
    protected int calculateExpectedCount(int keyCnt1, int valCnt1, int keyCnt2, int valCnt2) {
        return valCnt1 * valCnt2 * Math.min(keyCnt1, keyCnt2) + (keyCnt2 > keyCnt1 ? (keyCnt2 - keyCnt1) * valCnt2 : 0);
    }

    @Override
    protected AbstractOuterJoinDriver<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> getOuterJoinDriver() {
        return new RightOuterJoinDriver();
    }

    @Test
    public void testHash1RightOuterJoinTask() throws Exception {
        int keyCnt1 = 20;
        boolean valCnt1 = true;
        int keyCnt2 = 10;
        int valCnt2 = 2;
        this.testHashRightOuterJoinTask(20, 1, 10, 2);
    }

    @Test
    public void testHash2RightOuterJoinTask() throws Exception {
        int keyCnt1 = 20;
        boolean valCnt1 = true;
        int keyCnt2 = 20;
        boolean valCnt2 = true;
        this.testHashRightOuterJoinTask(20, 1, 20, 1);
    }

    @Test
    public void testHash3RightOuterJoinTask() throws Exception {
        int keyCnt1 = 20;
        int valCnt1 = 1;
        int keyCnt2 = 20;
        int valCnt2 = 20;
        this.testHashRightOuterJoinTask(keyCnt1, valCnt1, keyCnt2, valCnt2);
    }

    @Test
    public void testHash4RightOuterJoinTask() throws Exception {
        int keyCnt1 = 20;
        int valCnt1 = 20;
        int keyCnt2 = 20;
        int valCnt2 = 1;
        this.testHashRightOuterJoinTask(keyCnt1, valCnt1, keyCnt2, valCnt2);
    }

    @Test
    public void testHash5RightOuterJoinTask() throws Exception {
        int keyCnt1 = 20;
        int valCnt1 = 20;
        int keyCnt2 = 20;
        int valCnt2 = 20;
        this.testHashRightOuterJoinTask(keyCnt1, valCnt1, keyCnt2, valCnt2);
    }

    @Test
    public void testHash6RightOuterJoinTask() throws Exception {
        int keyCnt1 = 10;
        int valCnt1 = 1;
        int keyCnt2 = 20;
        int valCnt2 = 2;
        this.testHashRightOuterJoinTask(keyCnt1, valCnt1, keyCnt2, valCnt2);
    }

    private void testHashRightOuterJoinTask(int keyCnt1, int valCnt1, int keyCnt2, int valCnt2) throws Exception {
        this.setOutput(this.outList, this.serializer);
        this.addDriverComparator(this.comparator1);
        this.addDriverComparator(this.comparator2);
        this.getTaskConfig().setDriverPairComparator((TypePairComparatorFactory)new RuntimePairComparatorFactory());
        this.getTaskConfig().setDriverStrategy(DriverStrategy.RIGHT_HYBRIDHASH_BUILD_FIRST);
        this.getTaskConfig().setRelativeMemoryDriver(this.hash_frac);
        this.setNumFileHandlesForSort(4);
        AbstractOuterJoinDriver<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> testTask = this.getOuterJoinDriver();
        this.addInput(new UniformIntTupleGenerator(keyCnt1, valCnt1, false), this.serializer);
        this.addInput(new UniformIntTupleGenerator(keyCnt2, valCnt2, false), this.serializer);
        this.testDriver((Driver)testTask, AbstractOuterJoinTaskTest.MockJoinStub.class);
        int expCnt = this.calculateExpectedCount(keyCnt1, valCnt1, keyCnt2, valCnt2);
        Assert.assertTrue((String)("Result set size was " + this.outList.size() + ". Expected was " + expCnt), (this.outList.size() == expCnt ? 1 : 0) != 0);
        this.outList.clear();
    }

    @Test(expected=ExpectedTestException.class)
    public void testFailingHashRightOuterJoinTask() throws Exception {
        int keyCnt1 = 20;
        int valCnt1 = 20;
        int keyCnt2 = 20;
        int valCnt2 = 20;
        this.setOutput(new DiscardingOutputCollector());
        this.addDriverComparator(this.comparator1);
        this.addDriverComparator(this.comparator2);
        this.getTaskConfig().setDriverPairComparator((TypePairComparatorFactory)new RuntimePairComparatorFactory());
        this.getTaskConfig().setDriverStrategy(DriverStrategy.RIGHT_HYBRIDHASH_BUILD_FIRST);
        this.getTaskConfig().setRelativeMemoryDriver(this.hash_frac);
        this.setNumFileHandlesForSort(4);
        AbstractOuterJoinDriver<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> testTask = this.getOuterJoinDriver();
        this.addInput(new UniformIntTupleGenerator(keyCnt1, valCnt1, true), this.serializer);
        this.addInput(new UniformIntTupleGenerator(keyCnt2, valCnt2, true), this.serializer);
        this.testDriver((Driver)testTask, AbstractOuterJoinTaskTest.MockFailingJoinStub.class);
    }

    @Test
    public void testCancelRightOuterJoinTaskWhileBuilding() throws Exception {
        this.setOutput(new DiscardingOutputCollector());
        this.addDriverComparator(this.comparator1);
        this.addDriverComparator(this.comparator2);
        this.getTaskConfig().setDriverPairComparator((TypePairComparatorFactory)new RuntimePairComparatorFactory());
        this.getTaskConfig().setDriverStrategy(DriverStrategy.RIGHT_HYBRIDHASH_BUILD_FIRST);
        this.getTaskConfig().setRelativeMemoryDriver(this.hash_frac);
        final AbstractOuterJoinDriver<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> testTask = this.getOuterJoinDriver();
        this.addInput(new DelayingIterator<Tuple2<Integer, Integer>>(new InfiniteIntTupleIterator(), 100), this.serializer);
        this.addInput(new UniformIntTupleGenerator(100, 100, true), this.serializer);
        final AtomicReference error = new AtomicReference();
        Thread taskRunner = new Thread("Task runner for testCancelOuterJoinTaskWhileSort1()"){

            @Override
            public void run() {
                try {
                    RightOuterJoinTaskTest.this.testDriver((Driver)testTask, AbstractOuterJoinTaskTest.MockJoinStub.class);
                }
                catch (Throwable t) {
                    error.set(t);
                }
            }
        };
        taskRunner.start();
        Thread.sleep(1000L);
        this.cancel();
        taskRunner.join(60000L);
        Assert.assertFalse((String)"Task thread did not finish within 60 seconds", (boolean)taskRunner.isAlive());
        Throwable taskError = (Throwable)error.get();
        if (taskError != null) {
            Assert.fail((String)("Error in task while canceling:\n" + Throwables.getStackTraceAsString((Throwable)taskError)));
        }
    }

    @Test
    public void testCancelRightOuterJoinTaskWhileProbing() throws Exception {
        this.setOutput(new DiscardingOutputCollector());
        this.addDriverComparator(this.comparator1);
        this.addDriverComparator(this.comparator2);
        this.getTaskConfig().setDriverPairComparator((TypePairComparatorFactory)new RuntimePairComparatorFactory());
        this.getTaskConfig().setDriverStrategy(DriverStrategy.RIGHT_HYBRIDHASH_BUILD_FIRST);
        this.getTaskConfig().setRelativeMemoryDriver(this.hash_frac);
        final AbstractOuterJoinDriver<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> testTask = this.getOuterJoinDriver();
        this.addInput(new UniformIntTupleGenerator(1, 1, true), this.serializer);
        this.addInput(new DelayingIterator<Tuple2<Integer, Integer>>(new InfiniteIntTupleIterator(), 100), this.serializer);
        final AtomicReference error = new AtomicReference();
        Thread taskRunner = new Thread("Task runner for testCancelOuterJoinTaskWhileSort1()"){

            @Override
            public void run() {
                try {
                    RightOuterJoinTaskTest.this.testDriver((Driver)testTask, AbstractOuterJoinTaskTest.MockJoinStub.class);
                }
                catch (Throwable t) {
                    error.set(t);
                }
            }
        };
        taskRunner.start();
        Thread.sleep(1000L);
        this.cancel();
        taskRunner.join(60000L);
        Assert.assertFalse((String)"Task thread did not finish within 60 seconds", (boolean)taskRunner.isAlive());
        Throwable taskError = (Throwable)error.get();
        if (taskError != null) {
            Assert.fail((String)("Error in task while canceling:\n" + Throwables.getStackTraceAsString((Throwable)taskError)));
        }
    }
}

