/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.time.Duration;
import java.util.Map;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.executiongraph.ResultPartitionBytes;
import org.apache.flink.runtime.io.network.metrics.ResultPartitionBytesCounter;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.ManualClock;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TaskIOMetricGroupTest {
    TaskIOMetricGroupTest() {
    }

    @Test
    void testTaskIOMetricGroup() throws InterruptedException {
        TaskMetricGroup task = UnregisteredMetricGroups.createUnregisteredTaskMetricGroup();
        ManualClock clock = new ManualClock(System.currentTimeMillis());
        TaskIOMetricGroup taskIO = new TaskIOMetricGroup(task, (Clock)clock);
        long initializationTime = 100L;
        Assertions.assertThat((long)taskIO.getTaskInitializationDuration()).isEqualTo(0L);
        taskIO.markTaskInitializationStarted();
        clock.advanceTime(Duration.ofMillis(100L));
        Assertions.assertThat((long)taskIO.getTaskInitializationDuration()).isGreaterThan(0L);
        long initializationDuration = taskIO.getTaskInitializationDuration();
        taskIO.markTaskStart();
        Assertions.assertThat((long)taskIO.getTaskInitializationDuration()).isEqualTo(initializationDuration);
        taskIO.setEnableBusyTime(true);
        taskIO.markTaskStart();
        long startTime = clock.absoluteTimeMillis();
        long runningTime = 200L;
        clock.advanceTime(Duration.ofMillis(200L));
        Assertions.assertThat((long)taskIO.getTaskInitializationDuration()).isEqualTo(initializationDuration);
        Assertions.assertThat((Object)taskIO.getNumRecordsInCounter()).isNotNull();
        Assertions.assertThat((Object)taskIO.getNumRecordsOutCounter()).isNotNull();
        SimpleCounter c1 = new SimpleCounter();
        c1.inc(32L);
        SimpleCounter c2 = new SimpleCounter();
        c2.inc(64L);
        taskIO.reuseRecordsInputCounter((Counter)c1);
        taskIO.reuseRecordsOutputCounter((Counter)c2);
        Assertions.assertThat((long)taskIO.getNumRecordsInCounter().getCount()).isEqualTo(32L);
        Assertions.assertThat((long)taskIO.getNumRecordsOutCounter().getCount()).isEqualTo(64L);
        taskIO.getNumBytesInCounter().inc(100L);
        taskIO.getNumBytesOutCounter().inc(250L);
        taskIO.getNumBuffersOutCounter().inc(3L);
        taskIO.getIdleTimeMsPerSecond().markStart();
        taskIO.getSoftBackPressuredTimePerSecond().markStart();
        long softSleepTime = 2L;
        clock.advanceTime(Duration.ofMillis(softSleepTime));
        taskIO.getIdleTimeMsPerSecond().markEnd();
        taskIO.getSoftBackPressuredTimePerSecond().markEnd();
        long hardSleepTime = 4L;
        taskIO.getHardBackPressuredTimePerSecond().markStart();
        clock.advanceTime(Duration.ofMillis(hardSleepTime));
        taskIO.getHardBackPressuredTimePerSecond().markEnd();
        long ioSleepTime = 3L;
        taskIO.getChangelogBusyTimeMsPerSecond().markStart();
        clock.advanceTime(Duration.ofMillis(ioSleepTime));
        taskIO.getChangelogBusyTimeMsPerSecond().markEnd();
        IOMetrics io = taskIO.createSnapshot();
        Assertions.assertThat((long)io.getNumRecordsIn()).isEqualTo(32L);
        Assertions.assertThat((long)io.getNumRecordsOut()).isEqualTo(64L);
        Assertions.assertThat((long)io.getNumBytesIn()).isEqualTo(100L);
        Assertions.assertThat((long)io.getNumBytesOut()).isEqualTo(250L);
        Assertions.assertThat((long)taskIO.getNumBuffersOutCounter().getCount()).isEqualTo(3L);
        Assertions.assertThat((long)taskIO.getIdleTimeMsPerSecond().getAccumulatedCount()).isEqualTo(io.getAccumulateIdleTime());
        Assertions.assertThat((long)(taskIO.getHardBackPressuredTimePerSecond().getAccumulatedCount() + taskIO.getSoftBackPressuredTimePerSecond().getAccumulatedCount())).isEqualTo(io.getAccumulateBackPressuredTime());
        Assertions.assertThat((double)io.getAccumulateBusyTime()).isEqualTo((double)(clock.absoluteTimeMillis() - startTime - io.getAccumulateIdleTime() - io.getAccumulateBackPressuredTime()));
        Assertions.assertThat((long)taskIO.getIdleTimeMsPerSecond().getCount()).isGreaterThanOrEqualTo(softSleepTime);
        Assertions.assertThat((long)taskIO.getSoftBackPressuredTimePerSecond().getCount()).isGreaterThanOrEqualTo(softSleepTime);
        Assertions.assertThat((long)taskIO.getHardBackPressuredTimePerSecond().getCount()).isGreaterThanOrEqualTo(hardSleepTime);
        Assertions.assertThat((long)taskIO.getChangelogBusyTimeMsPerSecond().getCount()).isGreaterThanOrEqualTo(ioSleepTime);
    }

    @Test
    void testConsistencyOfTime() {
        TaskMetricGroup task = UnregisteredMetricGroups.createUnregisteredTaskMetricGroup();
        ManualClock clock = new ManualClock(System.currentTimeMillis());
        TaskIOMetricGroup taskIO = new TaskIOMetricGroup(task, (Clock)clock);
        taskIO.setEnableBusyTime(true);
        taskIO.markTaskStart();
        long startTime = clock.absoluteTimeMillis();
        long softBackpressureTime = 100L;
        taskIO.getSoftBackPressuredTimePerSecond().markStart();
        clock.advanceTime(Duration.ofMillis(softBackpressureTime));
        taskIO.getSoftBackPressuredTimePerSecond().markEnd();
        Assertions.assertThat((long)taskIO.getSoftBackPressuredTimePerSecond().getAccumulatedCount()).isGreaterThanOrEqualTo(softBackpressureTime);
        long hardBackpressureTime = 200L;
        taskIO.getHardBackPressuredTimePerSecond().markStart();
        clock.advanceTime(Duration.ofMillis(hardBackpressureTime));
        taskIO.getHardBackPressuredTimePerSecond().markEnd();
        Assertions.assertThat((long)taskIO.getHardBackPressuredTimePerSecond().getAccumulatedCount()).isGreaterThanOrEqualTo(hardBackpressureTime);
        long changelogBusyTime = 300L;
        taskIO.getChangelogBusyTimeMsPerSecond().markStart();
        clock.advanceTime(Duration.ofMillis(changelogBusyTime));
        taskIO.getChangelogBusyTimeMsPerSecond().markEnd();
        Assertions.assertThat((long)taskIO.getChangelogBusyTimeMsPerSecond().getAccumulatedCount()).isGreaterThanOrEqualTo(changelogBusyTime);
        long idleTime = 200L;
        taskIO.getIdleTimeMsPerSecond().markStart();
        clock.advanceTime(Duration.ofMillis(idleTime));
        taskIO.getIdleTimeMsPerSecond().markEnd();
        Assertions.assertThat((long)taskIO.getIdleTimeMsPerSecond().getAccumulatedCount()).isGreaterThanOrEqualTo(idleTime);
        long totalDuration = clock.absoluteTimeMillis() - startTime;
        Assertions.assertThat((double)taskIO.getAccumulatedBusyTime()).isEqualTo((double)(totalDuration - taskIO.getAccumulatedBackPressuredTimeMs() - taskIO.getIdleTimeMsPerSecond().getAccumulatedCount()));
    }

    @Test
    void testResultPartitionBytesMetrics() {
        TaskMetricGroup task = UnregisteredMetricGroups.createUnregisteredTaskMetricGroup();
        TaskIOMetricGroup taskIO = task.getIOMetricGroup();
        ResultPartitionBytesCounter c1 = new ResultPartitionBytesCounter(2);
        ResultPartitionBytesCounter c2 = new ResultPartitionBytesCounter(2);
        c1.inc(0, 32L);
        c1.inc(1, 64L);
        c2.incAll(128L);
        IntermediateResultPartitionID resultPartitionID1 = new IntermediateResultPartitionID();
        IntermediateResultPartitionID resultPartitionID2 = new IntermediateResultPartitionID();
        taskIO.registerResultPartitionBytesCounter(resultPartitionID1, c1);
        taskIO.registerResultPartitionBytesCounter(resultPartitionID2, c2);
        Map resultPartitionBytes = taskIO.createSnapshot().getResultPartitionBytes();
        Assertions.assertThat((int)resultPartitionBytes.size()).isEqualTo(2);
        Assertions.assertThat((long[])((ResultPartitionBytes)resultPartitionBytes.get(resultPartitionID1)).getSubpartitionBytes()).containsExactly(new long[]{32L, 64L});
        Assertions.assertThat((long[])((ResultPartitionBytes)resultPartitionBytes.get(resultPartitionID2)).getSubpartitionBytes()).containsExactly(new long[]{128L, 128L});
    }
}

