/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.runtime.leaderelection.DefaultLeaderElection;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.TestingGenericLeaderContender;
import org.apache.flink.util.function.BiConsumerWithException;
import org.apache.flink.util.function.TriConsumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultLeaderElectionTest {
    private static final String DEFAULT_TEST_COMPONENT_ID = "test-component-id";

    DefaultLeaderElectionTest() {
    }

    @Test
    void testContenderRegistration() throws Exception {
        AtomicReference componentIdRef = new AtomicReference();
        AtomicReference contenderRef = new AtomicReference();
        TestingAbstractLeaderElectionService parentService = TestingAbstractLeaderElectionService.newBuilder().setRegisterConsumer((BiConsumerWithException<String, LeaderContender, Exception>)((BiConsumerWithException)(actualComponentId, actualContender) -> {
            componentIdRef.set(actualComponentId);
            contenderRef.set(actualContender);
        })).build();
        try (DefaultLeaderElection testInstance = new DefaultLeaderElection((DefaultLeaderElection.ParentService)parentService, DEFAULT_TEST_COMPONENT_ID);){
            TestingGenericLeaderContender contender = TestingGenericLeaderContender.newBuilder().build();
            testInstance.startLeaderElection((LeaderContender)contender);
            Assertions.assertThat(componentIdRef).hasValue((Object)DEFAULT_TEST_COMPONENT_ID);
            Assertions.assertThat(contenderRef.get()).isSameAs((Object)contender);
        }
    }

    @Test
    void testContenderRegistrationNull() throws Exception {
        try (DefaultLeaderElection testInstance = new DefaultLeaderElection((DefaultLeaderElection.ParentService)TestingAbstractLeaderElectionService.newBuilder().build(), DEFAULT_TEST_COMPONENT_ID);){
            Assertions.assertThatThrownBy(() -> testInstance.startLeaderElection(null)).isInstanceOf(NullPointerException.class);
        }
    }

    @Test
    void testContenderRegistrationFailure() throws Exception {
        Exception expectedException = new Exception("Expected exception during contender registration.");
        TestingAbstractLeaderElectionService parentService = TestingAbstractLeaderElectionService.newBuilder().setRegisterConsumer((BiConsumerWithException<String, LeaderContender, Exception>)((BiConsumerWithException)(actualComponentId, actualContender) -> {
            throw expectedException;
        })).build();
        try (DefaultLeaderElection testInstance = new DefaultLeaderElection((DefaultLeaderElection.ParentService)parentService, DEFAULT_TEST_COMPONENT_ID);){
            Assertions.assertThatThrownBy(() -> testInstance.startLeaderElection((LeaderContender)TestingGenericLeaderContender.newBuilder().build())).isEqualTo((Object)expectedException);
        }
    }

    @Test
    void testLeaderConfirmation() throws Exception {
        AtomicReference componentIdRef = new AtomicReference();
        AtomicReference leaderSessionIDRef = new AtomicReference();
        AtomicReference leaderAddressRef = new AtomicReference();
        TestingAbstractLeaderElectionService parentService = TestingAbstractLeaderElectionService.newBuilder().setConfirmLeadershipConsumer((TriConsumer<String, UUID, String>)((TriConsumer)(componentId, leaderSessionID, address) -> {
            componentIdRef.set(componentId);
            leaderSessionIDRef.set(leaderSessionID);
            leaderAddressRef.set(address);
        })).build();
        try (DefaultLeaderElection testInstance = new DefaultLeaderElection((DefaultLeaderElection.ParentService)parentService, DEFAULT_TEST_COMPONENT_ID);){
            UUID expectedLeaderSessionID = UUID.randomUUID();
            String expectedAddress = "random-address";
            testInstance.confirmLeadership(expectedLeaderSessionID, "random-address");
            Assertions.assertThat(componentIdRef).hasValue((Object)DEFAULT_TEST_COMPONENT_ID);
            Assertions.assertThat(leaderSessionIDRef).hasValue((Object)expectedLeaderSessionID);
            Assertions.assertThat(leaderAddressRef).hasValue((Object)"random-address");
        }
    }

    @Test
    void testClose() throws Exception {
        CompletableFuture actualComponentId = new CompletableFuture();
        TestingAbstractLeaderElectionService parentService = TestingAbstractLeaderElectionService.newBuilder().setRegisterConsumer((BiConsumerWithException<String, LeaderContender, Exception>)((BiConsumerWithException)(ignoredComponentId, ignoredContender) -> {})).setRemoveConsumer(actualComponentId::complete).build();
        DefaultLeaderElection testInstance = new DefaultLeaderElection((DefaultLeaderElection.ParentService)parentService, DEFAULT_TEST_COMPONENT_ID);
        testInstance.startLeaderElection((LeaderContender)TestingGenericLeaderContender.newBuilder().build());
        testInstance.close();
        Assertions.assertThat(actualComponentId).isCompletedWithValue((Object)DEFAULT_TEST_COMPONENT_ID);
    }

    @Test
    void testCloseWithoutStart() throws Exception {
        CompletableFuture actualComponentId = new CompletableFuture();
        TestingAbstractLeaderElectionService parentService = TestingAbstractLeaderElectionService.newBuilder().setRemoveConsumer(actualComponentId::complete).build();
        DefaultLeaderElection testInstance = new DefaultLeaderElection((DefaultLeaderElection.ParentService)parentService, DEFAULT_TEST_COMPONENT_ID);
        testInstance.close();
        FlinkAssertions.assertThatFuture(actualComponentId).eventuallySucceeds().isEqualTo((Object)DEFAULT_TEST_COMPONENT_ID);
    }

    @Test
    void testHasLeadershipTrue() throws Exception {
        this.testHasLeadership(true);
    }

    @Test
    void testHasLeadershipFalse() throws Exception {
        this.testHasLeadership(false);
    }

    private void testHasLeadership(boolean expectedReturnValue) throws Exception {
        AtomicReference componentIdRef = new AtomicReference();
        AtomicReference leaderSessionIDRef = new AtomicReference();
        TestingAbstractLeaderElectionService parentService = TestingAbstractLeaderElectionService.newBuilder().setHasLeadershipFunction((actualComponentId, actualLeaderSessionID) -> {
            componentIdRef.set(actualComponentId);
            leaderSessionIDRef.set(actualLeaderSessionID);
            return expectedReturnValue;
        }).build();
        try (DefaultLeaderElection testInstance = new DefaultLeaderElection((DefaultLeaderElection.ParentService)parentService, DEFAULT_TEST_COMPONENT_ID);){
            UUID expectedLeaderSessionID = UUID.randomUUID();
            Assertions.assertThat((boolean)testInstance.hasLeadership(expectedLeaderSessionID)).isEqualTo(expectedReturnValue);
            Assertions.assertThat(componentIdRef).hasValue((Object)DEFAULT_TEST_COMPONENT_ID);
            Assertions.assertThat(leaderSessionIDRef).hasValue((Object)expectedLeaderSessionID);
        }
    }

    private static class TestingAbstractLeaderElectionService
    extends DefaultLeaderElection.ParentService {
        private final BiConsumerWithException<String, LeaderContender, Exception> registerConsumer;
        private final Consumer<String> removeConsumer;
        private final TriConsumer<String, UUID, String> confirmLeadershipConsumer;
        private final BiFunction<String, UUID, Boolean> hasLeadershipFunction;

        private TestingAbstractLeaderElectionService(BiConsumerWithException<String, LeaderContender, Exception> registerConsumer, Consumer<String> removeConsumer, TriConsumer<String, UUID, String> confirmLeadershipConsumer, BiFunction<String, UUID, Boolean> hasLeadershipFunction) {
            this.registerConsumer = registerConsumer;
            this.removeConsumer = removeConsumer;
            this.confirmLeadershipConsumer = confirmLeadershipConsumer;
            this.hasLeadershipFunction = hasLeadershipFunction;
        }

        protected void register(String componentId, LeaderContender contender) throws Exception {
            this.registerConsumer.accept((Object)componentId, (Object)contender);
        }

        protected void remove(String componentId) {
            this.removeConsumer.accept(componentId);
        }

        protected void confirmLeadership(String componentId, UUID leaderSessionID, String leaderAddress) {
            this.confirmLeadershipConsumer.accept((Object)componentId, (Object)leaderSessionID, (Object)leaderAddress);
        }

        protected boolean hasLeadership(String componentId, UUID leaderSessionId) {
            return this.hasLeadershipFunction.apply(componentId, leaderSessionId);
        }

        public static Builder newBuilder() {
            return new Builder().setRegisterConsumer((BiConsumerWithException<String, LeaderContender, Exception>)((BiConsumerWithException)(componentId, contender) -> {
                throw new UnsupportedOperationException("register not supported");
            })).setRemoveConsumer(componentId -> {}).setConfirmLeadershipConsumer((TriConsumer<String, UUID, String>)((TriConsumer)(componentId, leaderSessionID, address) -> {
                throw new UnsupportedOperationException("confirmLeadership not supported");
            })).setHasLeadershipFunction((componentId, leaderSessionID) -> {
                throw new UnsupportedOperationException("hasLeadership not supported");
            });
        }

        private static class Builder {
            private BiConsumerWithException<String, LeaderContender, Exception> registerConsumer;
            private Consumer<String> removeConsumer;
            private TriConsumer<String, UUID, String> confirmLeadershipConsumer;
            private BiFunction<String, UUID, Boolean> hasLeadershipFunction;

            private Builder() {
            }

            public Builder setRegisterConsumer(BiConsumerWithException<String, LeaderContender, Exception> registerConsumer) {
                this.registerConsumer = registerConsumer;
                return this;
            }

            public Builder setRemoveConsumer(Consumer<String> removeConsumer) {
                this.removeConsumer = removeConsumer;
                return this;
            }

            public Builder setConfirmLeadershipConsumer(TriConsumer<String, UUID, String> confirmLeadershipConsumer) {
                this.confirmLeadershipConsumer = confirmLeadershipConsumer;
                return this;
            }

            public Builder setHasLeadershipFunction(BiFunction<String, UUID, Boolean> hasLeadershipFunction) {
                this.hasLeadershipFunction = hasLeadershipFunction;
                return this;
            }

            public TestingAbstractLeaderElectionService build() {
                return new TestingAbstractLeaderElectionService(this.registerConsumer, this.removeConsumer, this.confirmLeadershipConsumer, this.hasLeadershipFunction);
            }
        }
    }
}

