/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.PartitionFileWriter;

public class TieredStorageTestUtils {
    public static List<PartitionFileWriter.SubpartitionBufferContext> generateBuffersToWrite(int numSubpartitions, int numSegments, int numBuffersPerSegment, int bufferSizeBytes) {
        ArrayList<PartitionFileWriter.SubpartitionBufferContext> subpartitionBuffers = new ArrayList<PartitionFileWriter.SubpartitionBufferContext>();
        for (int i = 0; i < numSubpartitions; ++i) {
            ArrayList<PartitionFileWriter.SegmentBufferContext> segmentBufferContexts = new ArrayList<PartitionFileWriter.SegmentBufferContext>();
            for (int j = 0; j < numSegments; ++j) {
                int k;
                ArrayList<Tuple2> bufferAndIndexes = new ArrayList<Tuple2>();
                for (k = 0; k < numBuffersPerSegment / 2; ++k) {
                    bufferAndIndexes.add(new Tuple2((Object)BufferBuilderTestUtils.buildSomeBuffer(bufferSizeBytes), (Object)k));
                }
                segmentBufferContexts.add(new PartitionFileWriter.SegmentBufferContext(j, bufferAndIndexes, false));
                bufferAndIndexes = new ArrayList();
                for (k = numBuffersPerSegment / 2; k < numBuffersPerSegment; ++k) {
                    bufferAndIndexes.add(new Tuple2((Object)BufferBuilderTestUtils.buildSomeBuffer(bufferSizeBytes), (Object)k));
                }
                segmentBufferContexts.add(new PartitionFileWriter.SegmentBufferContext(j, bufferAndIndexes, true));
            }
            subpartitionBuffers.add(new PartitionFileWriter.SubpartitionBufferContext(i, segmentBufferContexts));
        }
        return subpartitionBuffers;
    }
}

