/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.common;

import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageIdMappingUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageTopicId;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TieredStorageIdMappingUtilsTest {
    @Test
    void testConvertDataSetId() {
        IntermediateDataSetID dataSetID = new IntermediateDataSetID();
        TieredStorageTopicId topicId = TieredStorageIdMappingUtils.convertId((IntermediateDataSetID)dataSetID);
        IntermediateDataSetID convertedDataSetID = TieredStorageIdMappingUtils.convertId((TieredStorageTopicId)topicId);
        Assertions.assertThat((Comparable)dataSetID).isEqualTo((Object)convertedDataSetID);
    }

    @Test
    void testConvertResultPartitionId() {
        ResultPartitionID resultPartitionID = new ResultPartitionID();
        TieredStoragePartitionId tieredStoragePartitionId = TieredStorageIdMappingUtils.convertId((ResultPartitionID)resultPartitionID);
        ResultPartitionID convertedResultPartitionID = TieredStorageIdMappingUtils.convertId((TieredStoragePartitionId)tieredStoragePartitionId);
        Assertions.assertThat((Object)resultPartitionID).isEqualTo((Object)convertedResultPartitionID);
    }

    @Test
    void testConvertSubpartitionId() {
        int subpartitionId = 2;
        TieredStorageSubpartitionId tieredStorageSubpartitionId = TieredStorageIdMappingUtils.convertId((int)subpartitionId);
        int convertedSubpartitionId = TieredStorageIdMappingUtils.convertId((TieredStorageSubpartitionId)tieredStorageSubpartitionId);
        Assertions.assertThat((int)subpartitionId).isEqualTo(convertedSubpartitionId);
    }
}

