/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManager;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemorySpec;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.util.function.TriConsumer;

public class TestingTieredStorageMemoryManager
implements TieredStorageMemoryManager {
    private final BiConsumer<BufferPool, List<TieredStorageMemorySpec>> setupConsumer;
    private final Consumer<TaskIOMetricGroup> setMetricGroupConsumer;
    private final Consumer<Runnable> listenBufferReclaimRequestConsumer;
    private final Function<Object, BufferBuilder> requestBufferBlockingFunction;
    private final Function<Object, Integer> getMaxNonReclaimableBuffersFunction;
    private final Function<Object, Integer> numOwnerRequestedBufferFunction;
    private final TriConsumer<Object, Object, Buffer> transferBufferOwnershipConsumer;
    private final Runnable releaseRunnable;

    private TestingTieredStorageMemoryManager(BiConsumer<BufferPool, List<TieredStorageMemorySpec>> setupConsumer, Consumer<TaskIOMetricGroup> setMetricGroupConsumer, Consumer<Runnable> listenBufferReclaimRequestConsumer, Function<Object, BufferBuilder> requestBufferBlockingFunction, Function<Object, Integer> getMaxNonReclaimableBuffersFunction, Function<Object, Integer> numOwnerRequestedBufferFunction, TriConsumer<Object, Object, Buffer> transferBufferOwnershipConsumer, Runnable releaseRunnable) {
        this.setupConsumer = setupConsumer;
        this.setMetricGroupConsumer = setMetricGroupConsumer;
        this.listenBufferReclaimRequestConsumer = listenBufferReclaimRequestConsumer;
        this.requestBufferBlockingFunction = requestBufferBlockingFunction;
        this.getMaxNonReclaimableBuffersFunction = getMaxNonReclaimableBuffersFunction;
        this.numOwnerRequestedBufferFunction = numOwnerRequestedBufferFunction;
        this.transferBufferOwnershipConsumer = transferBufferOwnershipConsumer;
        this.releaseRunnable = releaseRunnable;
    }

    public void setup(BufferPool bufferPool, List<TieredStorageMemorySpec> storageMemorySpecs) {
        this.setupConsumer.accept(bufferPool, storageMemorySpecs);
    }

    public void setMetricGroup(TaskIOMetricGroup metricGroup) {
        this.setMetricGroupConsumer.accept(metricGroup);
    }

    public void listenBufferReclaimRequest(Runnable onBufferReclaimRequest) {
        this.listenBufferReclaimRequestConsumer.accept(onBufferReclaimRequest);
    }

    public BufferBuilder requestBufferBlocking(Object owner) {
        return this.requestBufferBlockingFunction.apply(owner);
    }

    public int getMaxNonReclaimableBuffers(Object owner) {
        return this.getMaxNonReclaimableBuffersFunction.apply(owner);
    }

    public int numOwnerRequestedBuffer(Object owner) {
        return this.numOwnerRequestedBufferFunction.apply(owner);
    }

    public void transferBufferOwnership(Object oldOwner, Object newOwner, Buffer buffer) {
        this.transferBufferOwnershipConsumer.accept(oldOwner, newOwner, (Object)buffer);
    }

    public void release() {
        this.releaseRunnable.run();
    }

    public static class Builder {
        private BiConsumer<BufferPool, List<TieredStorageMemorySpec>> setupConsumer = (bufferPool, tieredStorageMemorySpecs) -> {};
        private Consumer<TaskIOMetricGroup> setMetricGroupConsumer = ignore -> {};
        private Consumer<Runnable> listenBufferReclaimRequestConsumer = runnable -> {};
        private Function<Object, BufferBuilder> requestBufferBlockingFunction = owner -> null;
        private Function<Object, Integer> getMaxNonReclaimableBuffersFunction = owner -> 0;
        private Function<Object, Integer> numOwnerRequestedBufferFunction = owner -> 0;
        private TriConsumer<Object, Object, Buffer> transferBufferOwnershipConsumer = (oldOwner, newOwner, buffer) -> {};
        private Runnable releaseRunnable = () -> {};

        public Builder setSetupConsumer(BiConsumer<BufferPool, List<TieredStorageMemorySpec>> setupConsumer) {
            this.setupConsumer = setupConsumer;
            return this;
        }

        public Builder setListenBufferReclaimRequestConsumer(Consumer<Runnable> listenBufferReclaimRequestConsumer) {
            this.listenBufferReclaimRequestConsumer = listenBufferReclaimRequestConsumer;
            return this;
        }

        public Builder setRequestBufferBlockingFunction(Function<Object, BufferBuilder> requestBufferBlockingFunction) {
            this.requestBufferBlockingFunction = requestBufferBlockingFunction;
            return this;
        }

        public Builder setGetMaxNonReclaimableBuffersFunction(Function<Object, Integer> getMaxNonReclaimableBuffersFunction) {
            this.getMaxNonReclaimableBuffersFunction = getMaxNonReclaimableBuffersFunction;
            return this;
        }

        public Builder setNumOwnerRequestedBufferFunction(Function<Object, Integer> numOwnerRequestedBufferFunction) {
            this.numOwnerRequestedBufferFunction = numOwnerRequestedBufferFunction;
            return this;
        }

        public Builder setTransferBufferOwnershipConsumer(TriConsumer<Object, Object, Buffer> transferBufferOwnershipConsumer) {
            this.transferBufferOwnershipConsumer = transferBufferOwnershipConsumer;
            return this;
        }

        public Builder setReleaseRunnable(Runnable releaseRunnable) {
            this.releaseRunnable = releaseRunnable;
            return this;
        }

        public TestingTieredStorageMemoryManager build() {
            return new TestingTieredStorageMemoryManager(this.setupConsumer, this.setMetricGroupConsumer, this.listenBufferReclaimRequestConsumer, this.requestBufferBlockingFunction, this.getMaxNonReclaimableBuffersFunction, this.numOwnerRequestedBufferFunction, this.transferBufferOwnershipConsumer, this.releaseRunnable);
        }
    }
}

