/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.util.TestCounter;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.hybrid.BufferIndexAndChannel;
import org.apache.flink.runtime.io.network.partition.hybrid.HsFileDataIndexImpl;
import org.apache.flink.runtime.io.network.partition.hybrid.HsOutputMetrics;
import org.apache.flink.runtime.io.network.partition.hybrid.index.FileDataIndexRegionHelper;
import org.apache.flink.runtime.io.network.partition.hybrid.index.TestingFileDataIndexRegion;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.ProducerMergedPartitionFileIndex;
import org.apache.flink.runtime.metrics.TimerGauge;
import org.assertj.core.api.Assertions;

public class HybridShuffleTestUtils {
    public static final int MEMORY_SEGMENT_SIZE = 128;

    public static List<BufferIndexAndChannel> createBufferIndexAndChannelsList(int subpartitionId, int ... bufferIndexes) {
        ArrayList<BufferIndexAndChannel> bufferIndexAndChannels = new ArrayList<BufferIndexAndChannel>();
        for (int bufferIndex : bufferIndexes) {
            bufferIndexAndChannels.add(new BufferIndexAndChannel(bufferIndex, subpartitionId));
        }
        return bufferIndexAndChannels;
    }

    public static Deque<BufferIndexAndChannel> createBufferIndexAndChannelsDeque(int subpartitionId, int ... bufferIndexes) {
        ArrayDeque<BufferIndexAndChannel> bufferIndexAndChannels = new ArrayDeque<BufferIndexAndChannel>();
        for (int bufferIndex : bufferIndexes) {
            bufferIndexAndChannels.add(new BufferIndexAndChannel(bufferIndex, subpartitionId));
        }
        return bufferIndexAndChannels;
    }

    public static Buffer createBuffer(int bufferSize, boolean isEvent) {
        return new NetworkBuffer(MemorySegmentFactory.allocateUnpooledSegment((int)bufferSize), FreeingBufferRecycler.INSTANCE, isEvent ? Buffer.DataType.EVENT_BUFFER : Buffer.DataType.DATA_BUFFER, bufferSize);
    }

    public static BufferBuilder createBufferBuilder(int bufferSize) {
        return new BufferBuilder(MemorySegmentFactory.allocateUnpooledSegment((int)bufferSize), FreeingBufferRecycler.INSTANCE);
    }

    public static HsOutputMetrics createTestingOutputMetrics() {
        return new HsOutputMetrics((Counter)new TestCounter(), (Counter)new TestCounter(), new TimerGauge());
    }

    public static TestingFileDataIndexRegion createSingleTestRegion(int firstBufferIndex, long firstBufferOffset, int numBuffersPerRegion) {
        return new TestingFileDataIndexRegion.Builder().setGetSizeSupplier(() -> 16).setContainBufferFunction(bufferIndex -> TestingFileDataIndexRegion.getContainBufferFunction(bufferIndex, firstBufferIndex, numBuffersPerRegion)).setGetFirstBufferIndexSupplier(() -> firstBufferIndex).setGetRegionFileOffsetSupplier(() -> firstBufferOffset).setGetNumBuffersSupplier(() -> numBuffersPerRegion).build();
    }

    public static List<TestingFileDataIndexRegion> createTestRegions(int firstBufferIndex, long firstBufferOffset, int numBuffersPerRegion, int numRegions) {
        ArrayList<TestingFileDataIndexRegion> regions = new ArrayList<TestingFileDataIndexRegion>();
        int bufferIndex = firstBufferIndex;
        long bufferOffset = firstBufferOffset;
        int numRegionSize = 16;
        for (int i = 0; i < numRegions; ++i) {
            int currentBufferIndex = bufferIndex;
            long currentBufferOffset = bufferOffset;
            regions.add(new TestingFileDataIndexRegion.Builder().setGetSizeSupplier(() -> numRegionSize).setGetFirstBufferIndexSupplier(() -> currentBufferIndex).setGetRegionFileOffsetSupplier(() -> currentBufferOffset).setGetNumBuffersSupplier(() -> numBuffersPerRegion).setContainBufferFunction(index -> TestingFileDataIndexRegion.getContainBufferFunction(index, firstBufferIndex, numBuffersPerRegion)).build());
            bufferIndex += numBuffersPerRegion;
            bufferOffset += bufferOffset;
        }
        return regions;
    }

    public static FileDataIndexRegionHelper.Region createSingleFixedSizeRegion(int firstBufferIndex, long firstBufferOffset, long lastBufferEndOffset, int numBuffersPerRegion) {
        return new ProducerMergedPartitionFileIndex.FixedSizeRegion(firstBufferIndex, firstBufferOffset, lastBufferEndOffset, numBuffersPerRegion);
    }

    public static void assertRegionEquals(FileDataIndexRegionHelper.Region expected, FileDataIndexRegionHelper.Region region) {
        Assertions.assertThat((int)region.getFirstBufferIndex()).isEqualTo(expected.getFirstBufferIndex());
        Assertions.assertThat((long)region.getRegionStartOffset()).isEqualTo(expected.getRegionStartOffset());
        Assertions.assertThat((int)region.getNumBuffers()).isEqualTo(expected.getNumBuffers());
        if (expected instanceof HsFileDataIndexImpl.InternalRegion) {
            Assertions.assertThat((Object)region).isInstanceOf(HsFileDataIndexImpl.InternalRegion.class);
            Assertions.assertThat((boolean[])((HsFileDataIndexImpl.InternalRegion)region).getReleased()).isEqualTo((Object)((HsFileDataIndexImpl.InternalRegion)expected).getReleased());
        }
    }
}

