/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.util.Random;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.event.task.IntegerTaskEvent;
import org.apache.flink.runtime.io.network.netty.NettyMessage;
import org.apache.flink.runtime.io.network.netty.NettyTestUtil;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NettyMessageServerSideSerializationTest
extends TestLogger {
    private final Random random = new Random();
    private EmbeddedChannel channel;

    @Before
    public void setup() {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new NettyMessage.NettyMessageEncoder(), new NettyMessage.NettyMessageDecoder()});
    }

    @After
    public void tearDown() {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    @Test
    public void testPartitionRequest() {
        NettyMessage.PartitionRequest expected = new NettyMessage.PartitionRequest(new ResultPartitionID(), this.random.nextInt(), new InputChannelID(), this.random.nextInt());
        NettyMessage.PartitionRequest actual = NettyTestUtil.encodeAndDecode(expected, this.channel);
        Assert.assertEquals((Object)expected.partitionId, (Object)actual.partitionId);
        Assert.assertEquals((long)expected.queueIndex, (long)actual.queueIndex);
        Assert.assertEquals((Object)expected.receiverId, (Object)actual.receiverId);
        Assert.assertEquals((long)expected.credit, (long)actual.credit);
    }

    @Test
    public void testTaskEventRequest() {
        NettyMessage.TaskEventRequest expected = new NettyMessage.TaskEventRequest((TaskEvent)new IntegerTaskEvent(this.random.nextInt()), new ResultPartitionID(), new InputChannelID());
        NettyMessage.TaskEventRequest actual = NettyTestUtil.encodeAndDecode(expected, this.channel);
        Assert.assertEquals((Object)expected.event, (Object)actual.event);
        Assert.assertEquals((Object)expected.partitionId, (Object)actual.partitionId);
        Assert.assertEquals((Object)expected.receiverId, (Object)actual.receiverId);
    }

    @Test
    public void testCancelPartitionRequest() {
        NettyMessage.CancelPartitionRequest expected = new NettyMessage.CancelPartitionRequest(new InputChannelID());
        NettyMessage.CancelPartitionRequest actual = NettyTestUtil.encodeAndDecode(expected, this.channel);
        Assert.assertEquals((Object)expected.receiverId, (Object)actual.receiverId);
    }

    @Test
    public void testCloseRequest() {
        NettyMessage.CloseRequest expected = new NettyMessage.CloseRequest();
        NettyMessage.CloseRequest actual = NettyTestUtil.encodeAndDecode(expected, this.channel);
        Assert.assertEquals(expected.getClass(), actual.getClass());
    }

    @Test
    public void testAddCredit() {
        NettyMessage.AddCredit expected = new NettyMessage.AddCredit(this.random.nextInt(Integer.MAX_VALUE) + 1, new InputChannelID());
        NettyMessage.AddCredit actual = NettyTestUtil.encodeAndDecode(expected, this.channel);
        Assert.assertEquals((long)expected.credit, (long)actual.credit);
        Assert.assertEquals((Object)expected.receiverId, (Object)actual.receiverId);
    }

    @Test
    public void testResumeConsumption() {
        NettyMessage.ResumeConsumption expected = new NettyMessage.ResumeConsumption(new InputChannelID());
        NettyMessage.ResumeConsumption actual = NettyTestUtil.encodeAndDecode(expected, this.channel);
        Assert.assertEquals((Object)expected.receiverId, (Object)actual.receiverId);
    }

    @Test
    public void testAckAllUserRecordsProcessed() {
        NettyMessage.AckAllUserRecordsProcessed expected = new NettyMessage.AckAllUserRecordsProcessed(new InputChannelID());
        NettyMessage.AckAllUserRecordsProcessed actual = NettyTestUtil.encodeAndDecode(expected, this.channel);
        Assert.assertEquals((Object)expected.receiverId, (Object)actual.receiverId);
    }

    @Test
    public void testNewBufferSize() {
        NettyMessage.NewBufferSize expected = new NettyMessage.NewBufferSize(this.random.nextInt(Integer.MAX_VALUE), new InputChannelID());
        NettyMessage.NewBufferSize actual = NettyTestUtil.encodeAndDecode(expected, this.channel);
        Assert.assertEquals((long)expected.bufferSize, (long)actual.bufferSize);
        Assert.assertEquals((Object)expected.receiverId, (Object)actual.receiverId);
    }
}

