/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.checkpoint.SavepointType;
import org.apache.flink.runtime.checkpoint.SnapshotType;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.CancelCheckpointMarker;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.api.EndOfData;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.EndOfSegmentEvent;
import org.apache.flink.runtime.io.network.api.EndOfSuperstepEvent;
import org.apache.flink.runtime.io.network.api.EventAnnouncement;
import org.apache.flink.runtime.io.network.api.StopMode;
import org.apache.flink.runtime.io.network.api.SubtaskConnectionDescriptor;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.util.TestTaskEvent;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.junit.Assert;
import org.junit.Test;

public class EventSerializerTest {
    private final AbstractEvent[] events = new AbstractEvent[]{EndOfPartitionEvent.INSTANCE, EndOfSuperstepEvent.INSTANCE, new EndOfData(StopMode.DRAIN), new EndOfData(StopMode.NO_DRAIN), new CheckpointBarrier(1678L, 4623784L, new CheckpointOptions((SnapshotType)CheckpointType.CHECKPOINT, CheckpointStorageLocationReference.getDefault())), new CheckpointBarrier(1678L, 4623784L, new CheckpointOptions((SnapshotType)CheckpointType.FULL_CHECKPOINT, CheckpointStorageLocationReference.getDefault())), new CheckpointBarrier(1678L, 4623784L, new CheckpointOptions((SnapshotType)SavepointType.savepoint((SavepointFormatType)SavepointFormatType.CANONICAL), CheckpointStorageLocationReference.getDefault())), new CheckpointBarrier(1678L, 4623784L, new CheckpointOptions((SnapshotType)SavepointType.suspend((SavepointFormatType)SavepointFormatType.CANONICAL), CheckpointStorageLocationReference.getDefault())), new CheckpointBarrier(1678L, 4623784L, new CheckpointOptions((SnapshotType)SavepointType.terminate((SavepointFormatType)SavepointFormatType.CANONICAL), CheckpointStorageLocationReference.getDefault())), new CheckpointBarrier(1678L, 4623784L, new CheckpointOptions((SnapshotType)SavepointType.savepoint((SavepointFormatType)SavepointFormatType.NATIVE), CheckpointStorageLocationReference.getDefault())), new CheckpointBarrier(1678L, 4623784L, new CheckpointOptions((SnapshotType)SavepointType.suspend((SavepointFormatType)SavepointFormatType.NATIVE), CheckpointStorageLocationReference.getDefault())), new CheckpointBarrier(1678L, 4623784L, new CheckpointOptions((SnapshotType)SavepointType.terminate((SavepointFormatType)SavepointFormatType.NATIVE), CheckpointStorageLocationReference.getDefault())), new TestTaskEvent(Math.random(), 12361231273L), new CancelCheckpointMarker(287087987329842L), new EventAnnouncement((AbstractEvent)new CheckpointBarrier(42L, 1337L, CheckpointOptions.alignedWithTimeout((SnapshotType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)CheckpointStorageLocationReference.getDefault(), (long)10L)), 44), new SubtaskConnectionDescriptor(23, 42), EndOfSegmentEvent.INSTANCE};

    @Test
    public void testSerializeDeserializeEvent() throws Exception {
        for (AbstractEvent evt : this.events) {
            ByteBuffer serializedEvent = EventSerializer.toSerializedEvent((AbstractEvent)evt);
            Assert.assertTrue((boolean)serializedEvent.hasRemaining());
            AbstractEvent deserialized = EventSerializer.fromSerializedEvent((ByteBuffer)serializedEvent, (ClassLoader)this.getClass().getClassLoader());
            Assert.assertNotNull((Object)deserialized);
            Assert.assertEquals((Object)evt, (Object)deserialized);
        }
    }

    @Test
    public void testToBufferConsumer() throws IOException {
        for (AbstractEvent evt : this.events) {
            BufferConsumer bufferConsumer = EventSerializer.toBufferConsumer((AbstractEvent)evt, (boolean)false);
            Assert.assertFalse((boolean)bufferConsumer.isBuffer());
            Assert.assertTrue((boolean)bufferConsumer.isFinished());
            Assert.assertTrue((boolean)bufferConsumer.isDataAvailable());
            Assert.assertFalse((boolean)bufferConsumer.isRecycled());
            if (evt instanceof CheckpointBarrier) {
                Assert.assertTrue((boolean)bufferConsumer.build().getDataType().isBlockingUpstream());
                continue;
            }
            Assert.assertEquals((Object)Buffer.DataType.EVENT_BUFFER, (Object)bufferConsumer.build().getDataType());
        }
    }

    @Test
    public void testToBuffer() throws IOException {
        for (AbstractEvent evt : this.events) {
            Buffer buffer = EventSerializer.toBuffer((AbstractEvent)evt, (boolean)false);
            Assert.assertFalse((boolean)buffer.isBuffer());
            Assert.assertTrue((buffer.readableBytes() > 0 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)buffer.isRecycled());
            if (evt instanceof CheckpointBarrier) {
                Assert.assertTrue((boolean)buffer.getDataType().isBlockingUpstream());
                continue;
            }
            Assert.assertEquals((Object)Buffer.DataType.EVENT_BUFFER, (Object)buffer.getDataType());
        }
    }
}

