/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability;

import java.io.IOException;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.highavailability.JobResultEntry;
import org.apache.flink.runtime.highavailability.JobResultStore;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.testutils.TestingJobResultStore;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public interface JobResultStoreContractTest {
    public static final JobResultEntry DUMMY_JOB_RESULT_ENTRY = new JobResultEntry(TestingJobResultStore.DUMMY_JOB_RESULT);

    public JobResultStore createJobResultStore() throws IOException;

    @Test
    default public void testStoreJobResultsWithDuplicateIDsThrowsException() throws IOException {
        JobResultStore jobResultStore = this.createJobResultStore();
        jobResultStore.createDirtyResult(DUMMY_JOB_RESULT_ENTRY);
        JobResultEntry otherEntryWithDuplicateId = new JobResultEntry(TestingJobResultStore.createSuccessfulJobResult(DUMMY_JOB_RESULT_ENTRY.getJobId()));
        AssertionsForClassTypes.assertThatThrownBy(() -> jobResultStore.createDirtyResult(otherEntryWithDuplicateId)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    default public void testStoreDirtyEntryForAlreadyCleanedJobResultThrowsException() throws IOException {
        JobResultStore jobResultStore = this.createJobResultStore();
        jobResultStore.createDirtyResult(DUMMY_JOB_RESULT_ENTRY);
        jobResultStore.markResultAsClean(DUMMY_JOB_RESULT_ENTRY.getJobId());
        AssertionsForClassTypes.assertThatThrownBy(() -> jobResultStore.createDirtyResult(DUMMY_JOB_RESULT_ENTRY)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    default public void testCleaningDuplicateEntryThrowsNoException() throws IOException {
        JobResultStore jobResultStore = this.createJobResultStore();
        jobResultStore.createDirtyResult(DUMMY_JOB_RESULT_ENTRY);
        jobResultStore.markResultAsClean(DUMMY_JOB_RESULT_ENTRY.getJobId());
        Assertions.assertThatNoException().isThrownBy(() -> jobResultStore.markResultAsClean(DUMMY_JOB_RESULT_ENTRY.getJobId()));
    }

    @Test
    default public void testCleaningNonExistentEntryThrowsException() throws IOException {
        JobResultStore jobResultStore = this.createJobResultStore();
        AssertionsForClassTypes.assertThatThrownBy(() -> jobResultStore.markResultAsClean(DUMMY_JOB_RESULT_ENTRY.getJobId())).isInstanceOf(NoSuchElementException.class);
    }

    @Test
    default public void testHasJobResultEntryWithDirtyEntry() throws IOException {
        JobResultStore jobResultStore = this.createJobResultStore();
        jobResultStore.createDirtyResult(DUMMY_JOB_RESULT_ENTRY);
        Assertions.assertThat((boolean)jobResultStore.hasDirtyJobResultEntry(DUMMY_JOB_RESULT_ENTRY.getJobId())).isTrue();
        Assertions.assertThat((boolean)jobResultStore.hasCleanJobResultEntry(DUMMY_JOB_RESULT_ENTRY.getJobId())).isFalse();
        Assertions.assertThat((boolean)jobResultStore.hasJobResultEntry(DUMMY_JOB_RESULT_ENTRY.getJobId())).isTrue();
    }

    @Test
    default public void testHasJobResultEntryWithCleanEntry() throws IOException {
        JobResultStore jobResultStore = this.createJobResultStore();
        jobResultStore.createDirtyResult(DUMMY_JOB_RESULT_ENTRY);
        jobResultStore.markResultAsClean(DUMMY_JOB_RESULT_ENTRY.getJobId());
        Assertions.assertThat((boolean)jobResultStore.hasDirtyJobResultEntry(DUMMY_JOB_RESULT_ENTRY.getJobId())).isFalse();
        Assertions.assertThat((boolean)jobResultStore.hasCleanJobResultEntry(DUMMY_JOB_RESULT_ENTRY.getJobId())).isTrue();
        Assertions.assertThat((boolean)jobResultStore.hasJobResultEntry(DUMMY_JOB_RESULT_ENTRY.getJobId())).isTrue();
    }

    @Test
    default public void testHasJobResultEntryWithEmptyStore() throws IOException {
        JobResultStore jobResultStore = this.createJobResultStore();
        JobID jobId = new JobID();
        Assertions.assertThat((boolean)jobResultStore.hasDirtyJobResultEntry(jobId)).isFalse();
        Assertions.assertThat((boolean)jobResultStore.hasCleanJobResultEntry(jobId)).isFalse();
        Assertions.assertThat((boolean)jobResultStore.hasJobResultEntry(jobId)).isFalse();
    }

    @Test
    default public void testGetDirtyResultsWithNoEntry() throws IOException {
        JobResultStore jobResultStore = this.createJobResultStore();
        Assertions.assertThat((Collection)jobResultStore.getDirtyResults()).isEmpty();
    }

    @Test
    default public void testGetDirtyResultsWithDirtyEntry() throws IOException {
        JobResultStore jobResultStore = this.createJobResultStore();
        jobResultStore.createDirtyResult(DUMMY_JOB_RESULT_ENTRY);
        ((ObjectAssert)Assertions.assertThat(jobResultStore.getDirtyResults().stream().map(JobResult::getJobId).collect(Collectors.toList())).singleElement()).isEqualTo((Object)DUMMY_JOB_RESULT_ENTRY.getJobId());
    }

    @Test
    default public void testGetDirtyResultsWithDirtyAndCleanEntry() throws IOException {
        JobResultStore jobResultStore = this.createJobResultStore();
        jobResultStore.createDirtyResult(DUMMY_JOB_RESULT_ENTRY);
        jobResultStore.markResultAsClean(DUMMY_JOB_RESULT_ENTRY.getJobId());
        JobResultEntry otherDirtyJobResultEntry = new JobResultEntry(TestingJobResultStore.createSuccessfulJobResult(new JobID()));
        jobResultStore.createDirtyResult(otherDirtyJobResultEntry);
        ((ObjectAssert)Assertions.assertThat(jobResultStore.getDirtyResults().stream().map(JobResult::getJobId).collect(Collectors.toList())).singleElement()).isEqualTo((Object)otherDirtyJobResultEntry.getJobId());
    }
}

