/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.failure;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.ResettableIterator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.core.failure.FailureEnricher;
import org.apache.flink.core.failure.FailureEnricherFactory;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.core.plugin.TestingPluginManager;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.failure.FailureEnricherUtils;
import org.apache.flink.util.TestLoggerExtension;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={TestLoggerExtension.class})
class FailureEnricherUtilsTest {
    FailureEnricherUtilsTest() {
    }

    @Test
    public void testGetIncludedFailureEnrichers() {
        Configuration conf = new Configuration();
        conf.setString(JobManagerOptions.FAILURE_ENRICHERS_LIST, "");
        Set result = FailureEnricherUtils.getIncludedFailureEnrichers((Configuration)conf);
        Assertions.assertThat((Collection)result).hasSize(0);
        conf.setString(JobManagerOptions.FAILURE_ENRICHERS_LIST, "enricher1");
        result = FailureEnricherUtils.getIncludedFailureEnrichers((Configuration)conf);
        Assertions.assertThat((Collection)result).hasSize(1);
        Assertions.assertThat((Collection)result).contains((Object[])new String[]{"enricher1"});
        conf.setString(JobManagerOptions.FAILURE_ENRICHERS_LIST, "enricher1, enricher2, enricher3");
        result = FailureEnricherUtils.getIncludedFailureEnrichers((Configuration)conf);
        Assertions.assertThat((Collection)result).hasSize(3);
        Assertions.assertThat((Collection)result).contains((Object[])new String[]{"enricher1", "enricher2", "enricher3"});
        conf.setString(JobManagerOptions.FAILURE_ENRICHERS_LIST, "enricher1. enricher2. enricher3");
        result = FailureEnricherUtils.getIncludedFailureEnrichers((Configuration)conf);
        Assertions.assertThat((Collection)result).hasSize(1);
        Assertions.assertThat((Collection)result).contains((Object[])new String[]{"enricher1. enricher2. enricher3"});
        conf.setString(JobManagerOptions.FAILURE_ENRICHERS_LIST, "enricher1, ,enricher2,   enricher3");
        result = FailureEnricherUtils.getIncludedFailureEnrichers((Configuration)conf);
        Assertions.assertThat((Collection)result).hasSize(3);
        Assertions.assertThat((Collection)result).contains((Object[])new String[]{"enricher1", "enricher2", "enricher3"});
    }

    @Test
    public void testGetFailureEnrichers() {
        Configuration configuration = new Configuration();
        Collection emptyEnrichers = FailureEnricherUtils.getFailureEnrichers((Configuration)configuration, (PluginManager)FailureEnricherUtilsTest.createPluginManager());
        Assertions.assertThat((Collection)emptyEnrichers).hasSize(0);
        configuration.set(JobManagerOptions.FAILURE_ENRICHERS_LIST, (Object)FailureEnricherUtilsTest.class.getName());
        Collection invalidEnrichers = FailureEnricherUtils.getFailureEnrichers((Configuration)configuration, (PluginManager)FailureEnricherUtilsTest.createPluginManager());
        Assertions.assertThat((Collection)invalidEnrichers).hasSize(0);
        configuration.set(JobManagerOptions.FAILURE_ENRICHERS_LIST, (Object)TestEnricher.class.getName());
        Collection enrichers = FailureEnricherUtils.getFailureEnrichers((Configuration)configuration, (PluginManager)FailureEnricherUtilsTest.createPluginManager());
        Assertions.assertThat((Collection)enrichers).hasSize(1);
        Assertions.assertThat(enrichers.iterator().next()).isInstanceOf(TestEnricher.class);
    }

    @Test
    public void testGetValidatedEnrichers() {
        final TestEnricher firstEnricher = new TestEnricher("key1");
        final TestEnricher secondEnricher = new TestEnricher("key2");
        HashSet<FailureEnricher> enrichers = new HashSet<FailureEnricher>(){
            {
                this.add(firstEnricher);
                this.add(secondEnricher);
            }
        };
        Collection validatedEnrichers = FailureEnricherUtils.filterInvalidEnrichers((Set)enrichers);
        Assertions.assertThat((Collection)validatedEnrichers).hasSize(2);
        Assertions.assertThat((Collection)validatedEnrichers).contains((Object[])new FailureEnricher[]{firstEnricher, secondEnricher});
    }

    @Test
    public void testValidatedEnrichersWithInvalidEntries() {
        final TestEnricher validEnricher = new TestEnricher("validKey");
        final AnotherTestEnricher firstOverlapEnricher = new AnotherTestEnricher("key1", "key2");
        final AndAnotherTestEnricher secondOverlapEnricher = new AndAnotherTestEnricher("key2", "key3");
        HashSet<FailureEnricher> enrichers = new HashSet<FailureEnricher>(){
            {
                this.add(validEnricher);
                this.add(firstOverlapEnricher);
                this.add(secondOverlapEnricher);
            }
        };
        Collection validatedEnrichers = FailureEnricherUtils.filterInvalidEnrichers((Set)enrichers);
        Assertions.assertThat((Collection)validatedEnrichers).hasSize(1);
    }

    @Test
    public void testLabelFutureWithValidEnricher() {
        RuntimeException cause = new RuntimeException("test exception");
        HashSet<TestEnricher> failureEnrichers = new HashSet<TestEnricher>();
        TestEnricher validEnricher = new TestEnricher("enricherKey");
        failureEnrichers.add(validEnricher);
        CompletableFuture result = FailureEnricherUtils.labelFailure((Throwable)cause, null, (Executor)ComponentMainThreadExecutorServiceAdapter.forMainThread(), failureEnrichers);
        FlinkAssertions.assertThatFuture((CompletableFuture)result).eventuallySucceeds().satisfies(new ThrowingConsumer[]{labels -> {
            Assertions.assertThat((Map)labels).hasSize(1);
            Assertions.assertThat((Map)labels).containsKey((Object)"enricherKey");
            Assertions.assertThat((Map)labels).containsValue((Object)"enricherKeyValue");
        }});
    }

    @Test
    public void testLabelFailureWithInvalidEnricher() {
        RuntimeException cause = new RuntimeException("test exception");
        String invalidEnricherKey = "invalidKey";
        HashSet<TestEnricher> failureEnrichers = new HashSet<TestEnricher>();
        TestEnricher invalidEnricher = new TestEnricher(Collections.singletonMap("invalidKey", "enricherValue"), "enricherKey");
        failureEnrichers.add(invalidEnricher);
        CompletableFuture result = FailureEnricherUtils.labelFailure((Throwable)cause, null, (Executor)ComponentMainThreadExecutorServiceAdapter.forMainThread(), failureEnrichers);
        FlinkAssertions.assertThatFuture((CompletableFuture)result).eventuallySucceeds().satisfies(new ThrowingConsumer[]{labels -> labels.isEmpty()});
    }

    @Test
    public void testLabelFailureWithValidAndThrowingEnricher() {
        RuntimeException cause = new RuntimeException("test exception");
        final TestEnricher validEnricher = new TestEnricher("enricherKey");
        final ThrowingEnricher throwingEnricher = new ThrowingEnricher("throwingKey");
        HashSet<FailureEnricher> enrichers = new HashSet<FailureEnricher>(){
            {
                this.add(validEnricher);
                this.add(throwingEnricher);
            }
        };
        CompletableFuture result = FailureEnricherUtils.labelFailure((Throwable)cause, null, (Executor)ComponentMainThreadExecutorServiceAdapter.forMainThread(), (Collection)enrichers);
        FlinkAssertions.assertThatFuture((CompletableFuture)result).eventuallySucceeds().satisfies(new ThrowingConsumer[]{labels -> {
            Assertions.assertThat((Map)labels).hasSize(1);
            Assertions.assertThat((Map)labels).containsKey((Object)"enricherKey");
            Assertions.assertThat((Map)labels).containsValue((Object)"enricherKeyValue");
        }});
    }

    @Test
    public void testLabelFailureMergeException() {
        RuntimeException cause = new RuntimeException("test failure");
        final TestEnricher firstEnricher = new TestEnricher("key1", "key2");
        final TestEnricher secondEnricher = new TestEnricher("key2", "key3");
        HashSet<FailureEnricher> enrichers = new HashSet<FailureEnricher>(){
            {
                this.add(firstEnricher);
                this.add(secondEnricher);
            }
        };
        CompletableFuture result = FailureEnricherUtils.labelFailure((Throwable)cause, null, (Executor)ComponentMainThreadExecutorServiceAdapter.forMainThread(), (Collection)enrichers);
        try {
            result.get();
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).hasMessageContaining(String.format("Trying to merge a label with a duplicate key %s. This is a bug that should be reported, because Flink shouldn't allow registering enrichers with the same output.", "key2"));
        }
    }

    private static PluginManager createPluginManager() {
        HashMap<Class<FailureEnricherFactory>, ResettableIterator> plugins = new HashMap<Class<FailureEnricherFactory>, ResettableIterator>();
        plugins.put(FailureEnricherFactory.class, IteratorUtils.singletonIterator((Object)new TestFailureEnricherFactory()));
        return new TestingPluginManager(plugins);
    }

    private static class TestEnricher
    implements FailureEnricher {
        private final Set<String> outputKeys;
        private final Map<String, String> outputMap;

        TestEnricher(String ... outputKeys) {
            this.outputKeys = Arrays.stream(outputKeys).collect(Collectors.toSet());
            this.outputMap = new HashMap<String, String>();
            this.outputKeys.forEach(key -> this.outputMap.put((String)key, key + "Value"));
        }

        TestEnricher(Map<String, String> outputValues, String ... outputKeys) {
            this.outputKeys = Arrays.stream(outputKeys).collect(Collectors.toSet());
            this.outputMap = outputValues;
        }

        public Set<String> getOutputKeys() {
            return this.outputKeys;
        }

        public CompletableFuture<Map<String, String>> processFailure(Throwable cause, FailureEnricher.Context context) {
            return CompletableFuture.completedFuture(this.outputMap);
        }
    }

    private static class AnotherTestEnricher
    extends TestEnricher {
        AnotherTestEnricher(String ... outputKeys) {
            super(outputKeys);
        }
    }

    private static class AndAnotherTestEnricher
    extends TestEnricher {
        AndAnotherTestEnricher(String ... outputKeys) {
            super(outputKeys);
        }
    }

    private static class ThrowingEnricher
    extends TestEnricher {
        ThrowingEnricher(String ... outputKeys) {
            super(outputKeys);
        }

        @Override
        public CompletableFuture<Map<String, String>> processFailure(Throwable cause, FailureEnricher.Context context) {
            CompletableFuture<Map<String, String>> future = new CompletableFuture<Map<String, String>>();
            future.completeExceptionally(new RuntimeException("test failure"));
            return future;
        }
    }

    private static class TestFailureEnricherFactory
    implements FailureEnricherFactory {
        private TestFailureEnricherFactory() {
        }

        public FailureEnricher createFailureEnricher(Configuration conf) {
            return new TestEnricher(new String[0]);
        }
    }
}

