/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.checkpoint.JobManagerTaskRestore;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.deployment.InputGateDeploymentDescriptor;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.JobInformation;
import org.apache.flink.runtime.executiongraph.TaskInformation;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.operators.BatchTask;
import org.apache.flink.util.SerializedValue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TaskDeploymentDescriptorTest {
    private static final JobID jobID = new JobID();
    private static final JobVertexID vertexID = new JobVertexID();
    private static final ExecutionAttemptID execId = ExecutionGraphTestUtils.createExecutionAttemptId(vertexID);
    private static final AllocationID allocationId = new AllocationID();
    private static final String jobName = "job name";
    private static final String taskName = "task name";
    private static final int numberOfKeyGroups = 1;
    private static final int currentNumberOfSubtasks = 1;
    private static final Configuration jobConfiguration = new Configuration();
    private static final Configuration taskConfiguration = new Configuration();
    private static final Class<? extends AbstractInvokable> invokableClass = BatchTask.class;
    private static final List<ResultPartitionDeploymentDescriptor> producedResults = new ArrayList<ResultPartitionDeploymentDescriptor>(0);
    private static final List<InputGateDeploymentDescriptor> inputGates = new ArrayList<InputGateDeploymentDescriptor>(0);
    private static final List<PermanentBlobKey> requiredJars = new ArrayList<PermanentBlobKey>(0);
    private static final List<URL> requiredClasspaths = new ArrayList<URL>(0);
    private static final TaskStateSnapshot taskStateHandles = new TaskStateSnapshot();
    private static final JobManagerTaskRestore taskRestore = new JobManagerTaskRestore(1L, taskStateHandles);
    private final SerializedValue<ExecutionConfig> executionConfig = new SerializedValue((Object)new ExecutionConfig());
    private final SerializedValue<JobInformation> serializedJobInformation = new SerializedValue((Object)new JobInformation(jobID, "job name", this.executionConfig, jobConfiguration, requiredJars, requiredClasspaths));
    private final SerializedValue<TaskInformation> serializedJobVertexInformation = new SerializedValue((Object)new TaskInformation(vertexID, "task name", 1, 1, invokableClass.getName(), taskConfiguration));

    TaskDeploymentDescriptorTest() throws IOException {
    }

    @Test
    void testSerialization() throws Exception {
        TaskDeploymentDescriptor orig = this.createTaskDeploymentDescriptor((TaskDeploymentDescriptor.MaybeOffloaded<JobInformation>)new TaskDeploymentDescriptor.NonOffloaded(this.serializedJobInformation), (TaskDeploymentDescriptor.MaybeOffloaded<TaskInformation>)new TaskDeploymentDescriptor.NonOffloaded(this.serializedJobVertexInformation));
        TaskDeploymentDescriptor copy = (TaskDeploymentDescriptor)CommonTestUtils.createCopySerializable((Serializable)orig);
        Assertions.assertThat((Object)orig.getSerializedJobInformation()).isNotSameAs((Object)copy.getSerializedJobInformation());
        Assertions.assertThat((Object)orig.getSerializedTaskInformation()).isNotSameAs((Object)copy.getSerializedTaskInformation());
        Assertions.assertThat((Object)orig.getExecutionAttemptId()).isNotSameAs((Object)copy.getExecutionAttemptId());
        Assertions.assertThat((Object)orig.getTaskRestore()).isNotSameAs((Object)copy.getTaskRestore());
        Assertions.assertThat((List)orig.getProducedPartitions()).isNotSameAs((Object)copy.getProducedPartitions());
        Assertions.assertThat((List)orig.getInputGates()).isNotSameAs((Object)copy.getInputGates());
        Assertions.assertThat((Object)orig.getSerializedJobInformation()).isEqualTo((Object)copy.getSerializedJobInformation());
        Assertions.assertThat((Object)orig.getSerializedTaskInformation()).isEqualTo((Object)copy.getSerializedTaskInformation());
        Assertions.assertThat((Object)orig.getExecutionAttemptId()).isEqualTo((Object)copy.getExecutionAttemptId());
        Assertions.assertThat((Comparable)orig.getAllocationId()).isEqualTo((Object)copy.getAllocationId());
        Assertions.assertThat((int)orig.getSubtaskIndex()).isEqualTo(copy.getSubtaskIndex());
        Assertions.assertThat((int)orig.getAttemptNumber()).isEqualTo(copy.getAttemptNumber());
        Assertions.assertThat((long)orig.getTaskRestore().getRestoreCheckpointId()).isEqualTo(copy.getTaskRestore().getRestoreCheckpointId());
        Assertions.assertThat((Object)orig.getTaskRestore().getTaskStateSnapshot()).isEqualTo((Object)copy.getTaskRestore().getTaskStateSnapshot());
        Assertions.assertThat((List)orig.getProducedPartitions()).isEqualTo((Object)copy.getProducedPartitions());
        Assertions.assertThat((List)orig.getInputGates()).isEqualTo((Object)copy.getInputGates());
    }

    @Test
    void testOffLoadedAndNonOffLoadedPayload() {
        TaskDeploymentDescriptor taskDeploymentDescriptor = this.createTaskDeploymentDescriptor((TaskDeploymentDescriptor.MaybeOffloaded<JobInformation>)new TaskDeploymentDescriptor.NonOffloaded(this.serializedJobInformation), (TaskDeploymentDescriptor.MaybeOffloaded<TaskInformation>)new TaskDeploymentDescriptor.Offloaded(new PermanentBlobKey()));
        SerializedValue actualSerializedJobInformation = taskDeploymentDescriptor.getSerializedJobInformation();
        Assertions.assertThat((Object)actualSerializedJobInformation).isSameAs(this.serializedJobInformation);
        Assertions.assertThatThrownBy(() -> ((TaskDeploymentDescriptor)taskDeploymentDescriptor).getSerializedTaskInformation()).isInstanceOf(IllegalStateException.class);
    }

    @Nonnull
    private TaskDeploymentDescriptor createTaskDeploymentDescriptor(TaskDeploymentDescriptor.MaybeOffloaded<JobInformation> jobInformation, TaskDeploymentDescriptor.MaybeOffloaded<TaskInformation> taskInformation) {
        return new TaskDeploymentDescriptor(jobID, jobInformation, taskInformation, execId, allocationId, taskRestore, producedResults, inputGates);
    }
}

