/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateSerializer;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateSerializerImpl;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequest;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequestDispatcher;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequestDispatcherImpl;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequestExecutor;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.storage.JobManagerCheckpointStorage;

class SyncChannelStateWriteRequestExecutor
implements ChannelStateWriteRequestExecutor {
    private final ChannelStateWriteRequestDispatcher requestProcessor;
    private final Deque<ChannelStateWriteRequest> deque = new ArrayDeque<ChannelStateWriteRequest>();
    private Exception thrown;

    SyncChannelStateWriteRequestExecutor(JobID jobID) {
        this.requestProcessor = new ChannelStateWriteRequestDispatcherImpl((CheckpointStorage)new JobManagerCheckpointStorage(), jobID, (ChannelStateSerializer)new ChannelStateSerializerImpl());
    }

    public void submit(ChannelStateWriteRequest e) throws Exception {
        this.deque.offer(e);
        if (this.thrown != null) {
            throw this.thrown;
        }
    }

    public void submitPriority(ChannelStateWriteRequest e) throws Exception {
        this.deque.offerFirst(e);
        if (this.thrown != null) {
            throw this.thrown;
        }
    }

    public void start() throws IllegalStateException {
    }

    public void registerSubtask(JobVertexID jobVertexID, int subtaskIndex) {
        this.deque.add(ChannelStateWriteRequest.registerSubtask((JobVertexID)jobVertexID, (int)subtaskIndex));
    }

    public void releaseSubtask(JobVertexID jobVertexID, int subtaskIndex) {
        this.deque.add(ChannelStateWriteRequest.releaseSubtask((JobVertexID)jobVertexID, (int)subtaskIndex));
    }

    void processAllRequests() throws Exception {
        while (!this.deque.isEmpty()) {
            this.requestProcessor.dispatch(this.deque.poll());
        }
    }

    public void setThrown(Exception thrown) {
        this.thrown = thrown;
    }
}

