/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.Random;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.checkpoint.SavepointType;
import org.apache.flink.runtime.checkpoint.SnapshotType;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.junit.Assert;
import org.junit.Test;

public class CheckpointOptionsTest {
    @Test
    public void testDefaultCheckpoint() throws Exception {
        CheckpointOptions options = CheckpointOptions.forCheckpointWithDefaultLocation();
        Assert.assertEquals((Object)CheckpointType.CHECKPOINT, (Object)options.getCheckpointType());
        Assert.assertTrue((boolean)options.getTargetLocation().isDefaultReference());
        CheckpointOptions copy = (CheckpointOptions)CommonTestUtils.createCopySerializable((Serializable)options);
        Assert.assertEquals((Object)CheckpointType.CHECKPOINT, (Object)copy.getCheckpointType());
        Assert.assertTrue((boolean)copy.getTargetLocation().isDefaultReference());
    }

    @Test
    public void testSavepoint() throws Exception {
        Random rnd = new Random();
        byte[] locationBytes = new byte[rnd.nextInt(41) + 1];
        rnd.nextBytes(locationBytes);
        SnapshotType[] snapshotTypes = new SnapshotType[]{CheckpointType.CHECKPOINT, CheckpointType.FULL_CHECKPOINT, SavepointType.savepoint((SavepointFormatType)SavepointFormatType.CANONICAL), SavepointType.suspend((SavepointFormatType)SavepointFormatType.CANONICAL), SavepointType.terminate((SavepointFormatType)SavepointFormatType.CANONICAL)};
        CheckpointOptions options = new CheckpointOptions(snapshotTypes[rnd.nextInt(snapshotTypes.length)], new CheckpointStorageLocationReference(locationBytes));
        CheckpointOptions copy = (CheckpointOptions)CommonTestUtils.createCopySerializable((Serializable)options);
        Assert.assertEquals((Object)options.getCheckpointType(), (Object)copy.getCheckpointType());
        Assert.assertArrayEquals((byte[])locationBytes, (byte[])copy.getTargetLocation().getReferenceBytes());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSavepointNeedsAlignment() {
        new CheckpointOptions((SnapshotType)SavepointType.savepoint((SavepointFormatType)SavepointFormatType.CANONICAL), CheckpointStorageLocationReference.getDefault(), CheckpointOptions.AlignmentType.UNALIGNED, 0L);
    }

    @Test
    public void testCheckpointNeedsAlignment() {
        CheckpointStorageLocationReference location = CheckpointStorageLocationReference.getDefault();
        Assert.assertFalse((boolean)new CheckpointOptions((SnapshotType)CheckpointType.CHECKPOINT, location, CheckpointOptions.AlignmentType.UNALIGNED, Long.MAX_VALUE).needsAlignment());
        Assert.assertTrue((boolean)new CheckpointOptions((SnapshotType)CheckpointType.CHECKPOINT, location, CheckpointOptions.AlignmentType.ALIGNED, Long.MAX_VALUE).needsAlignment());
        Assert.assertTrue((boolean)new CheckpointOptions((SnapshotType)CheckpointType.CHECKPOINT, location, CheckpointOptions.AlignmentType.FORCED_ALIGNED, Long.MAX_VALUE).needsAlignment());
        Assert.assertFalse((boolean)new CheckpointOptions((SnapshotType)CheckpointType.CHECKPOINT, location, CheckpointOptions.AlignmentType.AT_LEAST_ONCE, Long.MAX_VALUE).needsAlignment());
    }

    @Test
    public void testCheckpointIsTimeoutable() {
        CheckpointStorageLocationReference location = CheckpointStorageLocationReference.getDefault();
        this.assertTimeoutable(CheckpointOptions.alignedWithTimeout((SnapshotType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)location, (long)10L), false, true, 10L);
        this.assertTimeoutable(CheckpointOptions.unaligned((SnapshotType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)location), true, false, Long.MAX_VALUE);
        this.assertTimeoutable(CheckpointOptions.alignedWithTimeout((SnapshotType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)location, (long)10L).withUnalignedUnsupported(), false, false, 10L);
        this.assertTimeoutable(CheckpointOptions.unaligned((SnapshotType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)location).withUnalignedUnsupported(), false, false, Long.MAX_VALUE);
    }

    @Test
    public void testForceAlignmentIsReversable() {
        CheckpointStorageLocationReference location = CheckpointStorageLocationReference.getDefault();
        this.assertReversable(CheckpointOptions.alignedWithTimeout((SnapshotType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)location, (long)10L), true);
        this.assertReversable(CheckpointOptions.unaligned((SnapshotType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)location), true);
        this.assertReversable(CheckpointOptions.alignedNoTimeout((SnapshotType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)location), false);
        this.assertReversable(CheckpointOptions.alignedNoTimeout((SnapshotType)SavepointType.savepoint((SavepointFormatType)SavepointFormatType.CANONICAL), (CheckpointStorageLocationReference)location), false);
        this.assertReversable(CheckpointOptions.notExactlyOnce((SnapshotType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)location), false);
        this.assertReversable(CheckpointOptions.notExactlyOnce((SnapshotType)SavepointType.savepoint((SavepointFormatType)SavepointFormatType.CANONICAL), (CheckpointStorageLocationReference)location), false);
    }

    private void assertReversable(CheckpointOptions options, boolean forceHasEffect) {
        Assert.assertEquals((String)"all non-forced options support unaligned mode", (Object)options, (Object)options.withUnalignedSupported());
        CheckpointOptions unalignedUnsupported = options.withUnalignedUnsupported();
        if (forceHasEffect) {
            Assert.assertNotEquals((String)"expected changes in the options", (Object)options, (Object)unalignedUnsupported);
        } else {
            Assert.assertEquals((String)"not expected changes to the options", (Object)options, (Object)unalignedUnsupported);
        }
        Assert.assertEquals((String)"expected fully reversable options", (Object)options, (Object)unalignedUnsupported.withUnalignedSupported());
    }

    private void assertTimeoutable(CheckpointOptions options, boolean isUnaligned, boolean isTimeoutable, long timeout) {
        Assert.assertTrue((String)"exactly once", (boolean)options.isExactlyOnceMode());
        Assert.assertEquals((String)"need alignment", (Object)(!isUnaligned ? 1 : 0), (Object)options.needsAlignment());
        Assert.assertEquals((String)"unaligned", (Object)isUnaligned, (Object)options.isUnalignedCheckpoint());
        Assert.assertEquals((String)"timeoutable", (Object)isTimeoutable, (Object)options.isTimeoutable());
        Assert.assertEquals((String)"timeout", (long)timeout, (long)options.getAlignedCheckpointTimeout());
    }
}

