/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobServerGetTest;
import org.apache.flink.runtime.blob.BlobServerPutTest;
import org.apache.flink.runtime.blob.BlobService;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.util.TestLogger;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BlobServerCorruptionTest
extends TestLogger {
    @ClassRule
    public static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();

    @Test
    public void testGetFailsFromCorruptFile() throws IOException {
        Configuration config = new Configuration();
        config.setString(HighAvailabilityOptions.HA_MODE, "ZOOKEEPER");
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, TEMPORARY_FOLDER.newFolder().getAbsolutePath());
        config.setString(HighAvailabilityOptions.HA_STORAGE_PATH, TEMPORARY_FOLDER.newFolder().getPath());
        BlobStoreService blobStoreService = null;
        try {
            blobStoreService = BlobUtils.createBlobStoreFromConfig((Configuration)config);
            BlobServerCorruptionTest.testGetFailsFromCorruptFile(config, (BlobStore)blobStoreService, TEMPORARY_FOLDER.newFolder());
        }
        finally {
            if (blobStoreService != null) {
                blobStoreService.closeAndCleanupAllData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testGetFailsFromCorruptFile(Configuration config, BlobStore blobStore, File blobStorage) throws IOException {
        Random rnd = new Random();
        JobID jobId = new JobID();
        try (BlobServer server = new BlobServer(config, blobStorage, blobStore);){
            server.start();
            byte[] data = new byte[2000000];
            rnd.nextBytes(data);
            BlobKey key = BlobServerPutTest.put((BlobService)server, jobId, data, BlobKey.BlobType.PERMANENT_BLOB);
            Assert.assertNotNull((Object)key);
            File blobFile = server.getStorageLocation(jobId, key);
            Assert.assertTrue((boolean)blobFile.delete());
            byte[] data2 = Arrays.copyOf(data, data.length);
            data2[0] = (byte)(data2[0] ^ 1);
            File tmpFile = Files.createTempFile("blob", ".jar", new FileAttribute[0]).toFile();
            try {
                FileUtils.writeByteArrayToFile((File)tmpFile, (byte[])data2);
                blobStore.put(tmpFile, jobId, key);
            }
            finally {
                tmpFile.delete();
            }
            Assertions.assertThatThrownBy(() -> BlobServerGetTest.get((BlobService)server, jobId, key)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(IOException.class, (String)"data corruption")});
        }
    }
}

