/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.coordination.util;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.runtime.operators.coordination.util.IncompleteFuturesTracker;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class IncompleteFuturesTrackerTest {
    @Test
    public void testFutureTracked() {
        IncompleteFuturesTracker tracker = new IncompleteFuturesTracker();
        CompletableFuture future = new CompletableFuture();
        tracker.trackFutureWhileIncomplete(future);
        Assertions.assertThat((Collection)tracker.getCurrentIncompleteAndReset()).containsExactly((Object[])new CompletableFuture[]{future});
    }

    @Test
    public void testFutureRemovedAfterCompletion() {
        IncompleteFuturesTracker tracker = new IncompleteFuturesTracker();
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        tracker.trackFutureWhileIncomplete(future);
        future.complete(null);
        Assertions.assertThat((Collection)tracker.getCurrentIncompleteAndReset()).doesNotContain((Object[])new CompletableFuture[]{future});
    }

    @Test
    public void testFutureNotAddedIfAlreadyCompleted() {
        IncompleteFuturesTracker tracker = new IncompleteFuturesTracker();
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        future.complete(null);
        tracker.trackFutureWhileIncomplete(future);
        Assertions.assertThat((Collection)tracker.getCurrentIncompleteAndReset()).doesNotContain((Object[])new CompletableFuture[]{future});
    }

    @Test
    public void testFailFutures() throws Exception {
        IncompleteFuturesTracker tracker = new IncompleteFuturesTracker();
        CompletableFuture future = new CompletableFuture();
        tracker.trackFutureWhileIncomplete(future);
        Exception expectedException = new Exception();
        tracker.failAllFutures((Throwable)expectedException);
        Assertions.assertThat(future).isCompletedExceptionally();
        try {
            future.get();
            Assertions.fail(null);
        }
        catch (ExecutionException e) {
            Assertions.assertThat((Throwable)e.getCause()).isEqualTo((Object)expectedException);
        }
    }

    @Test
    public void testFailFuturesImmediately() throws Exception {
        IncompleteFuturesTracker tracker = new IncompleteFuturesTracker();
        CompletableFuture future = new CompletableFuture();
        Exception expectedException = new Exception();
        tracker.failAllFutures((Throwable)expectedException);
        tracker.trackFutureWhileIncomplete(future);
        Assertions.assertThat(future).isCompletedExceptionally();
        try {
            future.get();
            Assertions.fail(null);
        }
        catch (ExecutionException e) {
            Assertions.assertThat((Throwable)e.getCause()).isEqualTo((Object)expectedException);
        }
    }

    @Test
    public void testResetClearsTrackedFutures() {
        IncompleteFuturesTracker tracker = new IncompleteFuturesTracker();
        CompletableFuture future = new CompletableFuture();
        tracker.trackFutureWhileIncomplete(future);
        tracker.getCurrentIncompleteAndReset();
        Assertions.assertThat((Collection)tracker.getCurrentIncompleteAndReset()).isEmpty();
    }
}

