/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.flink.runtime.metrics.TimerGauge;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.ManualClock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TimerGaugeTest {
    private static final long SLEEP = 10L;

    @Test
    public void testBasicUsage() {
        ManualClock clock = new ManualClock(42000000L);
        TimerGauge gauge = new TimerGauge((Clock)clock, 5);
        gauge.update();
        Assert.assertThat((Object)gauge.getValue(), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)gauge.getMaxSingleMeasurement(), (Matcher)Matchers.is((Object)0L));
        Assert.assertEquals((long)gauge.getAccumulatedCount(), (long)0L);
        gauge.markStart();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        gauge.markEnd();
        gauge.update();
        Assert.assertThat((Object)gauge.getValue(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(2L)));
        Assert.assertThat((Object)gauge.getMaxSingleMeasurement(), (Matcher)Matchers.is((Object)10L));
        Assert.assertEquals((long)gauge.getAccumulatedCount(), (long)10L);
        gauge.markStart();
        clock.advanceTime(5L, TimeUnit.MILLISECONDS);
        gauge.markEnd();
        gauge.update();
        Assert.assertThat((Object)gauge.getMaxSingleMeasurement(), (Matcher)Matchers.is((Object)5L));
        Assert.assertEquals((long)gauge.getAccumulatedCount(), (long)15L);
    }

    @Test
    public void testUpdateWithoutMarkingEnd() {
        ManualClock clock = new ManualClock(42000000L);
        TimerGauge gauge = new TimerGauge((Clock)clock, 5);
        gauge.markStart();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        gauge.update();
        Assert.assertThat((Object)gauge.getValue(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(2L)));
        Assert.assertThat((Object)gauge.getMaxSingleMeasurement(), (Matcher)Matchers.is((Object)10L));
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        gauge.update();
        Assert.assertThat((Object)gauge.getValue(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(2L)));
        Assert.assertThat((Object)gauge.getMaxSingleMeasurement(), (Matcher)Matchers.is((Object)20L));
    }

    @Test
    public void testGetWithoutUpdate() {
        ManualClock clock = new ManualClock(42000000L);
        TimerGauge gauge = new TimerGauge((Clock)clock);
        gauge.markStart();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)gauge.getValue(), (Matcher)Matchers.is((Object)0L));
        gauge.markEnd();
        Assert.assertThat((Object)gauge.getValue(), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)gauge.getMaxSingleMeasurement(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void testLargerTimespan() {
        ManualClock clock = new ManualClock(42000000L);
        TimerGauge gauge = new TimerGauge((Clock)clock, 10);
        gauge.markStart();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        gauge.markEnd();
        gauge.update();
        Assert.assertThat((Object)gauge.getValue(), (Matcher)Matchers.is((Object)2L));
        Assert.assertThat((Object)gauge.getMaxSingleMeasurement(), (Matcher)Matchers.is((Object)10L));
        Assert.assertEquals((long)gauge.getAccumulatedCount(), (long)10L);
        gauge.update();
        Assert.assertThat((Object)gauge.getValue(), (Matcher)Matchers.is((Object)1L));
        Assert.assertThat((Object)gauge.getMaxSingleMeasurement(), (Matcher)Matchers.is((Object)0L));
        Assert.assertEquals((long)gauge.getAccumulatedCount(), (long)10L);
        gauge.markStart();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        gauge.markEnd();
        gauge.update();
        gauge.markStart();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        gauge.markEnd();
        gauge.update();
        Assert.assertThat((Object)gauge.getValue(), (Matcher)Matchers.is((Object)2L));
        gauge.markStart();
        clock.advanceTime(5L, TimeUnit.MILLISECONDS);
        gauge.markEnd();
        gauge.update();
        Assert.assertThat((Object)gauge.getMaxSingleMeasurement(), (Matcher)Matchers.is((Object)5L));
        Assert.assertEquals((long)gauge.getAccumulatedCount(), (long)35L);
    }
}

