/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.util.LeaderConnectionInfo;
import org.apache.flink.util.Preconditions;

public class TestingLeaderElectionService
implements LeaderElectionService {
    private LeaderContender contender = null;
    private boolean hasLeadership = false;
    private CompletableFuture<LeaderConnectionInfo> confirmationFuture = null;
    private CompletableFuture<Void> startFuture = new CompletableFuture();
    private UUID issuedLeaderSessionId = null;

    public synchronized CompletableFuture<LeaderConnectionInfo> getConfirmationFuture() {
        return this.confirmationFuture;
    }

    public synchronized void start(LeaderContender contender) {
        Preconditions.checkState((!this.getStartFuture().isDone() ? 1 : 0) != 0);
        this.contender = contender;
        if (this.hasLeadership) {
            contender.grantLeadership(this.issuedLeaderSessionId);
        }
        this.startFuture.complete(null);
    }

    public synchronized void stop() throws Exception {
        this.contender = null;
        this.hasLeadership = false;
        this.issuedLeaderSessionId = null;
        this.startFuture.cancel(false);
        this.startFuture = new CompletableFuture();
    }

    public synchronized void confirmLeadership(UUID leaderSessionID, String leaderAddress) {
        if (this.confirmationFuture != null) {
            this.confirmationFuture.complete(new LeaderConnectionInfo(leaderSessionID, leaderAddress));
        }
    }

    public synchronized boolean hasLeadership(@Nonnull UUID leaderSessionId) {
        return this.hasLeadership && leaderSessionId.equals(this.issuedLeaderSessionId);
    }

    public synchronized CompletableFuture<UUID> isLeader(UUID leaderSessionID) {
        if (this.confirmationFuture != null) {
            this.confirmationFuture.cancel(false);
        }
        this.confirmationFuture = new CompletableFuture();
        this.hasLeadership = true;
        this.issuedLeaderSessionId = leaderSessionID;
        if (this.contender != null) {
            this.contender.grantLeadership(leaderSessionID);
        }
        return this.confirmationFuture.thenApply(LeaderConnectionInfo::getLeaderSessionId);
    }

    public synchronized void notLeader() {
        this.hasLeadership = false;
        if (this.contender != null) {
            this.contender.revokeLeadership();
        }
    }

    public synchronized String getAddress() {
        if (this.confirmationFuture.isDone()) {
            return this.confirmationFuture.join().getAddress();
        }
        throw new IllegalStateException("TestingLeaderElectionService has not been started.");
    }

    public synchronized CompletableFuture<Void> getStartFuture() {
        return this.startFuture;
    }

    public synchronized boolean isStopped() {
        return this.contender == null;
    }
}

