/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.AllocatedSlotReport;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolFactory;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolService;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolServiceFactory;
import org.apache.flink.runtime.jobmaster.slotpool.TestingSlotPoolService;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.taskexecutor.slot.SlotOffer;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.function.TriConsumer;
import org.apache.flink.util.function.TriFunction;

public class TestingSlotPoolServiceBuilder
implements SlotPoolServiceFactory {
    private TriConsumer<? super JobMasterId, ? super String, ? super ComponentMainThreadExecutor> startConsumer = (ignoredA, ignoredB, ignoredC) -> {};
    private Runnable closeRunnable = () -> {};
    private TriFunction<? super TaskManagerLocation, ? super TaskManagerGateway, ? super Collection<SlotOffer>, ? extends Collection<SlotOffer>> offerSlotsFunction = (ignoredA, ignoredB, ignoredC) -> Collections.emptyList();
    private TriFunction<? super ResourceID, ? super AllocationID, ? super Exception, Optional<ResourceID>> failAllocationFunction = (ignoredA, ignoredB, ignoredC) -> Optional.empty();
    private Function<? super ResourceID, Boolean> registerTaskManagerFunction = ignored -> false;
    private BiFunction<? super ResourceID, ? super Exception, Boolean> releaseTaskManagerFunction = (ignoredA, ignoredB) -> false;
    private Consumer<? super ResourceManagerGateway> connectToResourceManagerConsumer = ignored -> {};
    private Runnable disconnectResourceManagerRunnable = () -> {};
    private BiFunction<? super JobID, ? super ResourceID, ? extends AllocatedSlotReport> createAllocatedSlotReportFunction = (jobId, ignored) -> new AllocatedSlotReport(jobId, Collections.emptyList());

    @Nonnull
    public SlotPoolService createSlotPoolService(@Nonnull JobID jobId, DeclarativeSlotPoolFactory declarativeSlotPoolFactory) {
        return new TestingSlotPoolService(jobId, this.startConsumer, this.closeRunnable, this.offerSlotsFunction, this.failAllocationFunction, this.registerTaskManagerFunction, this.releaseTaskManagerFunction, this.connectToResourceManagerConsumer, this.disconnectResourceManagerRunnable, this.createAllocatedSlotReportFunction);
    }

    public TestingSlotPoolServiceBuilder setConnectToResourceManagerConsumer(Consumer<? super ResourceManagerGateway> connectToResourceManagerConsumer) {
        this.connectToResourceManagerConsumer = connectToResourceManagerConsumer;
        return this;
    }

    public static TestingSlotPoolServiceBuilder newBuilder() {
        return new TestingSlotPoolServiceBuilder();
    }
}

