/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.flink.runtime.jobmaster.JobManagerRunnerResult;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.jobmaster.JobMasterServiceProcess;
import org.apache.flink.runtime.jobmaster.utils.TestingJobMasterGatewayBuilder;

public class TestingJobMasterServiceProcess
implements JobMasterServiceProcess {
    private final Supplier<CompletableFuture<Void>> closeAsyncSupplier;
    private final Supplier<Boolean> isInitializedAndRunningSupplier;
    private final Supplier<CompletableFuture<JobMasterGateway>> getJobMasterGatewayFutureSupplier;
    private final Supplier<CompletableFuture<JobManagerRunnerResult>> getResultFutureSupplier;
    private final Supplier<CompletableFuture<String>> getLeaderAddressFutureSupplier;

    private TestingJobMasterServiceProcess(Supplier<CompletableFuture<Void>> closeAsyncSupplier, Supplier<Boolean> isInitializedAndRunningSupplier, Supplier<CompletableFuture<JobMasterGateway>> getJobMasterGatewayFutureSupplier, Supplier<CompletableFuture<JobManagerRunnerResult>> getResultFutureSupplier, Supplier<CompletableFuture<String>> getLeaderAddressFutureSupplier) {
        this.closeAsyncSupplier = closeAsyncSupplier;
        this.isInitializedAndRunningSupplier = isInitializedAndRunningSupplier;
        this.getJobMasterGatewayFutureSupplier = getJobMasterGatewayFutureSupplier;
        this.getResultFutureSupplier = getResultFutureSupplier;
        this.getLeaderAddressFutureSupplier = getLeaderAddressFutureSupplier;
    }

    public CompletableFuture<Void> closeAsync() {
        return this.closeAsyncSupplier.get();
    }

    public boolean isInitializedAndRunning() {
        return this.isInitializedAndRunningSupplier.get();
    }

    public CompletableFuture<JobMasterGateway> getJobMasterGatewayFuture() {
        return this.getJobMasterGatewayFutureSupplier.get();
    }

    public CompletableFuture<JobManagerRunnerResult> getResultFuture() {
        return this.getResultFutureSupplier.get();
    }

    public CompletableFuture<String> getLeaderAddressFuture() {
        return this.getLeaderAddressFutureSupplier.get();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Supplier<CompletableFuture<Void>> closeAsyncSupplier = Builder.unsupportedOperation();
        private Supplier<Boolean> isInitializedAndRunningSupplier = Builder.unsupportedOperation();
        private Supplier<CompletableFuture<JobMasterGateway>> getJobMasterGatewayFutureSupplier = () -> CompletableFuture.completedFuture(new TestingJobMasterGatewayBuilder().build());
        private Supplier<CompletableFuture<JobManagerRunnerResult>> getResultFutureSupplier = CompletableFuture::new;
        private Supplier<CompletableFuture<String>> getLeaderAddressFutureSupplier = () -> CompletableFuture.completedFuture("leader address");

        private static <T> Supplier<T> unsupportedOperation() {
            return () -> {
                throw new UnsupportedOperationException();
            };
        }

        public Builder setCloseAsyncSupplier(Supplier<CompletableFuture<Void>> closeAsyncSupplier) {
            this.closeAsyncSupplier = closeAsyncSupplier;
            return this;
        }

        public Builder setIsInitializedAndRunningSupplier(Supplier<Boolean> isInitializedAndRunningSupplier) {
            this.isInitializedAndRunningSupplier = isInitializedAndRunningSupplier;
            return this;
        }

        public Builder setGetJobMasterGatewayFutureSupplier(Supplier<CompletableFuture<JobMasterGateway>> getJobMasterGatewayFutureSupplier) {
            this.getJobMasterGatewayFutureSupplier = getJobMasterGatewayFutureSupplier;
            return this;
        }

        public Builder setGetResultFutureSupplier(Supplier<CompletableFuture<JobManagerRunnerResult>> getResultFutureSupplier) {
            this.getResultFutureSupplier = getResultFutureSupplier;
            return this;
        }

        public Builder setGetLeaderAddressFutureSupplier(Supplier<CompletableFuture<String>> getLeaderAddressFutureSupplier) {
            this.getLeaderAddressFutureSupplier = getLeaderAddressFutureSupplier;
            return this;
        }

        public TestingJobMasterServiceProcess build() {
            return new TestingJobMasterServiceProcess(this.closeAsyncSupplier, this.isInitializedAndRunningSupplier, this.getJobMasterGatewayFutureSupplier, this.getResultFutureSupplier, this.getLeaderAddressFutureSupplier);
        }
    }
}

