/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.deployment.InputGateDeploymentDescriptor;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.PartitionInfo;
import org.apache.flink.runtime.io.network.NettyShuffleEnvironmentBuilder;
import org.apache.flink.runtime.io.network.partition.PartitionProducerStateProvider;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.TaskExecutorPartitionInfo;
import org.apache.flink.runtime.io.network.partition.TaskExecutorPartitionTrackerImpl;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleEnvironment;
import org.apache.flink.runtime.shuffle.ShuffleIOOwnerContext;
import org.apache.flink.runtime.taskexecutor.partition.ClusterPartitionReport;
import org.apache.flink.shaded.guava30.com.google.common.collect.Iterables;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class TaskExecutorPartitionTrackerImplTest
extends TestLogger {
    @Test
    public void createClusterPartitionReport() {
        TaskExecutorPartitionTrackerImpl partitionTracker = new TaskExecutorPartitionTrackerImpl((ShuffleEnvironment)new NettyShuffleEnvironmentBuilder().build());
        MatcherAssert.assertThat((Object)partitionTracker.createClusterPartitionReport().getEntries(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        IntermediateDataSetID dataSetId = new IntermediateDataSetID();
        JobID jobId = new JobID();
        ResultPartitionID clusterPartitionId = new ResultPartitionID();
        ResultPartitionID jobPartitionId = new ResultPartitionID();
        boolean numberOfPartitions = true;
        partitionTracker.startTrackingPartition(jobId, new TaskExecutorPartitionInfo((ShuffleDescriptor)new TestingShuffleDescriptor(clusterPartitionId), dataSetId, 1));
        partitionTracker.startTrackingPartition(jobId, new TaskExecutorPartitionInfo((ShuffleDescriptor)new TestingShuffleDescriptor(jobPartitionId), dataSetId, 2));
        partitionTracker.promoteJobPartitions(Collections.singleton(clusterPartitionId));
        ClusterPartitionReport clusterPartitionReport = partitionTracker.createClusterPartitionReport();
        ClusterPartitionReport.ClusterPartitionReportEntry reportEntry = (ClusterPartitionReport.ClusterPartitionReportEntry)Iterables.getOnlyElement((Iterable)clusterPartitionReport.getEntries());
        MatcherAssert.assertThat((Object)reportEntry.getDataSetId(), (Matcher)Matchers.is((Object)dataSetId));
        MatcherAssert.assertThat((Object)reportEntry.getNumTotalPartitions(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)reportEntry.getHostedPartitions(), (Matcher)Matchers.hasItems((Object[])new ResultPartitionID[]{clusterPartitionId}));
    }

    @Test
    public void testStopTrackingAndReleaseJobPartitions() throws Exception {
        TestingShuffleEnvironment testingShuffleEnvironment = new TestingShuffleEnvironment();
        CompletableFuture shuffleReleaseFuture = new CompletableFuture();
        testingShuffleEnvironment.releasePartitionsLocallyFuture = shuffleReleaseFuture;
        ResultPartitionID resultPartitionId1 = new ResultPartitionID();
        ResultPartitionID resultPartitionId2 = new ResultPartitionID();
        TaskExecutorPartitionTrackerImpl partitionTracker = new TaskExecutorPartitionTrackerImpl((ShuffleEnvironment)testingShuffleEnvironment);
        partitionTracker.startTrackingPartition(new JobID(), new TaskExecutorPartitionInfo((ShuffleDescriptor)new TestingShuffleDescriptor(resultPartitionId1), new IntermediateDataSetID(), 1));
        partitionTracker.startTrackingPartition(new JobID(), new TaskExecutorPartitionInfo((ShuffleDescriptor)new TestingShuffleDescriptor(resultPartitionId2), new IntermediateDataSetID(), 1));
        partitionTracker.stopTrackingAndReleaseJobPartitions(Collections.singleton(resultPartitionId1));
        MatcherAssert.assertThat(shuffleReleaseFuture.get(), (Matcher)Matchers.hasItem((Object)resultPartitionId1));
    }

    @Test
    public void testStopTrackingAndReleaseJobPartitionsFor() throws Exception {
        TestingShuffleEnvironment testingShuffleEnvironment = new TestingShuffleEnvironment();
        CompletableFuture shuffleReleaseFuture = new CompletableFuture();
        testingShuffleEnvironment.releasePartitionsLocallyFuture = shuffleReleaseFuture;
        JobID jobId1 = new JobID();
        JobID jobId2 = new JobID();
        ResultPartitionID resultPartitionId1 = new ResultPartitionID();
        ResultPartitionID resultPartitionId2 = new ResultPartitionID();
        TaskExecutorPartitionTrackerImpl partitionTracker = new TaskExecutorPartitionTrackerImpl((ShuffleEnvironment)testingShuffleEnvironment);
        partitionTracker.startTrackingPartition(jobId1, new TaskExecutorPartitionInfo((ShuffleDescriptor)new TestingShuffleDescriptor(resultPartitionId1), new IntermediateDataSetID(), 1));
        partitionTracker.startTrackingPartition(jobId2, new TaskExecutorPartitionInfo((ShuffleDescriptor)new TestingShuffleDescriptor(resultPartitionId2), new IntermediateDataSetID(), 1));
        partitionTracker.stopTrackingAndReleaseJobPartitionsFor(jobId1);
        MatcherAssert.assertThat(shuffleReleaseFuture.get(), (Matcher)Matchers.hasItem((Object)resultPartitionId1));
    }

    @Test
    public void promoteJobPartitions() throws Exception {
        TestingShuffleEnvironment testingShuffleEnvironment = new TestingShuffleEnvironment();
        CompletableFuture shuffleReleaseFuture = new CompletableFuture();
        testingShuffleEnvironment.releasePartitionsLocallyFuture = shuffleReleaseFuture;
        JobID jobId = new JobID();
        ResultPartitionID resultPartitionId1 = new ResultPartitionID();
        ResultPartitionID resultPartitionId2 = new ResultPartitionID();
        TaskExecutorPartitionTrackerImpl partitionTracker = new TaskExecutorPartitionTrackerImpl((ShuffleEnvironment)testingShuffleEnvironment);
        partitionTracker.startTrackingPartition(jobId, new TaskExecutorPartitionInfo((ShuffleDescriptor)new TestingShuffleDescriptor(resultPartitionId1), new IntermediateDataSetID(), 1));
        partitionTracker.startTrackingPartition(jobId, new TaskExecutorPartitionInfo((ShuffleDescriptor)new TestingShuffleDescriptor(resultPartitionId2), new IntermediateDataSetID(), 1));
        partitionTracker.promoteJobPartitions(Collections.singleton(resultPartitionId1));
        partitionTracker.stopTrackingAndReleaseJobPartitionsFor(jobId);
        MatcherAssert.assertThat(shuffleReleaseFuture.get(), (Matcher)CoreMatchers.not((Matcher)Matchers.hasItem((Object)resultPartitionId1)));
    }

    @Test
    public void stopTrackingAndReleaseAllClusterPartitions() throws Exception {
        TestingShuffleEnvironment testingShuffleEnvironment = new TestingShuffleEnvironment();
        CompletableFuture shuffleReleaseFuture = new CompletableFuture();
        testingShuffleEnvironment.releasePartitionsLocallyFuture = shuffleReleaseFuture;
        ResultPartitionID resultPartitionId1 = new ResultPartitionID();
        ResultPartitionID resultPartitionId2 = new ResultPartitionID();
        TaskExecutorPartitionTrackerImpl partitionTracker = new TaskExecutorPartitionTrackerImpl((ShuffleEnvironment)testingShuffleEnvironment);
        partitionTracker.startTrackingPartition(new JobID(), new TaskExecutorPartitionInfo((ShuffleDescriptor)new TestingShuffleDescriptor(resultPartitionId1), new IntermediateDataSetID(), 1));
        partitionTracker.startTrackingPartition(new JobID(), new TaskExecutorPartitionInfo((ShuffleDescriptor)new TestingShuffleDescriptor(resultPartitionId2), new IntermediateDataSetID(), 1));
        partitionTracker.promoteJobPartitions(Collections.singleton(resultPartitionId1));
        partitionTracker.stopTrackingAndReleaseAllClusterPartitions();
        MatcherAssert.assertThat(shuffleReleaseFuture.get(), (Matcher)Matchers.hasItem((Object)resultPartitionId1));
    }

    @Test
    public void stopTrackingAndReleaseClusterPartitions() throws Exception {
        TestingShuffleEnvironment testingShuffleEnvironment = new TestingShuffleEnvironment();
        CompletableFuture shuffleReleaseFuture = new CompletableFuture();
        testingShuffleEnvironment.releasePartitionsLocallyFuture = shuffleReleaseFuture;
        ResultPartitionID resultPartitionId1 = new ResultPartitionID();
        ResultPartitionID resultPartitionId2 = new ResultPartitionID();
        IntermediateDataSetID dataSetId1 = new IntermediateDataSetID();
        IntermediateDataSetID dataSetId2 = new IntermediateDataSetID();
        TaskExecutorPartitionTrackerImpl partitionTracker = new TaskExecutorPartitionTrackerImpl((ShuffleEnvironment)testingShuffleEnvironment);
        partitionTracker.startTrackingPartition(new JobID(), new TaskExecutorPartitionInfo((ShuffleDescriptor)new TestingShuffleDescriptor(resultPartitionId1), dataSetId1, 1));
        partitionTracker.startTrackingPartition(new JobID(), new TaskExecutorPartitionInfo((ShuffleDescriptor)new TestingShuffleDescriptor(resultPartitionId2), dataSetId2, 1));
        partitionTracker.promoteJobPartitions(Collections.singleton(resultPartitionId1));
        partitionTracker.stopTrackingAndReleaseClusterPartitions(Collections.singleton(dataSetId1));
        MatcherAssert.assertThat(shuffleReleaseFuture.get(), (Matcher)Matchers.hasItem((Object)resultPartitionId1));
    }

    private static class TestingShuffleDescriptor
    implements ShuffleDescriptor {
        private final ResultPartitionID resultPartitionID;

        private TestingShuffleDescriptor(ResultPartitionID resultPartitionID) {
            this.resultPartitionID = resultPartitionID;
        }

        public ResultPartitionID getResultPartitionID() {
            return this.resultPartitionID;
        }

        public Optional<ResourceID> storesLocalResourcesOn() {
            return Optional.empty();
        }
    }

    private static class TestingShuffleEnvironment
    implements ShuffleEnvironment<ResultPartition, SingleInputGate> {
        private final ShuffleEnvironment<ResultPartition, SingleInputGate> backingShuffleEnvironment = new NettyShuffleEnvironmentBuilder().build();
        CompletableFuture<Collection<ResultPartitionID>> releasePartitionsLocallyFuture = null;

        private TestingShuffleEnvironment() {
        }

        public int start() throws IOException {
            return this.backingShuffleEnvironment.start();
        }

        public ShuffleIOOwnerContext createShuffleIOOwnerContext(String ownerName, ExecutionAttemptID executionAttemptID, MetricGroup parentGroup) {
            return this.backingShuffleEnvironment.createShuffleIOOwnerContext(ownerName, executionAttemptID, parentGroup);
        }

        public List<ResultPartition> createResultPartitionWriters(ShuffleIOOwnerContext ownerContext, List<ResultPartitionDeploymentDescriptor> resultPartitionDeploymentDescriptors) {
            return this.backingShuffleEnvironment.createResultPartitionWriters(ownerContext, resultPartitionDeploymentDescriptors);
        }

        public void releasePartitionsLocally(Collection<ResultPartitionID> partitionIds) {
            this.backingShuffleEnvironment.releasePartitionsLocally(partitionIds);
            if (this.releasePartitionsLocallyFuture != null) {
                this.releasePartitionsLocallyFuture.complete(partitionIds);
            }
        }

        public Collection<ResultPartitionID> getPartitionsOccupyingLocalResources() {
            return this.backingShuffleEnvironment.getPartitionsOccupyingLocalResources();
        }

        public List<SingleInputGate> createInputGates(ShuffleIOOwnerContext ownerContext, PartitionProducerStateProvider partitionProducerStateProvider, List<InputGateDeploymentDescriptor> inputGateDeploymentDescriptors) {
            return this.backingShuffleEnvironment.createInputGates(ownerContext, partitionProducerStateProvider, inputGateDeploymentDescriptors);
        }

        public boolean updatePartitionInfo(ExecutionAttemptID consumerID, PartitionInfo partitionInfo) throws IOException, InterruptedException {
            return this.backingShuffleEnvironment.updatePartitionInfo(consumerID, partitionInfo);
        }

        public void close() throws Exception {
            this.backingShuffleEnvironment.close();
        }
    }
}

