/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.zookeeper;

import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.highavailability.zookeeper.AbstractZooKeeperHaServices;
import org.apache.flink.runtime.highavailability.zookeeper.CuratorFrameworkWithUnhandledErrorListener;
import org.apache.flink.runtime.leaderelection.DefaultLeaderElectionService;
import org.apache.flink.runtime.leaderelection.DefaultMultipleComponentLeaderElectionService;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderelection.MultipleComponentLeaderElectionService;
import org.apache.flink.runtime.leaderelection.ZooKeeperMultipleComponentLeaderElectionDriverFactory;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkRuntimeException;

public class ZooKeeperMultipleComponentLeaderElectionHaServices
extends AbstractZooKeeperHaServices {
    private final Object lock = new Object();
    private final CuratorFramework leaderNamespacedCuratorFramework = ZooKeeperUtils.useNamespaceAndEnsurePath(this.getCuratorFramework(), ZooKeeperUtils.getLeaderPath());
    private final FatalErrorHandler fatalErrorHandler;
    @Nullable
    @GuardedBy(value="lock")
    private MultipleComponentLeaderElectionService multipleComponentLeaderElectionService = null;

    public ZooKeeperMultipleComponentLeaderElectionHaServices(CuratorFrameworkWithUnhandledErrorListener curatorFrameworkWrapper, Configuration config, Executor ioExecutor, BlobStoreService blobStoreService, FatalErrorHandler fatalErrorHandler) throws Exception {
        super(curatorFrameworkWrapper, ioExecutor, config, blobStoreService);
        this.fatalErrorHandler = fatalErrorHandler;
    }

    @Override
    protected LeaderElectionService createLeaderElectionService(String leaderName) {
        return new DefaultLeaderElectionService(this.getOrInitializeSingleLeaderElectionService().createDriverFactory(leaderName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultipleComponentLeaderElectionService getOrInitializeSingleLeaderElectionService() {
        Object object = this.lock;
        synchronized (object) {
            if (this.multipleComponentLeaderElectionService == null) {
                try {
                    this.multipleComponentLeaderElectionService = new DefaultMultipleComponentLeaderElectionService(this.fatalErrorHandler, new ZooKeeperMultipleComponentLeaderElectionDriverFactory(this.leaderNamespacedCuratorFramework));
                }
                catch (Exception e) {
                    throw new FlinkRuntimeException(String.format("Could not initialize the %s", DefaultMultipleComponentLeaderElectionService.class.getSimpleName()), (Throwable)e);
                }
            }
            return this.multipleComponentLeaderElectionService;
        }
    }

    @Override
    protected LeaderRetrievalService createLeaderRetrievalService(String leaderPath) {
        return ZooKeeperUtils.createLeaderRetrievalService(this.leaderNamespacedCuratorFramework, leaderPath, this.configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalClose() throws Exception {
        Exception exception = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.multipleComponentLeaderElectionService != null) {
                try {
                    this.multipleComponentLeaderElectionService.close();
                }
                catch (Exception e) {
                    exception = e;
                }
                this.multipleComponentLeaderElectionService = null;
            }
        }
        try {
            super.internalClose();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        ExceptionUtils.tryRethrowException((Exception)exception);
    }

    @Override
    protected String getLeaderPathForResourceManager() {
        return ZooKeeperUtils.getResourceManagerNode();
    }

    @Override
    protected String getLeaderPathForDispatcher() {
        return ZooKeeperUtils.getDispatcherNode();
    }

    @Override
    protected String getLeaderPathForJobManager(JobID jobID) {
        return jobID.toString();
    }

    @Override
    protected String getLeaderPathForRestServer() {
        return ZooKeeperUtils.getRestServerNode();
    }
}

