/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointTriggerRequestBody;
import org.apache.flink.runtime.rest.messages.job.savepoints.stop.StopWithSavepointRequestBody;
import org.apache.flink.runtime.rest.util.RestMapperUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SavepointHandlerRequestBodyTest {
    @Test
    public void testSavepointRequestCanBeParsedFromEmptyObject() throws JsonProcessingException {
        SavepointTriggerRequestBody defaultParseResult = SavepointHandlerRequestBodyTest.getDefaultParseResult(SavepointTriggerRequestBody.class);
        Assert.assertThat((Object)defaultParseResult.isCancelJob(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)defaultParseResult.getTargetDirectory().isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testStopWithSavepointRequestCanBeParsedFromEmptyObject() throws JsonProcessingException {
        StopWithSavepointRequestBody defaultParseResult = SavepointHandlerRequestBodyTest.getDefaultParseResult(StopWithSavepointRequestBody.class);
        Assert.assertThat((Object)defaultParseResult.shouldDrain(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)defaultParseResult.getTargetDirectory().isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    private static <T> T getDefaultParseResult(Class<T> clazz) throws JsonProcessingException {
        ObjectMapper mapper = RestMapperUtils.getStrictObjectMapper();
        return (T)mapper.readValue("{}", clazz);
    }
}

