/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecution;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionVertex;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionHistory;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.HandlerRequestException;
import org.apache.flink.runtime.rest.handler.RestHandlerConfiguration;
import org.apache.flink.runtime.rest.handler.job.JobVertexFlameGraphHandler;
import org.apache.flink.runtime.rest.handler.legacy.DefaultExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.FlameGraphTypeQueryParameter;
import org.apache.flink.runtime.rest.messages.JobVertexFlameGraphParameters;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.webmonitor.stats.JobVertexStatsTracker;
import org.apache.flink.runtime.webmonitor.threadinfo.VertexFlameGraph;
import org.apache.flink.runtime.webmonitor.threadinfo.VertexThreadInfoStats;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.Executors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class JobVertexFlameGraphHandlerTest
extends TestLogger {
    private static final JobID JOB_ID = new JobID();
    private static final JobVertexID JOB_VERTEX_ID = new JobVertexID();
    private static VertexThreadInfoStats taskThreadInfoStatsDefaultSample;
    private static JobVertexFlameGraphHandler handler;

    @BeforeAll
    public static void setUp() {
        taskThreadInfoStatsDefaultSample = new VertexThreadInfoStats(8, System.currentTimeMillis(), System.currentTimeMillis() + 100L, Collections.emptyMap());
        RestHandlerConfiguration restHandlerConfiguration = RestHandlerConfiguration.fromConfiguration((Configuration)new Configuration());
        handler = new JobVertexFlameGraphHandler(() -> null, Time.milliseconds((long)100L), Collections.emptyMap(), (ExecutionGraphCache)new DefaultExecutionGraphCache(restHandlerConfiguration.getTimeout(), Time.milliseconds((long)restHandlerConfiguration.getRefreshInterval())), Executors.directExecutor(), (JobVertexStatsTracker)new TestThreadInfoTracker(taskThreadInfoStatsDefaultSample));
    }

    @Test
    void testHandleMixedSubtasks() throws Exception {
        ArchivedExecutionJobVertex archivedExecutionJobVertex = new ArchivedExecutionJobVertex(new ArchivedExecutionVertex[]{this.generateExecutionVertex(0, ExecutionState.FINISHED), this.generateExecutionVertex(1, ExecutionState.RUNNING)}, JOB_VERTEX_ID, "test", 2, 2, ResourceProfile.UNKNOWN, new StringifiedAccumulatorResult[0]);
        HandlerRequest<EmptyRequestBody> request = this.generateJobVertexFlameGraphParameters(0);
        VertexFlameGraph jobVertexFlameGraph = handler.handleRequest(request, (AccessExecutionJobVertex)archivedExecutionJobVertex);
        Assertions.assertThat((long)jobVertexFlameGraph.getEndTime()).isEqualTo(VertexFlameGraph.terminated().getEndTime());
        request = this.generateJobVertexFlameGraphParameters(1);
        jobVertexFlameGraph = handler.handleRequest(request, (AccessExecutionJobVertex)archivedExecutionJobVertex);
        Assertions.assertThat((long)jobVertexFlameGraph.getEndTime()).isEqualTo(taskThreadInfoStatsDefaultSample.getEndTime());
        request = this.generateJobVertexFlameGraphParameters(null);
        jobVertexFlameGraph = handler.handleRequest(request, (AccessExecutionJobVertex)archivedExecutionJobVertex);
        Assertions.assertThat((long)jobVertexFlameGraph.getEndTime()).isEqualTo(taskThreadInfoStatsDefaultSample.getEndTime());
    }

    @Test
    void testHandleFinishedJobVertex() throws Exception {
        ArchivedExecutionJobVertex archivedExecutionJobVertex = new ArchivedExecutionJobVertex(new ArchivedExecutionVertex[]{this.generateExecutionVertex(0, ExecutionState.FINISHED), this.generateExecutionVertex(1, ExecutionState.FINISHED)}, JOB_VERTEX_ID, "test", 2, 2, ResourceProfile.UNKNOWN, new StringifiedAccumulatorResult[0]);
        HandlerRequest<EmptyRequestBody> request = this.generateJobVertexFlameGraphParameters(null);
        VertexFlameGraph jobVertexFlameGraph = handler.handleRequest(request, (AccessExecutionJobVertex)archivedExecutionJobVertex);
        Assertions.assertThat((long)jobVertexFlameGraph.getEndTime()).isEqualTo(VertexFlameGraph.terminated().getEndTime());
    }

    private HandlerRequest<EmptyRequestBody> generateJobVertexFlameGraphParameters(Integer subtaskIndex) throws HandlerRequestException {
        HashMap<String, String> receivedPathParameters = new HashMap<String, String>(2);
        receivedPathParameters.put("jobid", JOB_ID.toString());
        receivedPathParameters.put("vertexid", JOB_VERTEX_ID.toString());
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>(2);
        queryParams.put("type", Collections.singletonList(FlameGraphTypeQueryParameter.Type.FULL.name()));
        if (subtaskIndex != null) {
            queryParams.put("subtaskindex", Collections.singletonList(subtaskIndex.toString()));
        }
        return HandlerRequest.resolveParametersAndCreate((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new JobVertexFlameGraphParameters(), receivedPathParameters, queryParams, Collections.emptyList());
    }

    private ArchivedExecutionVertex generateExecutionVertex(int subtaskIndex, ExecutionState executionState) {
        return new ArchivedExecutionVertex(subtaskIndex, "test task", new ArchivedExecution(new StringifiedAccumulatorResult[0], null, ExecutionGraphTestUtils.createExecutionAttemptId(JOB_VERTEX_ID, subtaskIndex, 0), executionState, null, null, null, new long[ExecutionState.values().length], new long[ExecutionState.values().length]), new ExecutionHistory(0));
    }

    private static class TestThreadInfoTracker
    implements JobVertexStatsTracker<VertexThreadInfoStats> {
        private final VertexThreadInfoStats stats;

        public TestThreadInfoTracker(VertexThreadInfoStats stats) {
            this.stats = stats;
        }

        public Optional<VertexThreadInfoStats> getVertexStats(JobID jobId, AccessExecutionJobVertex vertex) {
            return Optional.of(this.stats);
        }

        public void shutDown() throws FlinkException {
        }
    }
}

