/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.util.ListCollector;
import org.apache.flink.api.common.operators.base.OuterJoinOperatorBase;
import org.apache.flink.api.common.typeutils.GenericPairComparator;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntComparator;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.runtime.TupleComparator;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.MemoryManagerBuilder;
import org.apache.flink.runtime.operators.sort.AbstractMergeOuterJoinIterator;
import org.apache.flink.runtime.operators.sort.MergeIterator;
import org.apache.flink.runtime.operators.testutils.CollectionIterator;
import org.apache.flink.runtime.operators.testutils.DiscardingOutputCollector;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.runtime.operators.testutils.Match;
import org.apache.flink.runtime.operators.testutils.MatchRemovingJoiner;
import org.apache.flink.runtime.operators.testutils.SimpleTupleJoinFunction;
import org.apache.flink.runtime.operators.testutils.TestData;
import org.apache.flink.runtime.util.ResettableMutableObjectIterator;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractSortMergeOuterJoinIteratorITCase
extends TestLogger {
    private static final int MEMORY_SIZE = 0x1000000;
    private static final int PAGES_FOR_BNLJN = 2;
    private static final long SEED1 = 561349061987311L;
    private static final long SEED2 = 231434613412342L;
    private final AbstractInvokable parentTask = new DummyInvokable();
    private IOManager ioManager;
    private MemoryManager memoryManager;
    private TupleSerializer<Tuple2<String, String>> serializer1;
    private TupleSerializer<Tuple2<String, Integer>> serializer2;
    private TypeComparator<Tuple2<String, String>> comparator1;
    private TypeComparator<Tuple2<String, Integer>> comparator2;
    private TypePairComparator<Tuple2<String, String>, Tuple2<String, Integer>> pairComp;

    @Before
    public void beforeTest() {
        ExecutionConfig config = new ExecutionConfig();
        config.disableObjectReuse();
        TupleTypeInfo typeInfo1 = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class, String.class});
        TupleTypeInfo typeInfo2 = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class, Integer.class});
        this.serializer1 = typeInfo1.createSerializer(config);
        this.serializer2 = typeInfo2.createSerializer(config);
        this.comparator1 = typeInfo1.createComparator(new int[]{0}, new boolean[]{true}, 0, config);
        this.comparator2 = typeInfo2.createComparator(new int[]{0}, new boolean[]{true}, 0, config);
        this.pairComp = new GenericPairComparator(this.comparator1, this.comparator2);
        this.memoryManager = MemoryManagerBuilder.newBuilder().setMemorySize(0x1000000L).build();
        this.ioManager = new IOManagerAsync();
    }

    @After
    public void afterTest() throws Exception {
        if (this.ioManager != null) {
            this.ioManager.close();
            this.ioManager = null;
        }
        if (this.memoryManager != null) {
            Assert.assertTrue((String)"Memory Leak: Not all memory has been returned to the memory manager.", (boolean)this.memoryManager.verifyEmpty());
            this.memoryManager.shutdown();
            this.memoryManager = null;
        }
    }

    protected void testFullOuterWithSample() throws Exception {
        CollectionIterator<Tuple2<String, String>> input1 = CollectionIterator.of(new Tuple2((Object)"Jack", (Object)"Engineering"), new Tuple2((Object)"Tim", (Object)"Sales"), new Tuple2((Object)"Zed", (Object)"HR"));
        CollectionIterator<Tuple2<String, Integer>> input2 = CollectionIterator.of(new Tuple2((Object)"Allison", (Object)100), new Tuple2((Object)"Jack", (Object)200), new Tuple2((Object)"Zed", (Object)150), new Tuple2((Object)"Zed", (Object)250));
        OuterJoinOperatorBase.OuterJoinType outerJoinType = OuterJoinOperatorBase.OuterJoinType.FULL;
        List<Tuple4<String, String, String, Object>> actual = this.computeOuterJoin(input1, input2, outerJoinType);
        List<Tuple4> expected = Arrays.asList(new Tuple4(null, null, (Object)"Allison", (Object)100), new Tuple4((Object)"Jack", (Object)"Engineering", (Object)"Jack", (Object)200), new Tuple4((Object)"Tim", (Object)"Sales", null, null), new Tuple4((Object)"Zed", (Object)"HR", (Object)"Zed", (Object)150), new Tuple4((Object)"Zed", (Object)"HR", (Object)"Zed", (Object)250));
        Assert.assertEquals(expected, actual);
    }

    protected void testLeftOuterWithSample() throws Exception {
        CollectionIterator<Tuple2<String, String>> input1 = CollectionIterator.of(new Tuple2((Object)"Jack", (Object)"Engineering"), new Tuple2((Object)"Tim", (Object)"Sales"), new Tuple2((Object)"Zed", (Object)"HR"));
        CollectionIterator<Tuple2<String, Integer>> input2 = CollectionIterator.of(new Tuple2((Object)"Allison", (Object)100), new Tuple2((Object)"Jack", (Object)200), new Tuple2((Object)"Zed", (Object)150), new Tuple2((Object)"Zed", (Object)250));
        List<Tuple4<String, String, String, Object>> actual = this.computeOuterJoin(input1, input2, OuterJoinOperatorBase.OuterJoinType.LEFT);
        List<Tuple4> expected = Arrays.asList(new Tuple4((Object)"Jack", (Object)"Engineering", (Object)"Jack", (Object)200), new Tuple4((Object)"Tim", (Object)"Sales", null, null), new Tuple4((Object)"Zed", (Object)"HR", (Object)"Zed", (Object)150), new Tuple4((Object)"Zed", (Object)"HR", (Object)"Zed", (Object)250));
        Assert.assertEquals(expected, actual);
    }

    protected void testRightOuterWithSample() throws Exception {
        CollectionIterator<Tuple2<String, String>> input1 = CollectionIterator.of(new Tuple2((Object)"Jack", (Object)"Engineering"), new Tuple2((Object)"Tim", (Object)"Sales"), new Tuple2((Object)"Zed", (Object)"HR"));
        CollectionIterator<Tuple2<String, Integer>> input2 = CollectionIterator.of(new Tuple2((Object)"Allison", (Object)100), new Tuple2((Object)"Jack", (Object)200), new Tuple2((Object)"Zed", (Object)150), new Tuple2((Object)"Zed", (Object)250));
        List<Tuple4<String, String, String, Object>> actual = this.computeOuterJoin(input1, input2, OuterJoinOperatorBase.OuterJoinType.RIGHT);
        List<Tuple4> expected = Arrays.asList(new Tuple4(null, null, (Object)"Allison", (Object)100), new Tuple4((Object)"Jack", (Object)"Engineering", (Object)"Jack", (Object)200), new Tuple4((Object)"Zed", (Object)"HR", (Object)"Zed", (Object)150), new Tuple4((Object)"Zed", (Object)"HR", (Object)"Zed", (Object)250));
        Assert.assertEquals(expected, actual);
    }

    protected void testRightSideEmpty() throws Exception {
        CollectionIterator<Tuple2<String, String>> input1 = CollectionIterator.of(new Tuple2((Object)"Jack", (Object)"Engineering"), new Tuple2((Object)"Tim", (Object)"Sales"), new Tuple2((Object)"Zed", (Object)"HR"));
        CollectionIterator<Tuple2<String, Integer>> input2 = CollectionIterator.of(new Tuple2[0]);
        List<Tuple4<String, String, String, Object>> actualLeft = this.computeOuterJoin(input1, input2, OuterJoinOperatorBase.OuterJoinType.LEFT);
        List<Tuple4<String, String, String, Object>> actualRight = this.computeOuterJoin(input1, input2, OuterJoinOperatorBase.OuterJoinType.RIGHT);
        List<Tuple4<String, String, String, Object>> actualFull = this.computeOuterJoin(input1, input2, OuterJoinOperatorBase.OuterJoinType.FULL);
        List<Tuple4> expected = Arrays.asList(new Tuple4((Object)"Jack", (Object)"Engineering", null, null), new Tuple4((Object)"Tim", (Object)"Sales", null, null), new Tuple4((Object)"Zed", (Object)"HR", null, null));
        Assert.assertEquals(expected, actualLeft);
        Assert.assertEquals(expected, actualFull);
        Assert.assertEquals(Collections.emptyList(), actualRight);
    }

    protected void testLeftSideEmpty() throws Exception {
        CollectionIterator<Tuple2<String, String>> input1 = CollectionIterator.of(new Tuple2[0]);
        CollectionIterator<Tuple2<String, Integer>> input2 = CollectionIterator.of(new Tuple2((Object)"Allison", (Object)100), new Tuple2((Object)"Jack", (Object)200), new Tuple2((Object)"Zed", (Object)150), new Tuple2((Object)"Zed", (Object)250));
        List<Tuple4<String, String, String, Object>> actualLeft = this.computeOuterJoin(input1, input2, OuterJoinOperatorBase.OuterJoinType.LEFT);
        List<Tuple4<String, String, String, Object>> actualRight = this.computeOuterJoin(input1, input2, OuterJoinOperatorBase.OuterJoinType.RIGHT);
        List<Tuple4<String, String, String, Object>> actualFull = this.computeOuterJoin(input1, input2, OuterJoinOperatorBase.OuterJoinType.FULL);
        List<Tuple4> expected = Arrays.asList(new Tuple4(null, null, (Object)"Allison", (Object)100), new Tuple4(null, null, (Object)"Jack", (Object)200), new Tuple4(null, null, (Object)"Zed", (Object)150), new Tuple4(null, null, (Object)"Zed", (Object)250));
        Assert.assertEquals(Collections.emptyList(), actualLeft);
        Assert.assertEquals(expected, actualRight);
        Assert.assertEquals(expected, actualFull);
    }

    private List<Tuple4<String, String, String, Object>> computeOuterJoin(ResettableMutableObjectIterator<Tuple2<String, String>> input1, ResettableMutableObjectIterator<Tuple2<String, Integer>> input2, OuterJoinOperatorBase.OuterJoinType outerJoinType) throws Exception {
        input1.reset();
        input2.reset();
        AbstractMergeOuterJoinIterator iterator = this.createOuterJoinIterator(outerJoinType, (MutableObjectIterator)input1, (MutableObjectIterator)input2, (TypeSerializer)this.serializer1, (TypeComparator)this.comparator1, (TypeSerializer)this.serializer2, (TypeComparator)this.comparator2, (TypePairComparator)this.pairComp, this.memoryManager, this.ioManager, 2, this.parentTask);
        ArrayList<Tuple4<String, String, String, Object>> actual = new ArrayList<Tuple4<String, String, String, Object>>();
        ListCollector collector = new ListCollector(actual);
        while (iterator.callWithNextKey((FlatJoinFunction)new SimpleTupleJoinFunction(), (Collector)collector)) {
        }
        iterator.close();
        return actual;
    }

    protected void testOuterJoinWithHighNumberOfCommonKeys(OuterJoinOperatorBase.OuterJoinType outerJoinType, int input1Size, int input1Duplicates, int input1ValueLength, float input1KeyDensity, int input2Size, int input2Duplicates, int input2ValueLength, float input2KeyDensity) {
        TupleSerializer serializer1 = new TupleSerializer(Tuple2.class, new TypeSerializer[]{IntSerializer.INSTANCE, StringSerializer.INSTANCE});
        TupleSerializer serializer2 = new TupleSerializer(Tuple2.class, new TypeSerializer[]{IntSerializer.INSTANCE, StringSerializer.INSTANCE});
        TupleComparator comparator1 = new TupleComparator(new int[]{0}, new TypeComparator[]{new IntComparator(true)}, new TypeSerializer[]{IntSerializer.INSTANCE});
        TupleComparator comparator2 = new TupleComparator(new int[]{0}, new TypeComparator[]{new IntComparator(true)}, new TypeSerializer[]{IntSerializer.INSTANCE});
        GenericPairComparator pairComparator = new GenericPairComparator((TypeComparator)comparator1, (TypeComparator)comparator2);
        int DUPLICATE_KEY = 13;
        try {
            TestData.TupleGenerator generator1 = new TestData.TupleGenerator(561349061987311L, 500, input1KeyDensity, input1ValueLength, TestData.TupleGenerator.KeyMode.SORTED_SPARSE, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH, null);
            TestData.TupleGenerator generator2 = new TestData.TupleGenerator(231434613412342L, 500, input2KeyDensity, input2ValueLength, TestData.TupleGenerator.KeyMode.SORTED_SPARSE, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH, null);
            TestData.TupleGeneratorIterator gen1Iter = new TestData.TupleGeneratorIterator(generator1, input1Size);
            TestData.TupleGeneratorIterator gen2Iter = new TestData.TupleGeneratorIterator(generator2, input2Size);
            TestData.TupleConstantValueIterator const1Iter = new TestData.TupleConstantValueIterator(13, "LEFT String for Duplicate Keys", input1Duplicates);
            TestData.TupleConstantValueIterator const2Iter = new TestData.TupleConstantValueIterator(13, "RIGHT String for Duplicate Keys", input2Duplicates);
            ArrayList<Object> inList1 = new ArrayList<Object>();
            inList1.add(gen1Iter);
            inList1.add(const1Iter);
            ArrayList<Object> inList2 = new ArrayList<Object>();
            inList2.add(gen2Iter);
            inList2.add(const2Iter);
            MergeIterator input1 = new MergeIterator(inList1, comparator1.duplicate());
            MergeIterator input2 = new MergeIterator(inList2, comparator2.duplicate());
            Map<Integer, Collection<Match>> expectedMatchesMap = this.joinValues(this.collectData((MutableObjectIterator<Tuple2<Integer, String>>)input1), this.collectData((MutableObjectIterator<Tuple2<Integer, String>>)input2), outerJoinType);
            generator1.reset();
            generator2.reset();
            const1Iter.reset();
            const2Iter.reset();
            gen1Iter.reset();
            gen2Iter.reset();
            inList1.clear();
            inList1.add(gen1Iter);
            inList1.add(const1Iter);
            inList2.clear();
            inList2.add(gen2Iter);
            inList2.add(const2Iter);
            input1 = new MergeIterator(inList1, comparator1.duplicate());
            input2 = new MergeIterator(inList2, comparator2.duplicate());
            MatchRemovingJoiner joinFunction = new MatchRemovingJoiner(expectedMatchesMap);
            DiscardingOutputCollector collector = new DiscardingOutputCollector();
            AbstractMergeOuterJoinIterator iterator = this.createOuterJoinIterator(outerJoinType, (MutableObjectIterator)input1, (MutableObjectIterator)input2, (TypeSerializer)serializer1, (TypeComparator)comparator1, (TypeSerializer)serializer2, (TypeComparator)comparator2, (TypePairComparator)pairComparator, this.memoryManager, this.ioManager, 2, this.parentTask);
            iterator.open();
            while (iterator.callWithNextKey((FlatJoinFunction)joinFunction, collector)) {
            }
            iterator.close();
            for (Map.Entry<Integer, Collection<Match>> entry : expectedMatchesMap.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                Assert.fail((String)("Collection for key " + entry.getKey() + " is not empty"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("An exception occurred during the test: " + e.getMessage()));
        }
    }

    protected abstract <T1, T2, T3> AbstractMergeOuterJoinIterator<T1, T2, T3> createOuterJoinIterator(OuterJoinOperatorBase.OuterJoinType var1, MutableObjectIterator<T1> var2, MutableObjectIterator<T2> var3, TypeSerializer<T1> var4, TypeComparator<T1> var5, TypeSerializer<T2> var6, TypeComparator<T2> var7, TypePairComparator<T1, T2> var8, MemoryManager var9, IOManager var10, int var11, AbstractInvokable var12) throws Exception;

    private Map<Integer, Collection<Match>> joinValues(Map<Integer, Collection<String>> leftMap, Map<Integer, Collection<String>> rightMap, OuterJoinOperatorBase.OuterJoinType outerJoinType) {
        Collection joinedValues;
        Collection<String> rightValues;
        Collection<String> leftValues;
        HashMap<Integer, Collection<Match>> map = new HashMap<Integer, Collection<Match>>();
        for (Integer key : leftMap.keySet()) {
            leftValues = leftMap.get(key);
            rightValues = rightMap.get(key);
            if (outerJoinType == OuterJoinOperatorBase.OuterJoinType.RIGHT && rightValues == null) continue;
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            joinedValues = (Collection)map.get(key);
            for (String leftValue : leftValues) {
                if (rightValues != null) {
                    for (String rightValue : rightValues) {
                        joinedValues.add(new Match(leftValue, rightValue));
                    }
                    continue;
                }
                joinedValues.add(new Match(leftValue, null));
            }
        }
        if (outerJoinType == OuterJoinOperatorBase.OuterJoinType.RIGHT || outerJoinType == OuterJoinOperatorBase.OuterJoinType.FULL) {
            for (Integer key : rightMap.keySet()) {
                leftValues = leftMap.get(key);
                rightValues = rightMap.get(key);
                if (leftValues != null) continue;
                if (!map.containsKey(key)) {
                    map.put(key, new ArrayList());
                }
                joinedValues = (Collection)map.get(key);
                for (String rightValue : rightValues) {
                    joinedValues.add(new Match(null, rightValue));
                }
            }
        }
        return map;
    }

    private Map<Integer, Collection<String>> collectData(MutableObjectIterator<Tuple2<Integer, String>> iter) throws Exception {
        HashMap<Integer, Collection<String>> map = new HashMap<Integer, Collection<String>>();
        Tuple2 pair = new Tuple2();
        while ((pair = (Tuple2)iter.next((Object)pair)) != null) {
            Integer key = (Integer)pair.getField(0);
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            Collection values = (Collection)map.get(key);
            String value = (String)pair.getField(1);
            values.add(value);
        }
        return map;
    }
}

