/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.Map;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.executiongraph.ResultPartitionBytes;
import org.apache.flink.runtime.io.network.metrics.ResultPartitionBytesCounter;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TaskIOMetricGroupTest {
    TaskIOMetricGroupTest() {
    }

    @Test
    void testTaskIOMetricGroup() throws InterruptedException {
        TaskMetricGroup task = UnregisteredMetricGroups.createUnregisteredTaskMetricGroup();
        TaskIOMetricGroup taskIO = task.getIOMetricGroup();
        taskIO.setEnableBusyTime(true);
        long startTime = System.currentTimeMillis();
        Assertions.assertThat((Object)taskIO.getNumRecordsInCounter()).isNotNull();
        Assertions.assertThat((Object)taskIO.getNumRecordsOutCounter()).isNotNull();
        SimpleCounter c1 = new SimpleCounter();
        c1.inc(32L);
        SimpleCounter c2 = new SimpleCounter();
        c2.inc(64L);
        taskIO.reuseRecordsInputCounter((Counter)c1);
        taskIO.reuseRecordsOutputCounter((Counter)c2);
        Assertions.assertThat((long)taskIO.getNumRecordsInCounter().getCount()).isEqualTo(32L);
        Assertions.assertThat((long)taskIO.getNumRecordsOutCounter().getCount()).isEqualTo(64L);
        taskIO.getNumBytesInCounter().inc(100L);
        taskIO.getNumBytesOutCounter().inc(250L);
        taskIO.getNumBuffersOutCounter().inc(3L);
        taskIO.getIdleTimeMsPerSecond().markStart();
        taskIO.getSoftBackPressuredTimePerSecond().markStart();
        long softSleepTime = 2L;
        Thread.sleep(softSleepTime);
        taskIO.getIdleTimeMsPerSecond().markEnd();
        taskIO.getSoftBackPressuredTimePerSecond().markEnd();
        long hardSleepTime = 4L;
        taskIO.getHardBackPressuredTimePerSecond().markStart();
        Thread.sleep(hardSleepTime);
        taskIO.getHardBackPressuredTimePerSecond().markEnd();
        IOMetrics io = taskIO.createSnapshot();
        Assertions.assertThat((long)io.getNumRecordsIn()).isEqualTo(32L);
        Assertions.assertThat((long)io.getNumRecordsOut()).isEqualTo(64L);
        Assertions.assertThat((long)io.getNumBytesIn()).isEqualTo(100L);
        Assertions.assertThat((long)io.getNumBytesOut()).isEqualTo(250L);
        Assertions.assertThat((long)taskIO.getNumBuffersOutCounter().getCount()).isEqualTo(3L);
        Assertions.assertThat((long)taskIO.getIdleTimeMsPerSecond().getAccumulatedCount()).isEqualTo(io.getAccumulateIdleTime());
        Assertions.assertThat((long)(taskIO.getHardBackPressuredTimePerSecond().getAccumulatedCount() + taskIO.getSoftBackPressuredTimePerSecond().getAccumulatedCount())).isEqualTo(io.getAccumulateBackPressuredTime());
        Assertions.assertThat((double)io.getAccumulateBusyTime()).isGreaterThanOrEqualTo((double)System.currentTimeMillis() - (double)startTime - (double)io.getAccumulateIdleTime() - (double)io.getAccumulateBackPressuredTime());
        Assertions.assertThat((long)taskIO.getIdleTimeMsPerSecond().getCount()).isGreaterThanOrEqualTo(softSleepTime);
        Assertions.assertThat((long)taskIO.getSoftBackPressuredTimePerSecond().getCount()).isGreaterThanOrEqualTo(softSleepTime);
        Assertions.assertThat((long)taskIO.getHardBackPressuredTimePerSecond().getCount()).isGreaterThanOrEqualTo(hardSleepTime);
    }

    @Test
    void testResultPartitionBytesMetrics() {
        TaskMetricGroup task = UnregisteredMetricGroups.createUnregisteredTaskMetricGroup();
        TaskIOMetricGroup taskIO = task.getIOMetricGroup();
        ResultPartitionBytesCounter c1 = new ResultPartitionBytesCounter(2);
        ResultPartitionBytesCounter c2 = new ResultPartitionBytesCounter(2);
        c1.inc(0, 32L);
        c1.inc(1, 64L);
        c2.incAll(128L);
        IntermediateResultPartitionID resultPartitionID1 = new IntermediateResultPartitionID();
        IntermediateResultPartitionID resultPartitionID2 = new IntermediateResultPartitionID();
        taskIO.registerResultPartitionBytesCounter(resultPartitionID1, c1);
        taskIO.registerResultPartitionBytesCounter(resultPartitionID2, c2);
        Map resultPartitionBytes = taskIO.createSnapshot().getResultPartitionBytes();
        Assertions.assertThat((int)resultPartitionBytes.size()).isEqualTo(2);
        Assertions.assertThat((long[])((ResultPartitionBytes)resultPartitionBytes.get(resultPartitionID1)).getSubpartitionBytes()).containsExactly(new long[]{32L, 64L});
        Assertions.assertThat((long[])((ResultPartitionBytes)resultPartitionBytes.get(resultPartitionID2)).getSubpartitionBytes()).containsExactly(new long[]{128L, 128L});
    }
}

