/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.Collection;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderelection.LeaderInformationWithComponentId;

public abstract class LeaderElectionEvent {
    public boolean isIsLeaderEvent() {
        return false;
    }

    public boolean isNotLeaderEvent() {
        return false;
    }

    public boolean isLeaderInformationChangeEvent() {
        return false;
    }

    public boolean isAllKnownLeaderInformationEvent() {
        return false;
    }

    public IsLeaderEvent asIsLeaderEvent() {
        return this.as(IsLeaderEvent.class);
    }

    public <T> T as(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new IllegalStateException("Cannot cast object.");
    }

    public static class AllKnownLeaderInformationEvent
    extends LeaderElectionEvent {
        private final Collection<LeaderInformationWithComponentId> leaderInformationWithComponentIds;

        AllKnownLeaderInformationEvent(Collection<LeaderInformationWithComponentId> leaderInformationWithComponentIds) {
            this.leaderInformationWithComponentIds = leaderInformationWithComponentIds;
        }

        @Override
        public boolean isAllKnownLeaderInformationEvent() {
            return true;
        }

        public Collection<LeaderInformationWithComponentId> getLeaderInformationWithComponentIds() {
            return this.leaderInformationWithComponentIds;
        }
    }

    public static class LeaderInformationChangeEvent
    extends LeaderElectionEvent {
        private final String componentId;
        private final LeaderInformation leaderInformation;

        LeaderInformationChangeEvent(String componentId, LeaderInformation leaderInformation) {
            this.componentId = componentId;
            this.leaderInformation = leaderInformation;
        }

        public LeaderInformation getLeaderInformation() {
            return this.leaderInformation;
        }

        public String getComponentId() {
            return this.componentId;
        }

        @Override
        public boolean isLeaderInformationChangeEvent() {
            return true;
        }
    }

    public static class NotLeaderEvent
    extends LeaderElectionEvent {
        @Override
        public boolean isNotLeaderEvent() {
            return true;
        }
    }

    public static class IsLeaderEvent
    extends LeaderElectionEvent {
        @Override
        public boolean isIsLeaderEvent() {
            return true;
        }
    }
}

