/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.flink.runtime.io.network.partition.hybrid.HsFileDataIndexImpl;
import org.apache.flink.runtime.io.network.partition.hybrid.HsFileDataIndexSpilledRegionManager;
import org.apache.flink.runtime.io.network.partition.hybrid.HsFileDataIndexSpilledRegionManagerImpl;
import org.apache.flink.runtime.io.network.partition.hybrid.HybridShuffleTestUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.InternalRegionWriteReadUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class HsFileDataIndexSpilledRegionManagerImplTest {
    private Path indexFilePath;

    HsFileDataIndexSpilledRegionManagerImplTest() {
    }

    @BeforeEach
    void before(@TempDir Path tmpPath) {
        this.indexFilePath = tmpPath.resolve(UUID.randomUUID().toString());
    }

    @Test
    void testFindNonExistentRegion() throws Exception {
        CompletableFuture cachedRegionFuture = new CompletableFuture();
        try (HsFileDataIndexSpilledRegionManager spilledRegionManager = this.createSpilledRegionManager((ignore1, ignore2) -> cachedRegionFuture.complete(null));){
            long regionOffset = spilledRegionManager.findRegion(0, 0, true);
            Assertions.assertThat((long)regionOffset).isEqualTo(-1L);
            Assertions.assertThat(cachedRegionFuture).isNotCompleted();
        }
    }

    @Test
    void testAppendOrOverwriteRegion() throws Exception {
        CompletableFuture cachedRegionFuture = new CompletableFuture();
        try (HsFileDataIndexSpilledRegionManager spilledRegionManager = this.createSpilledRegionManager((ignore1, ignore2) -> cachedRegionFuture.complete(null));){
            HsFileDataIndexImpl.InternalRegion region = HybridShuffleTestUtils.createSingleUnreleasedRegion(0, 0L, 1);
            spilledRegionManager.appendOrOverwriteRegion(0, region);
            Assertions.assertThat(cachedRegionFuture).isNotCompleted();
            FileChannel indexFileChannel = FileChannel.open(this.indexFilePath, StandardOpenOption.READ);
            HsFileDataIndexImpl.InternalRegion readRegion = InternalRegionWriteReadUtils.readRegionFromFile((FileChannel)indexFileChannel, (ByteBuffer)InternalRegionWriteReadUtils.allocateAndConfigureBuffer((int)16), (long)0L);
            HybridShuffleTestUtils.assertRegionEquals(readRegion, region);
            HsFileDataIndexImpl.InternalRegion newRegion = HybridShuffleTestUtils.createSingleUnreleasedRegion(0, 10L, 1);
            spilledRegionManager.appendOrOverwriteRegion(0, newRegion);
            Assertions.assertThat(cachedRegionFuture).isNotCompleted();
            HsFileDataIndexImpl.InternalRegion readNewRegion = InternalRegionWriteReadUtils.readRegionFromFile((FileChannel)indexFileChannel, (ByteBuffer)InternalRegionWriteReadUtils.allocateAndConfigureBuffer((int)16), (long)0L);
            HybridShuffleTestUtils.assertRegionEquals(readNewRegion, newRegion);
        }
    }

    @Test
    void testWriteMoreThanOneSegment() throws Exception {
        List<HsFileDataIndexImpl.InternalRegion> regions = HybridShuffleTestUtils.createAllUnreleasedRegions(0, 0L, 2, 2);
        int segmentSize = regions.stream().mapToInt(HsFileDataIndexImpl.InternalRegion::getSize).sum() + 1;
        try (HsFileDataIndexSpilledRegionManager spilledRegionManager = this.createSpilledRegionManager(segmentSize, (ignore1, ignore2) -> {});){
            spilledRegionManager.appendOrOverwriteRegion(0, regions.get(0));
            spilledRegionManager.appendOrOverwriteRegion(0, regions.get(1));
            HsFileDataIndexImpl.InternalRegion regionInNewSegment = HybridShuffleTestUtils.createSingleUnreleasedRegion(4, 4L, 2);
            spilledRegionManager.appendOrOverwriteRegion(0, regionInNewSegment);
            FileChannel indexFileChannel = FileChannel.open(this.indexFilePath, StandardOpenOption.READ);
            HsFileDataIndexImpl.InternalRegion readRegion = InternalRegionWriteReadUtils.readRegionFromFile((FileChannel)indexFileChannel, (ByteBuffer)InternalRegionWriteReadUtils.allocateAndConfigureBuffer((int)16), (long)segmentSize);
            HybridShuffleTestUtils.assertRegionEquals(readRegion, regionInNewSegment);
        }
    }

    @Test
    void testWriteBigRegion() throws Exception {
        int segmentSize = 4;
        try (HsFileDataIndexSpilledRegionManager spilledRegionManager = this.createSpilledRegionManager(segmentSize, (ignore1, ignore2) -> {});){
            List<HsFileDataIndexImpl.InternalRegion> regions = HybridShuffleTestUtils.createAllUnreleasedRegions(0, 0L, 1, 2);
            HsFileDataIndexImpl.InternalRegion region1 = regions.get(0);
            HsFileDataIndexImpl.InternalRegion region2 = regions.get(1);
            Assertions.assertThat((int)region1.getSize()).isGreaterThan(segmentSize);
            Assertions.assertThat((int)region2.getSize()).isGreaterThan(segmentSize);
            spilledRegionManager.appendOrOverwriteRegion(0, region1);
            spilledRegionManager.appendOrOverwriteRegion(0, region2);
            FileChannel indexFileChannel = FileChannel.open(this.indexFilePath, StandardOpenOption.READ);
            HsFileDataIndexImpl.InternalRegion readRegion1 = InternalRegionWriteReadUtils.readRegionFromFile((FileChannel)indexFileChannel, (ByteBuffer)InternalRegionWriteReadUtils.allocateAndConfigureBuffer((int)16), (long)0L);
            HybridShuffleTestUtils.assertRegionEquals(readRegion1, region1);
            HsFileDataIndexImpl.InternalRegion readRegion2 = InternalRegionWriteReadUtils.readRegionFromFile((FileChannel)indexFileChannel, (ByteBuffer)InternalRegionWriteReadUtils.allocateAndConfigureBuffer((int)16), (long)readRegion1.getSize());
            HybridShuffleTestUtils.assertRegionEquals(readRegion2, region2);
        }
    }

    @Test
    void testFindRegionFirstBufferIndexInMultipleSegments() throws Exception {
        int numBuffersPerRegion = 2;
        boolean subpartition = false;
        ArrayList loadedRegions = new ArrayList();
        try (HsFileDataIndexSpilledRegionManager spilledRegionManager = this.createSpilledRegionManager(36, (ignore, region) -> loadedRegions.add(region));){
            spilledRegionManager.appendOrOverwriteRegion(0, HybridShuffleTestUtils.createSingleUnreleasedRegion(0, 0L, 2));
            spilledRegionManager.appendOrOverwriteRegion(0, HybridShuffleTestUtils.createSingleUnreleasedRegion(9, 9L, 2));
            HsFileDataIndexImpl.InternalRegion targetRegion = HybridShuffleTestUtils.createSingleUnreleasedRegion(2, 2L, 2);
            spilledRegionManager.appendOrOverwriteRegion(0, targetRegion);
            spilledRegionManager.appendOrOverwriteRegion(0, HybridShuffleTestUtils.createSingleUnreleasedRegion(11, 11L, 2));
            spilledRegionManager.appendOrOverwriteRegion(0, HybridShuffleTestUtils.createSingleUnreleasedRegion(7, 7L, 2));
            long regionOffset = spilledRegionManager.findRegion(0, 3, true);
            Assertions.assertThat((long)regionOffset).isNotEqualTo(-1L);
            Assertions.assertThat(loadedRegions).hasSize(2);
            HybridShuffleTestUtils.assertRegionEquals((HsFileDataIndexImpl.InternalRegion)loadedRegions.get(1), targetRegion);
        }
    }

    private HsFileDataIndexSpilledRegionManager createSpilledRegionManager(BiConsumer<Integer, HsFileDataIndexImpl.InternalRegion> cacheRegionConsumer) {
        return this.createSpilledRegionManager(256, cacheRegionConsumer);
    }

    private HsFileDataIndexSpilledRegionManager createSpilledRegionManager(int segmentSize, BiConsumer<Integer, HsFileDataIndexImpl.InternalRegion> cacheRegionConsumer) {
        int numSubpartitions = 2;
        return new HsFileDataIndexSpilledRegionManagerImpl.Factory(segmentSize, Long.MAX_VALUE).create(numSubpartitions, this.indexFilePath, cacheRegionConsumer);
    }
}

