/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.checkpoint.JobManagerTaskRestore;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.deployment.InputGateDeploymentDescriptor;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.JobInformation;
import org.apache.flink.runtime.executiongraph.TaskInformation;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.operators.BatchTask;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TaskDeploymentDescriptorTest
extends TestLogger {
    private static final JobID jobID = new JobID();
    private static final JobVertexID vertexID = new JobVertexID();
    private static final ExecutionAttemptID execId = ExecutionGraphTestUtils.createExecutionAttemptId(vertexID);
    private static final AllocationID allocationId = new AllocationID();
    private static final String jobName = "job name";
    private static final String taskName = "task name";
    private static final int numberOfKeyGroups = 1;
    private static final int currentNumberOfSubtasks = 1;
    private static final Configuration jobConfiguration = new Configuration();
    private static final Configuration taskConfiguration = new Configuration();
    private static final Class<? extends AbstractInvokable> invokableClass = BatchTask.class;
    private static final List<ResultPartitionDeploymentDescriptor> producedResults = new ArrayList<ResultPartitionDeploymentDescriptor>(0);
    private static final List<InputGateDeploymentDescriptor> inputGates = new ArrayList<InputGateDeploymentDescriptor>(0);
    private static final List<PermanentBlobKey> requiredJars = new ArrayList<PermanentBlobKey>(0);
    private static final List<URL> requiredClasspaths = new ArrayList<URL>(0);
    private static final TaskStateSnapshot taskStateHandles = new TaskStateSnapshot();
    private static final JobManagerTaskRestore taskRestore = new JobManagerTaskRestore(1L, taskStateHandles);
    private final SerializedValue<ExecutionConfig> executionConfig = new SerializedValue((Object)new ExecutionConfig());
    private final SerializedValue<JobInformation> serializedJobInformation = new SerializedValue((Object)new JobInformation(jobID, "job name", this.executionConfig, jobConfiguration, requiredJars, requiredClasspaths));
    private final SerializedValue<TaskInformation> serializedJobVertexInformation = new SerializedValue((Object)new TaskInformation(vertexID, "task name", 1, 1, invokableClass.getName(), taskConfiguration));

    @Test
    public void testSerialization() throws Exception {
        TaskDeploymentDescriptor orig = this.createTaskDeploymentDescriptor((TaskDeploymentDescriptor.MaybeOffloaded<JobInformation>)new TaskDeploymentDescriptor.NonOffloaded(this.serializedJobInformation), (TaskDeploymentDescriptor.MaybeOffloaded<TaskInformation>)new TaskDeploymentDescriptor.NonOffloaded(this.serializedJobVertexInformation));
        TaskDeploymentDescriptor copy = (TaskDeploymentDescriptor)CommonTestUtils.createCopySerializable((Serializable)orig);
        Assert.assertFalse((orig.getSerializedJobInformation() == copy.getSerializedJobInformation() ? 1 : 0) != 0);
        Assert.assertFalse((orig.getSerializedTaskInformation() == copy.getSerializedTaskInformation() ? 1 : 0) != 0);
        Assert.assertFalse((orig.getExecutionAttemptId() == copy.getExecutionAttemptId() ? 1 : 0) != 0);
        Assert.assertFalse((orig.getTaskRestore() == copy.getTaskRestore() ? 1 : 0) != 0);
        Assert.assertFalse((orig.getProducedPartitions() == copy.getProducedPartitions() ? 1 : 0) != 0);
        Assert.assertFalse((orig.getInputGates() == copy.getInputGates() ? 1 : 0) != 0);
        Assert.assertEquals((Object)orig.getSerializedJobInformation(), (Object)copy.getSerializedJobInformation());
        Assert.assertEquals((Object)orig.getSerializedTaskInformation(), (Object)copy.getSerializedTaskInformation());
        Assert.assertEquals((Object)orig.getExecutionAttemptId(), (Object)copy.getExecutionAttemptId());
        Assert.assertEquals((Object)orig.getAllocationId(), (Object)copy.getAllocationId());
        Assert.assertEquals((long)orig.getSubtaskIndex(), (long)copy.getSubtaskIndex());
        Assert.assertEquals((long)orig.getAttemptNumber(), (long)copy.getAttemptNumber());
        Assert.assertEquals((long)orig.getTaskRestore().getRestoreCheckpointId(), (long)copy.getTaskRestore().getRestoreCheckpointId());
        Assert.assertEquals((Object)orig.getTaskRestore().getTaskStateSnapshot(), (Object)copy.getTaskRestore().getTaskStateSnapshot());
        Assert.assertEquals((Object)orig.getProducedPartitions(), (Object)copy.getProducedPartitions());
        Assert.assertEquals((Object)orig.getInputGates(), (Object)copy.getInputGates());
    }

    @Test
    public void testOffLoadedAndNonOffLoadedPayload() {
        TaskDeploymentDescriptor taskDeploymentDescriptor = this.createTaskDeploymentDescriptor((TaskDeploymentDescriptor.MaybeOffloaded<JobInformation>)new TaskDeploymentDescriptor.NonOffloaded(this.serializedJobInformation), (TaskDeploymentDescriptor.MaybeOffloaded<TaskInformation>)new TaskDeploymentDescriptor.Offloaded(new PermanentBlobKey()));
        SerializedValue actualSerializedJobInformation = taskDeploymentDescriptor.getSerializedJobInformation();
        Assert.assertThat((Object)actualSerializedJobInformation, (Matcher)Matchers.is(this.serializedJobInformation));
        try {
            taskDeploymentDescriptor.getSerializedTaskInformation();
            Assert.fail((String)"Expected to fail since the task information should be offloaded.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Nonnull
    private TaskDeploymentDescriptor createTaskDeploymentDescriptor(TaskDeploymentDescriptor.MaybeOffloaded<JobInformation> jobInformation, TaskDeploymentDescriptor.MaybeOffloaded<TaskInformation> taskInformation) {
        return new TaskDeploymentDescriptor(jobID, jobInformation, taskInformation, execId, allocationId, taskRestore, producedResults, inputGates);
    }
}

