/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.blocklist.BlockedNode;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.io.network.partition.DataSetMetaInfo;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.JobMasterRegistrationSuccess;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.resourcemanager.ResourceOverview;
import org.apache.flink.runtime.resourcemanager.TaskExecutorRegistration;
import org.apache.flink.runtime.resourcemanager.TaskManagerInfoWithSlots;
import org.apache.flink.runtime.resourcemanager.exceptions.UnknownTaskExecutorException;
import org.apache.flink.runtime.rest.messages.LogInfo;
import org.apache.flink.runtime.rest.messages.ThreadDumpInfo;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerInfo;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.slots.ResourceRequirements;
import org.apache.flink.runtime.taskexecutor.FileType;
import org.apache.flink.runtime.taskexecutor.SlotReport;
import org.apache.flink.runtime.taskexecutor.TaskExecutorHeartbeatPayload;
import org.apache.flink.runtime.taskexecutor.TaskExecutorRegistrationSuccess;
import org.apache.flink.runtime.taskexecutor.TaskExecutorThreadInfoGateway;
import org.apache.flink.runtime.taskexecutor.partition.ClusterPartitionReport;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.function.QuadFunction;

public class TestingResourceManagerGateway
implements ResourceManagerGateway {
    private final ResourceManagerId resourceManagerId;
    private final ResourceID ownResourceId;
    private final String address;
    private final String hostname;
    private volatile QuadFunction<JobMasterId, ResourceID, String, JobID, CompletableFuture<RegistrationResponse>> registerJobManagerFunction;
    private volatile Consumer<Tuple3<JobID, JobStatus, Throwable>> disconnectJobManagerConsumer;
    private volatile Function<TaskExecutorRegistration, CompletableFuture<RegistrationResponse>> registerTaskExecutorFunction;
    private volatile Function<Tuple2<ResourceID, FileType>, CompletableFuture<TransientBlobKey>> requestTaskManagerFileUploadByTypeFunction;
    private volatile Function<Tuple2<ResourceID, String>, CompletableFuture<TransientBlobKey>> requestTaskManagerFileUploadByNameFunction;
    private volatile Consumer<Tuple2<ResourceID, Throwable>> disconnectTaskExecutorConsumer;
    private volatile Function<Tuple3<ResourceID, InstanceID, SlotReport>, CompletableFuture<Acknowledge>> sendSlotReportFunction;
    private volatile BiFunction<ResourceID, TaskExecutorHeartbeatPayload, CompletableFuture<Void>> taskExecutorHeartbeatFunction;
    private volatile Consumer<Tuple3<InstanceID, SlotID, AllocationID>> notifySlotAvailableConsumer;
    private volatile Function<ResourceID, CompletableFuture<Collection<LogInfo>>> requestTaskManagerLogListFunction;
    private volatile Function<ResourceID, CompletableFuture<TaskManagerInfoWithSlots>> requestTaskManagerDetailsInfoFunction;
    private volatile Function<ResourceID, CompletableFuture<TaskExecutorThreadInfoGateway>> requestTaskExecutorThreadInfoGateway;
    private volatile Function<ResourceID, CompletableFuture<ThreadDumpInfo>> requestThreadDumpFunction;
    private volatile BiFunction<JobMasterId, ResourceRequirements, CompletableFuture<Acknowledge>> declareRequiredResourcesFunction = (ignoredA, ignoredB) -> FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    private volatile Function<ResourceID, CompletableFuture<Void>> jobMasterHeartbeatFunction;
    private volatile Function<Collection<BlockedNode>, CompletableFuture<Acknowledge>> notifyNewBlockedNodesFunction = ignored -> CompletableFuture.completedFuture(Acknowledge.get());

    public TestingResourceManagerGateway() {
        this(ResourceManagerId.generate(), ResourceID.generate(), "localhost/" + UUID.randomUUID(), "localhost");
    }

    public TestingResourceManagerGateway(ResourceManagerId resourceManagerId, ResourceID resourceId, String address, String hostname) {
        this.resourceManagerId = (ResourceManagerId)Preconditions.checkNotNull((Object)resourceManagerId);
        this.ownResourceId = (ResourceID)Preconditions.checkNotNull((Object)resourceId);
        this.address = (String)Preconditions.checkNotNull((Object)address);
        this.hostname = (String)Preconditions.checkNotNull((Object)hostname);
    }

    public ResourceID getOwnResourceId() {
        return this.ownResourceId;
    }

    public void setRegisterJobManagerFunction(QuadFunction<JobMasterId, ResourceID, String, JobID, CompletableFuture<RegistrationResponse>> registerJobManagerFunction) {
        this.registerJobManagerFunction = registerJobManagerFunction;
    }

    public void setDisconnectJobManagerConsumer(Consumer<Tuple3<JobID, JobStatus, Throwable>> disconnectJobManagerConsumer) {
        this.disconnectJobManagerConsumer = disconnectJobManagerConsumer;
    }

    public void setRegisterTaskExecutorFunction(Function<TaskExecutorRegistration, CompletableFuture<RegistrationResponse>> registerTaskExecutorFunction) {
        this.registerTaskExecutorFunction = registerTaskExecutorFunction;
    }

    public void setRequestTaskManagerFileUploadByTypeFunction(Function<Tuple2<ResourceID, FileType>, CompletableFuture<TransientBlobKey>> requestTaskManagerFileUploadByTypeFunction) {
        this.requestTaskManagerFileUploadByTypeFunction = requestTaskManagerFileUploadByTypeFunction;
    }

    public void setRequestTaskManagerFileUploadByNameFunction(Function<Tuple2<ResourceID, String>, CompletableFuture<TransientBlobKey>> requestTaskManagerFileUploadByNameFunction) {
        this.requestTaskManagerFileUploadByNameFunction = requestTaskManagerFileUploadByNameFunction;
    }

    public void setRequestTaskManagerLogListFunction(Function<ResourceID, CompletableFuture<Collection<LogInfo>>> requestTaskManagerLogListFunction) {
        this.requestTaskManagerLogListFunction = requestTaskManagerLogListFunction;
    }

    public void setRequestTaskManagerDetailsInfoFunction(Function<ResourceID, CompletableFuture<TaskManagerInfoWithSlots>> requestTaskManagerDetailsInfoFunction) {
        this.requestTaskManagerDetailsInfoFunction = requestTaskManagerDetailsInfoFunction;
    }

    public void setRequestTaskExecutorGatewayFunction(Function<ResourceID, CompletableFuture<TaskExecutorThreadInfoGateway>> requestTaskExecutorThreadInfoGateway) {
        this.requestTaskExecutorThreadInfoGateway = requestTaskExecutorThreadInfoGateway;
    }

    public void setDisconnectTaskExecutorConsumer(Consumer<Tuple2<ResourceID, Throwable>> disconnectTaskExecutorConsumer) {
        this.disconnectTaskExecutorConsumer = disconnectTaskExecutorConsumer;
    }

    public void setSendSlotReportFunction(Function<Tuple3<ResourceID, InstanceID, SlotReport>, CompletableFuture<Acknowledge>> sendSlotReportFunction) {
        this.sendSlotReportFunction = sendSlotReportFunction;
    }

    public void setTaskExecutorHeartbeatFunction(BiFunction<ResourceID, TaskExecutorHeartbeatPayload, CompletableFuture<Void>> taskExecutorHeartbeatFunction) {
        this.taskExecutorHeartbeatFunction = taskExecutorHeartbeatFunction;
    }

    public void setJobMasterHeartbeatFunction(Function<ResourceID, CompletableFuture<Void>> jobMasterHeartbeatFunction) {
        this.jobMasterHeartbeatFunction = jobMasterHeartbeatFunction;
    }

    public void setNotifySlotAvailableConsumer(Consumer<Tuple3<InstanceID, SlotID, AllocationID>> notifySlotAvailableConsumer) {
        this.notifySlotAvailableConsumer = notifySlotAvailableConsumer;
    }

    public void setRequestThreadDumpFunction(Function<ResourceID, CompletableFuture<ThreadDumpInfo>> requestThreadDumpFunction) {
        this.requestThreadDumpFunction = requestThreadDumpFunction;
    }

    public void setDeclareRequiredResourcesFunction(BiFunction<JobMasterId, ResourceRequirements, CompletableFuture<Acknowledge>> declareRequiredResourcesFunction) {
        this.declareRequiredResourcesFunction = declareRequiredResourcesFunction;
    }

    public void setNotifyNewBlockedNodesFunction(Function<Collection<BlockedNode>, CompletableFuture<Acknowledge>> notifyNewBlockedNodesFunction) {
        this.notifyNewBlockedNodesFunction = notifyNewBlockedNodesFunction;
    }

    public CompletableFuture<RegistrationResponse> registerJobMaster(JobMasterId jobMasterId, ResourceID jobMasterResourceId, String jobMasterAddress, JobID jobId, Time timeout) {
        QuadFunction<JobMasterId, ResourceID, String, JobID, CompletableFuture<RegistrationResponse>> currentConsumer = this.registerJobManagerFunction;
        if (currentConsumer != null) {
            return (CompletableFuture)currentConsumer.apply((Object)jobMasterId, (Object)jobMasterResourceId, (Object)jobMasterAddress, (Object)jobId);
        }
        return CompletableFuture.completedFuture(this.getJobMasterRegistrationSuccess());
    }

    public JobMasterRegistrationSuccess getJobMasterRegistrationSuccess() {
        return new JobMasterRegistrationSuccess(this.resourceManagerId, this.ownResourceId);
    }

    public CompletableFuture<Acknowledge> declareRequiredResources(JobMasterId jobMasterId, ResourceRequirements resourceRequirements, Time timeout) {
        return this.declareRequiredResourcesFunction.apply(jobMasterId, resourceRequirements);
    }

    public CompletableFuture<Acknowledge> sendSlotReport(ResourceID taskManagerResourceId, InstanceID taskManagerRegistrationId, SlotReport slotReport, Time timeout) {
        Function<Tuple3<ResourceID, InstanceID, SlotReport>, CompletableFuture<Acknowledge>> currentSendSlotReportFunction = this.sendSlotReportFunction;
        if (currentSendSlotReportFunction != null) {
            return currentSendSlotReportFunction.apply((Tuple3<ResourceID, InstanceID, SlotReport>)Tuple3.of((Object)taskManagerResourceId, (Object)taskManagerRegistrationId, (Object)slotReport));
        }
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public CompletableFuture<RegistrationResponse> registerTaskExecutor(TaskExecutorRegistration taskExecutorRegistration, Time timeout) {
        Function<TaskExecutorRegistration, CompletableFuture<RegistrationResponse>> currentFunction = this.registerTaskExecutorFunction;
        if (currentFunction != null) {
            return currentFunction.apply(taskExecutorRegistration);
        }
        return CompletableFuture.completedFuture(new TaskExecutorRegistrationSuccess(new InstanceID(), this.ownResourceId, new ClusterInformation("localhost", 1234)));
    }

    public void notifySlotAvailable(InstanceID instanceId, SlotID slotID, AllocationID oldAllocationId) {
        Consumer<Tuple3<InstanceID, SlotID, AllocationID>> currentNotifySlotAvailableConsumer = this.notifySlotAvailableConsumer;
        if (currentNotifySlotAvailableConsumer != null) {
            currentNotifySlotAvailableConsumer.accept((Tuple3<InstanceID, SlotID, AllocationID>)Tuple3.of((Object)instanceId, (Object)slotID, (Object)oldAllocationId));
        }
    }

    public CompletableFuture<Acknowledge> deregisterApplication(ApplicationStatus finalStatus, String diagnostics) {
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public CompletableFuture<Integer> getNumberOfRegisteredTaskManagers() {
        return CompletableFuture.completedFuture(0);
    }

    public CompletableFuture<Void> heartbeatFromTaskManager(ResourceID heartbeatOrigin, TaskExecutorHeartbeatPayload heartbeatPayload) {
        BiFunction<ResourceID, TaskExecutorHeartbeatPayload, CompletableFuture<Void>> currentTaskExecutorHeartbeatConsumer = this.taskExecutorHeartbeatFunction;
        if (currentTaskExecutorHeartbeatConsumer != null) {
            return currentTaskExecutorHeartbeatConsumer.apply(heartbeatOrigin, heartbeatPayload);
        }
        return FutureUtils.completedVoidFuture();
    }

    public CompletableFuture<Void> heartbeatFromJobManager(ResourceID heartbeatOrigin) {
        Function<ResourceID, CompletableFuture<Void>> currentJobMasterHeartbeatFunction = this.jobMasterHeartbeatFunction;
        if (currentJobMasterHeartbeatFunction != null) {
            return currentJobMasterHeartbeatFunction.apply(heartbeatOrigin);
        }
        return FutureUtils.completedVoidFuture();
    }

    public void disconnectTaskManager(ResourceID resourceID, Exception cause) {
        Consumer<Tuple2<ResourceID, Throwable>> currentConsumer = this.disconnectTaskExecutorConsumer;
        if (currentConsumer != null) {
            currentConsumer.accept((Tuple2<ResourceID, Throwable>)Tuple2.of((Object)resourceID, (Object)cause));
        }
    }

    public void disconnectJobManager(JobID jobId, JobStatus jobStatus, Exception cause) {
        Consumer<Tuple3<JobID, JobStatus, Throwable>> currentConsumer = this.disconnectJobManagerConsumer;
        if (currentConsumer != null) {
            currentConsumer.accept((Tuple3<JobID, JobStatus, Throwable>)Tuple3.of((Object)jobId, (Object)jobStatus, (Object)cause));
        }
    }

    public CompletableFuture<Collection<TaskManagerInfo>> requestTaskManagerInfo(Time timeout) {
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    public CompletableFuture<TaskManagerInfoWithSlots> requestTaskManagerDetailsInfo(ResourceID resourceId, Time timeout) {
        Function<ResourceID, CompletableFuture<TaskManagerInfoWithSlots>> function = this.requestTaskManagerDetailsInfoFunction;
        if (function != null) {
            return function.apply(resourceId);
        }
        return FutureUtils.completedExceptionally((Throwable)new IllegalStateException("No requestTaskManagerInfoFunction was set."));
    }

    public CompletableFuture<ResourceOverview> requestResourceOverview(Time timeout) {
        return CompletableFuture.completedFuture(new ResourceOverview(1, 1, 1, 0, 0, ResourceProfile.ZERO, ResourceProfile.ZERO));
    }

    public CompletableFuture<Collection<Tuple2<ResourceID, String>>> requestTaskManagerMetricQueryServiceAddresses(Time timeout) {
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    public CompletableFuture<TransientBlobKey> requestTaskManagerFileUploadByType(ResourceID taskManagerId, FileType fileType, Time timeout) {
        Function<Tuple2<ResourceID, FileType>, CompletableFuture<TransientBlobKey>> function = this.requestTaskManagerFileUploadByTypeFunction;
        if (function != null) {
            return function.apply((Tuple2<ResourceID, FileType>)Tuple2.of((Object)taskManagerId, (Object)fileType));
        }
        return CompletableFuture.completedFuture(new TransientBlobKey());
    }

    public CompletableFuture<TransientBlobKey> requestTaskManagerFileUploadByName(ResourceID taskManagerId, String fileName, Time timeout) {
        Function<Tuple2<ResourceID, String>, CompletableFuture<TransientBlobKey>> function = this.requestTaskManagerFileUploadByNameFunction;
        if (function != null) {
            return function.apply((Tuple2<ResourceID, String>)Tuple2.of((Object)taskManagerId, (Object)fileName));
        }
        return CompletableFuture.completedFuture(new TransientBlobKey());
    }

    public CompletableFuture<Collection<LogInfo>> requestTaskManagerLogList(ResourceID taskManagerId, Time timeout) {
        Function<ResourceID, CompletableFuture<Collection<LogInfo>>> function = this.requestTaskManagerLogListFunction;
        if (function != null) {
            return function.apply(taskManagerId);
        }
        return FutureUtils.completedExceptionally((Throwable)new UnknownTaskExecutorException(taskManagerId));
    }

    public CompletableFuture<ThreadDumpInfo> requestThreadDump(ResourceID taskManagerId, Time timeout) {
        Function<ResourceID, CompletableFuture<ThreadDumpInfo>> function = this.requestThreadDumpFunction;
        if (function != null) {
            return function.apply(taskManagerId);
        }
        return FutureUtils.completedExceptionally((Throwable)new UnknownTaskExecutorException(taskManagerId));
    }

    public CompletableFuture<TaskExecutorThreadInfoGateway> requestTaskExecutorThreadInfoGateway(ResourceID taskManagerId, Time timeout) {
        Function<ResourceID, CompletableFuture<TaskExecutorThreadInfoGateway>> function = this.requestTaskExecutorThreadInfoGateway;
        if (function != null) {
            return function.apply(taskManagerId);
        }
        return FutureUtils.completedExceptionally((Throwable)new UnknownTaskExecutorException(taskManagerId));
    }

    public ResourceManagerId getFencingToken() {
        return this.resourceManagerId;
    }

    public String getAddress() {
        return this.address;
    }

    public String getHostname() {
        return this.hostname;
    }

    public CompletableFuture<Map<IntermediateDataSetID, DataSetMetaInfo>> listDataSets() {
        return CompletableFuture.completedFuture(Collections.emptyMap());
    }

    public CompletableFuture<Void> releaseClusterPartitions(IntermediateDataSetID dataSetToRelease) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> reportClusterPartitions(ResourceID taskExecutorId, ClusterPartitionReport clusterPartitionReport) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<ShuffleDescriptor>> getClusterPartitionsShuffleDescriptors(IntermediateDataSetID intermediateDataSetID) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Acknowledge> notifyNewBlockedNodes(Collection<BlockedNode> newNodes) {
        return this.notifyNewBlockedNodesFunction.apply(newNodes);
    }
}

