/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.blocklist.BlocklistHandler;
import org.apache.flink.runtime.blocklist.NoOpBlocklistHandler;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.io.network.partition.NoOpResourceManagerPartitionTracker;
import org.apache.flink.runtime.metrics.groups.ResourceManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdService;
import org.apache.flink.runtime.resourcemanager.StandaloneResourceManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.TestingSlotManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.TestingSlotManagerBuilder;
import org.apache.flink.runtime.resourcemanager.utils.MockResourceManagerRuntimeServices;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.rpc.TestingRpcServiceResource;
import org.apache.flink.runtime.security.token.DelegationTokenManager;
import org.apache.flink.runtime.util.TestingFatalErrorHandler;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class StandaloneResourceManagerTest
extends TestLogger {
    @ClassRule
    public static final TestingRpcServiceResource RPC_SERVICE = new TestingRpcServiceResource();
    private static final Time TIMEOUT = Time.seconds((long)10L);
    private final TestingFatalErrorHandler fatalErrorHandler = new TestingFatalErrorHandler();

    @Test
    public void testStartupPeriod() throws Exception {
        LinkedBlockingQueue setFailUnfulfillableRequestInvokes = new LinkedBlockingQueue();
        TestingSlotManager slotManager = new TestingSlotManagerBuilder().setSetFailUnfulfillableRequestConsumer(setFailUnfulfillableRequestInvokes::add).createSlotManager();
        TestingStandaloneResourceManager rm = this.createResourceManager(Time.milliseconds((long)1L), slotManager);
        Assert.assertThat(setFailUnfulfillableRequestInvokes.take(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat(setFailUnfulfillableRequestInvokes.take(), (Matcher)CoreMatchers.is((Object)true));
        rm.close();
    }

    @Test
    public void testNoStartupPeriod() throws Exception {
        LinkedBlockingQueue setFailUnfulfillableRequestInvokes = new LinkedBlockingQueue();
        TestingSlotManager slotManager = new TestingSlotManagerBuilder().setSetFailUnfulfillableRequestConsumer(setFailUnfulfillableRequestInvokes::add).createSlotManager();
        TestingStandaloneResourceManager rm = this.createResourceManager(Time.milliseconds((long)-1L), slotManager);
        Assert.assertThat(setFailUnfulfillableRequestInvokes.take(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat(setFailUnfulfillableRequestInvokes.poll(50L, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Matcher)IsNull.nullValue()));
        rm.close();
    }

    private TestingStandaloneResourceManager createResourceManager(Time startupPeriod, SlotManager slotManager) throws Exception {
        MockResourceManagerRuntimeServices rmServices = new MockResourceManagerRuntimeServices(RPC_SERVICE.getTestingRpcService(), slotManager);
        TestingStandaloneResourceManager rm = new TestingStandaloneResourceManager(rmServices.rpcService, UUID.randomUUID(), ResourceID.generate(), rmServices.heartbeatServices, rmServices.delegationTokenManager, rmServices.slotManager, rmServices.jobLeaderIdService, new ClusterInformation("localhost", 1234), this.fatalErrorHandler, UnregisteredMetricGroups.createUnregisteredResourceManagerMetricGroup(), startupPeriod);
        rm.start();
        rm.getStartedFuture().get(TIMEOUT.getSize(), TIMEOUT.getUnit());
        return rm;
    }

    private static class TestingStandaloneResourceManager
    extends StandaloneResourceManager {
        private TestingStandaloneResourceManager(RpcService rpcService, UUID leaderSessionId, ResourceID resourceId, HeartbeatServices heartbeatServices, DelegationTokenManager delegationTokenManager, SlotManager slotManager, JobLeaderIdService jobLeaderIdService, ClusterInformation clusterInformation, FatalErrorHandler fatalErrorHandler, ResourceManagerMetricGroup resourceManagerMetricGroup, Time startupPeriodTime) {
            super(rpcService, leaderSessionId, resourceId, heartbeatServices, delegationTokenManager, slotManager, NoOpResourceManagerPartitionTracker::get, (BlocklistHandler.Factory)new NoOpBlocklistHandler.Factory(), jobLeaderIdService, clusterInformation, fatalErrorHandler, resourceManagerMetricGroup, startupPeriodTime, RpcUtils.INF_TIMEOUT, (Executor)ForkJoinPool.commonPool());
        }
    }
}

