/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.UUID;
import org.apache.flink.core.testutils.CheckedThread;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.runtime.leaderelection.DefaultLeaderElectionService;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriverFactory;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderelection.TestingContender;
import org.apache.flink.runtime.leaderelection.TestingLeaderElectionDriver;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.function.RunnableWithException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DefaultLeaderElectionServiceTest
extends TestLogger {
    private static final String TEST_URL = "akka//user/jobmanager";

    @Test
    public void testOnGrantAndRevokeLeadership() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    this.testingLeaderElectionDriver.isLeader();
                    this.testingContender.waitForLeader();
                    Assert.assertThat((Object)this.testingContender.getDescription(), (Matcher)Matchers.is((Object)DefaultLeaderElectionServiceTest.TEST_URL));
                    Assert.assertThat((Object)this.testingContender.getLeaderSessionID(), (Matcher)Matchers.is((Object)this.leaderElectionService.getLeaderSessionID()));
                    Assert.assertThat((Object)this.testingLeaderElectionDriver.getLeaderInformation(), (Matcher)Matchers.is((Object)LeaderInformation.known((UUID)this.leaderElectionService.getLeaderSessionID(), (String)DefaultLeaderElectionServiceTest.TEST_URL)));
                    this.testingLeaderElectionDriver.notLeader();
                    this.testingContender.waitForRevokeLeader();
                    Assert.assertThat((Object)this.testingContender.getLeaderSessionID(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
                    Assert.assertThat((Object)this.leaderElectionService.getLeaderSessionID(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
                    Assert.assertThat((Object)this.testingLeaderElectionDriver.getLeaderInformation(), (Matcher)Matchers.is((Object)LeaderInformation.empty()));
                });
            }
        };
    }

    @Test
    public void testLeaderInformationChangedAndShouldBeCorrected() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    this.testingLeaderElectionDriver.isLeader();
                    LeaderInformation expectedLeader = LeaderInformation.known((UUID)this.leaderElectionService.getLeaderSessionID(), (String)DefaultLeaderElectionServiceTest.TEST_URL);
                    this.testingLeaderElectionDriver.leaderInformationChanged(LeaderInformation.empty());
                    Assert.assertThat((Object)this.testingLeaderElectionDriver.getLeaderInformation(), (Matcher)Matchers.is((Object)expectedLeader));
                    this.testingLeaderElectionDriver.leaderInformationChanged(LeaderInformation.known((UUID)UUID.randomUUID(), (String)"faulty-address"));
                    Assert.assertThat((Object)this.testingLeaderElectionDriver.getLeaderInformation(), (Matcher)Matchers.is((Object)expectedLeader));
                });
            }
        };
    }

    @Test
    public void testHasLeadership() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    this.testingLeaderElectionDriver.isLeader();
                    UUID currentLeaderSessionId = this.leaderElectionService.getLeaderSessionID();
                    Assert.assertThat((Object)currentLeaderSessionId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                    Assert.assertThat((Object)this.leaderElectionService.hasLeadership(currentLeaderSessionId), (Matcher)Matchers.is((Object)true));
                    Assert.assertThat((Object)this.leaderElectionService.hasLeadership(UUID.randomUUID()), (Matcher)Matchers.is((Object)false));
                    this.leaderElectionService.stop();
                    Assert.assertThat((Object)this.leaderElectionService.hasLeadership(currentLeaderSessionId), (Matcher)Matchers.is((Object)false));
                });
            }
        };
    }

    @Test
    public void testLeaderInformationChangedIfNotBeingLeader() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    LeaderInformation faultyLeader = LeaderInformation.known((UUID)UUID.randomUUID(), (String)"faulty-address");
                    this.testingLeaderElectionDriver.leaderInformationChanged(faultyLeader);
                    Assert.assertThat((Object)this.testingLeaderElectionDriver.getLeaderInformation(), (Matcher)Matchers.is((Object)faultyLeader));
                });
            }
        };
    }

    @Test
    public void testOnGrantLeadershipIsIgnoredAfterBeingStop() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    this.leaderElectionService.stop();
                    this.testingLeaderElectionDriver.isLeader();
                    Assert.assertThat((Object)this.testingContender.getLeaderSessionID(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
                });
            }
        };
    }

    @Test
    public void testOnLeaderInformationChangeIsIgnoredAfterBeingStop() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    this.testingLeaderElectionDriver.isLeader();
                    this.leaderElectionService.stop();
                    this.testingLeaderElectionDriver.leaderInformationChanged(LeaderInformation.empty());
                    Assert.assertThat((Object)this.testingLeaderElectionDriver.getLeaderInformation(), (Matcher)Matchers.is((Object)LeaderInformation.empty()));
                });
            }
        };
    }

    @Test
    public void testOnRevokeLeadershipIsIgnoredAfterBeingStop() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    this.testingLeaderElectionDriver.isLeader();
                    UUID oldSessionId = this.leaderElectionService.getLeaderSessionID();
                    Assert.assertThat((Object)this.testingContender.getLeaderSessionID(), (Matcher)Matchers.is((Object)oldSessionId));
                    this.leaderElectionService.stop();
                    this.testingLeaderElectionDriver.notLeader();
                    Assert.assertThat((Object)this.testingContender.getLeaderSessionID(), (Matcher)Matchers.is((Object)oldSessionId));
                });
            }
        };
    }

    @Test
    public void testOldConfirmLeaderInformation() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    this.testingLeaderElectionDriver.isLeader();
                    UUID currentLeaderSessionId = this.leaderElectionService.getLeaderSessionID();
                    Assert.assertThat((Object)currentLeaderSessionId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                    this.leaderElectionService.confirmLeadership(UUID.randomUUID(), DefaultLeaderElectionServiceTest.TEST_URL);
                    Assert.assertThat((Object)this.leaderElectionService.getLeaderSessionID(), (Matcher)Matchers.is((Object)currentLeaderSessionId));
                });
            }
        };
    }

    @Test
    public void testErrorForwarding() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    Exception testException = new Exception("test leader exception");
                    this.testingLeaderElectionDriver.onFatalError(testException);
                    this.testingContender.waitForError();
                    Assert.assertThat((Object)this.testingContender.getError(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                    Assert.assertThat((Object)this.testingContender.getError(), (Matcher)FlinkMatchers.containsCause((Throwable)testException));
                });
            }
        };
    }

    @Test
    public void testErrorIsIgnoredAfterBeingStop() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    Exception testException = new Exception("test leader exception");
                    this.leaderElectionService.stop();
                    this.testingLeaderElectionDriver.onFatalError(testException);
                    Assert.assertThat((Object)this.testingContender.getError(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
                });
            }
        };
    }

    @Test
    public void testServiceShutDownWithSynchronizedDriver() throws Exception {
        TestingLeaderElectionDriver.TestingLeaderElectionDriverFactory testingLeaderElectionDriverFactory = new TestingLeaderElectionDriver.TestingLeaderElectionDriverFactory();
        DefaultLeaderElectionService leaderElectionService = new DefaultLeaderElectionService((LeaderElectionDriverFactory)testingLeaderElectionDriverFactory);
        TestingContender testingContender = new TestingContender(TEST_URL, (LeaderElectionService)leaderElectionService);
        leaderElectionService.start((LeaderContender)testingContender);
        final TestingLeaderElectionDriver currentLeaderDriver = (TestingLeaderElectionDriver)Preconditions.checkNotNull((Object)testingLeaderElectionDriverFactory.getCurrentLeaderDriver());
        CheckedThread isLeaderThread = new CheckedThread(){

            public void go() {
                currentLeaderDriver.isLeader();
            }
        };
        isLeaderThread.start();
        leaderElectionService.stop();
        isLeaderThread.sync();
    }

    private class Context {
        final TestingLeaderElectionDriver.TestingLeaderElectionDriverFactory testingLeaderElectionDriverFactory = new TestingLeaderElectionDriver.TestingLeaderElectionDriverFactory();
        final DefaultLeaderElectionService leaderElectionService = new DefaultLeaderElectionService((LeaderElectionDriverFactory)this.testingLeaderElectionDriverFactory);
        final TestingContender testingContender = new TestingContender("akka//user/jobmanager", (LeaderElectionService)this.leaderElectionService);
        TestingLeaderElectionDriver testingLeaderElectionDriver;

        private Context() {
        }

        void runTest(RunnableWithException testMethod) throws Exception {
            this.leaderElectionService.start((LeaderContender)this.testingContender);
            this.testingLeaderElectionDriver = this.testingLeaderElectionDriverFactory.getCurrentLeaderDriver();
            Assert.assertThat((Object)this.testingLeaderElectionDriver, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            testMethod.run();
            this.leaderElectionService.stop();
        }
    }
}

