/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.SlotInfoWithUtilization;
import org.apache.flink.runtime.jobmaster.slotpool.TestingDeclarativeSlotPoolBuilder;
import org.apache.flink.runtime.slots.ResourceRequirement;
import org.apache.flink.runtime.taskexecutor.slot.SlotOffer;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.util.ResourceCounter;
import org.apache.flink.util.function.QuadFunction;
import org.apache.flink.util.function.TriFunction;

final class TestingDeclarativeSlotPool
implements DeclarativeSlotPool {
    private final Consumer<ResourceCounter> increaseResourceRequirementsByConsumer;
    private final Consumer<ResourceCounter> decreaseResourceRequirementsByConsumer;
    private final Supplier<Collection<ResourceRequirement>> getResourceRequirementsSupplier;
    private final QuadFunction<Collection<? extends SlotOffer>, TaskManagerLocation, TaskManagerGateway, Long, Collection<SlotOffer>> offerSlotsFunction;
    private final QuadFunction<Collection<? extends SlotOffer>, TaskManagerLocation, TaskManagerGateway, Long, Collection<SlotOffer>> registerSlotsFunction;
    private final Supplier<Collection<SlotInfoWithUtilization>> getFreeSlotsInformationSupplier;
    private final Supplier<Collection<? extends SlotInfo>> getAllSlotsInformationSupplier;
    private final BiFunction<ResourceID, Exception, ResourceCounter> releaseSlotsFunction;
    private final BiFunction<AllocationID, Exception, ResourceCounter> releaseSlotFunction;
    private final BiFunction<AllocationID, ResourceProfile, PhysicalSlot> reserveFreeSlotFunction;
    private final TriFunction<AllocationID, Throwable, Long, ResourceCounter> freeReservedSlotFunction;
    private final Function<ResourceID, Boolean> containsSlotsFunction;
    private final Function<AllocationID, Boolean> containsFreeSlotFunction;
    private final LongConsumer releaseIdleSlotsConsumer;
    private final Consumer<ResourceCounter> setResourceRequirementsConsumer;

    TestingDeclarativeSlotPool(Consumer<ResourceCounter> increaseResourceRequirementsByConsumer, Consumer<ResourceCounter> decreaseResourceRequirementsByConsumer, Supplier<Collection<ResourceRequirement>> getResourceRequirementsSupplier, QuadFunction<Collection<? extends SlotOffer>, TaskManagerLocation, TaskManagerGateway, Long, Collection<SlotOffer>> offerSlotsFunction, QuadFunction<Collection<? extends SlotOffer>, TaskManagerLocation, TaskManagerGateway, Long, Collection<SlotOffer>> registerSlotsFunction, Supplier<Collection<SlotInfoWithUtilization>> getFreeSlotsInformationSupplier, Supplier<Collection<? extends SlotInfo>> getAllSlotsInformationSupplier, BiFunction<ResourceID, Exception, ResourceCounter> releaseSlotsFunction, BiFunction<AllocationID, Exception, ResourceCounter> releaseSlotFunction, BiFunction<AllocationID, ResourceProfile, PhysicalSlot> reserveFreeSlotFunction, TriFunction<AllocationID, Throwable, Long, ResourceCounter> freeReservedSlotFunction, Function<ResourceID, Boolean> containsSlotsFunction, Function<AllocationID, Boolean> containsFreeSlotFunction, LongConsumer releaseIdleSlotsConsumer, Consumer<ResourceCounter> setResourceRequirementsConsumer) {
        this.increaseResourceRequirementsByConsumer = increaseResourceRequirementsByConsumer;
        this.decreaseResourceRequirementsByConsumer = decreaseResourceRequirementsByConsumer;
        this.getResourceRequirementsSupplier = getResourceRequirementsSupplier;
        this.offerSlotsFunction = offerSlotsFunction;
        this.registerSlotsFunction = registerSlotsFunction;
        this.getFreeSlotsInformationSupplier = getFreeSlotsInformationSupplier;
        this.getAllSlotsInformationSupplier = getAllSlotsInformationSupplier;
        this.releaseSlotsFunction = releaseSlotsFunction;
        this.releaseSlotFunction = releaseSlotFunction;
        this.reserveFreeSlotFunction = reserveFreeSlotFunction;
        this.freeReservedSlotFunction = freeReservedSlotFunction;
        this.containsSlotsFunction = containsSlotsFunction;
        this.containsFreeSlotFunction = containsFreeSlotFunction;
        this.releaseIdleSlotsConsumer = releaseIdleSlotsConsumer;
        this.setResourceRequirementsConsumer = setResourceRequirementsConsumer;
    }

    public void increaseResourceRequirementsBy(ResourceCounter increment) {
        this.increaseResourceRequirementsByConsumer.accept(increment);
    }

    public void decreaseResourceRequirementsBy(ResourceCounter decrement) {
        this.decreaseResourceRequirementsByConsumer.accept(decrement);
    }

    public void setResourceRequirements(ResourceCounter resourceRequirements) {
        this.setResourceRequirementsConsumer.accept(resourceRequirements);
    }

    public Collection<ResourceRequirement> getResourceRequirements() {
        return this.getResourceRequirementsSupplier.get();
    }

    public Collection<SlotOffer> offerSlots(Collection<? extends SlotOffer> offers, TaskManagerLocation taskManagerLocation, TaskManagerGateway taskManagerGateway, long currentTime) {
        return (Collection)this.offerSlotsFunction.apply(offers, (Object)taskManagerLocation, (Object)taskManagerGateway, (Object)currentTime);
    }

    public Collection<SlotOffer> registerSlots(Collection<? extends SlotOffer> slots, TaskManagerLocation taskManagerLocation, TaskManagerGateway taskManagerGateway, long currentTime) {
        return (Collection)this.registerSlotsFunction.apply(slots, (Object)taskManagerLocation, (Object)taskManagerGateway, (Object)currentTime);
    }

    public Collection<SlotInfoWithUtilization> getFreeSlotsInformation() {
        return this.getFreeSlotsInformationSupplier.get();
    }

    public Collection<? extends SlotInfo> getAllSlotsInformation() {
        return this.getAllSlotsInformationSupplier.get();
    }

    public boolean containsFreeSlot(AllocationID allocationId) {
        return this.containsFreeSlotFunction.apply(allocationId);
    }

    public ResourceCounter releaseSlots(ResourceID owner, Exception cause) {
        return this.releaseSlotsFunction.apply(owner, cause);
    }

    public ResourceCounter releaseSlot(AllocationID allocationId, Exception cause) {
        return this.releaseSlotFunction.apply(allocationId, cause);
    }

    public PhysicalSlot reserveFreeSlot(AllocationID allocationId, ResourceProfile requiredSlotProfile) {
        return this.reserveFreeSlotFunction.apply(allocationId, requiredSlotProfile);
    }

    public ResourceCounter freeReservedSlot(AllocationID allocationId, @Nullable Throwable cause, long currentTime) {
        return (ResourceCounter)this.freeReservedSlotFunction.apply((Object)allocationId, (Object)cause, (Object)currentTime);
    }

    public boolean containsSlots(ResourceID owner) {
        return this.containsSlotsFunction.apply(owner);
    }

    public void releaseIdleSlots(long currentTimeMillis) {
        this.releaseIdleSlotsConsumer.accept(currentTimeMillis);
    }

    public void registerNewSlotsListener(DeclarativeSlotPool.NewSlotsListener listener) {
    }

    public static TestingDeclarativeSlotPoolBuilder builder() {
        return new TestingDeclarativeSlotPoolBuilder();
    }
}

