/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import org.apache.flink.runtime.jobmaster.JobManagerRunnerResult;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionGraphBuilder;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class JobManagerRunnerResultTest
extends TestLogger {
    private final ExecutionGraphInfo executionGraphInfo = new ExecutionGraphInfo(new ArchivedExecutionGraphBuilder().build());
    private final FlinkException testException = new FlinkException("test exception");

    @Test
    public void testSuccessfulJobManagerResult() {
        JobManagerRunnerResult jobManagerRunnerResult = JobManagerRunnerResult.forSuccess((ExecutionGraphInfo)this.executionGraphInfo);
        Assert.assertTrue((boolean)jobManagerRunnerResult.isSuccess());
        Assert.assertFalse((boolean)jobManagerRunnerResult.isInitializationFailure());
    }

    @Test
    public void testInitializationFailureJobManagerResult() {
        JobManagerRunnerResult jobManagerRunnerResult = JobManagerRunnerResult.forInitializationFailure((ExecutionGraphInfo)this.executionGraphInfo, (Throwable)this.testException);
        Assert.assertTrue((boolean)jobManagerRunnerResult.isInitializationFailure());
        Assert.assertFalse((boolean)jobManagerRunnerResult.isSuccess());
    }

    @Test
    public void testGetArchivedExecutionGraphFromSuccessfulJobManagerResult() {
        JobManagerRunnerResult jobManagerRunnerResult = JobManagerRunnerResult.forSuccess((ExecutionGraphInfo)this.executionGraphInfo);
        Assert.assertThat((Object)jobManagerRunnerResult.getExecutionGraphInfo(), (Matcher)CoreMatchers.is((Object)this.executionGraphInfo));
    }

    @Test
    public void testGetInitializationFailureFromFailedJobManagerResult() {
        JobManagerRunnerResult jobManagerRunnerResult = JobManagerRunnerResult.forInitializationFailure((ExecutionGraphInfo)this.executionGraphInfo, (Throwable)this.testException);
        Assert.assertThat((Object)jobManagerRunnerResult.getInitializationFailure(), (Matcher)CoreMatchers.is((Object)((Object)this.testException)));
    }

    @Test(expected=IllegalStateException.class)
    public void testGetInitializationFailureFromSuccessfulJobManagerResult() {
        JobManagerRunnerResult jobManagerRunnerResult = JobManagerRunnerResult.forSuccess((ExecutionGraphInfo)this.executionGraphInfo);
        jobManagerRunnerResult.getInitializationFailure();
    }
}

