/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.stream.Stream;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.SchedulerExecutionMode;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.jobmaster.DefaultSlotPoolServiceSchedulerFactory;
import org.apache.flink.runtime.jobmaster.slotpool.PreferredAllocationRequestSlotMatchingStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.RequestSlotMatchingStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SimpleRequestSlotMatchingStrategy;
import org.apache.flink.runtime.scheduler.DefaultSchedulerFactory;
import org.apache.flink.runtime.scheduler.adaptive.AdaptiveSchedulerFactory;
import org.apache.flink.util.TestLoggerExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@ExtendWith(value={TestLoggerExtension.class})
public class DefaultSlotPoolServiceSchedulerFactoryTest {
    @Test
    public void testFallsBackToDefaultSchedulerIfBatchJob() {
        Configuration configuration = new Configuration();
        configuration.set(JobManagerOptions.SCHEDULER, (Object)JobManagerOptions.SchedulerType.Adaptive);
        DefaultSlotPoolServiceSchedulerFactory defaultSlotPoolServiceSchedulerFactory = DefaultSlotPoolServiceSchedulerFactory.fromConfiguration((Configuration)configuration, (JobType)JobType.BATCH);
        Assertions.assertThat((Object)defaultSlotPoolServiceSchedulerFactory.getSchedulerNGFactory()).isInstanceOf(DefaultSchedulerFactory.class);
        Assertions.assertThat((Comparable)defaultSlotPoolServiceSchedulerFactory.getSchedulerType()).isEqualTo((Object)JobManagerOptions.SchedulerType.Default);
    }

    @Test
    public void testAdaptiveSchedulerForReactiveMode() {
        Configuration configuration = new Configuration();
        configuration.set(JobManagerOptions.SCHEDULER_MODE, (Object)SchedulerExecutionMode.REACTIVE);
        DefaultSlotPoolServiceSchedulerFactory defaultSlotPoolServiceSchedulerFactory = DefaultSlotPoolServiceSchedulerFactory.fromConfiguration((Configuration)configuration, (JobType)JobType.STREAMING);
        Assertions.assertThat((Object)defaultSlotPoolServiceSchedulerFactory.getSchedulerNGFactory()).isInstanceOf(AdaptiveSchedulerFactory.class);
        Assertions.assertThat((Comparable)defaultSlotPoolServiceSchedulerFactory.getSchedulerType()).isEqualTo((Object)JobManagerOptions.SchedulerType.Adaptive);
    }

    @ParameterizedTest
    @MethodSource(value={"testGetRequestSlotMatchingStrategy"})
    public void testGetRequestSlotMatchingStrategy(boolean isLocalRecoveryEnabled, JobType jobType, RequestSlotMatchingStrategy expected) {
        Configuration configuration = new Configuration();
        configuration.set(CheckpointingOptions.LOCAL_RECOVERY, (Object)isLocalRecoveryEnabled);
        Assertions.assertThat((Object)DefaultSlotPoolServiceSchedulerFactory.getRequestSlotMatchingStrategy((Configuration)configuration, (JobType)jobType)).isSameAs((Object)expected);
    }

    private static Stream<Arguments> testGetRequestSlotMatchingStrategy() {
        return Stream.of(Arguments.of((Object[])new Object[]{false, JobType.BATCH, SimpleRequestSlotMatchingStrategy.INSTANCE}), Arguments.of((Object[])new Object[]{false, JobType.STREAMING, SimpleRequestSlotMatchingStrategy.INSTANCE}), Arguments.of((Object[])new Object[]{true, JobType.BATCH, SimpleRequestSlotMatchingStrategy.INSTANCE}), Arguments.of((Object[])new Object[]{true, JobType.STREAMING, PreferredAllocationRequestSlotMatchingStrategy.INSTANCE}));
    }
}

